/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.vecmath.Color4f;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.VoxelCubeHistogram;
import main.tools.ToolSegGen;
import misc.Voxel;
import misc.grid.RegularGrid3i;
import misc.helper.Interpolation;
import misc.messages.YObservable;
import misc.messages.YObserver;
import misc.messages.YObserverWantsAWTThread;
import raycaster.SegmentTfMerger;
import raycaster.gui.GuiControlPoint;
import raycaster.gui.GuiTransferFunction;
import raycaster.gui.RenderOptionTab;
import raycaster.gui.SegmentService;
import raycaster.gui.StyleChooser;
import raycaster.gui.StyleImage;
import raycaster.gui.TransferFunctionTab;
import raycaster.renderer.RenderMethod;
import raycaster.settings.ControlPoint;
import raycaster.settings.TransferFunctionSetting;
import renderer.SegmentColorTableMap;
import settings.Settings;
import settings.SettingsOwner;

public final class TransferFunctionPanel
extends JPanel
implements YObserverWantsAWTThread,
SettingsOwner {
    public static final String OPT_USE_OPACITY_LOG = Settings.register_bool_opt(TransferFunctionPanel.class, "Use logarithm", "Use logarithmic scaling for the opacity value", false);
    public static final String OPT_CONTROL_POINT_SIZE = Settings.register_int_opt(TransferFunctionPanel.class, "ControlPoint Size", "The width / height of transfer function control points", 11);
    private Segment _seg = SegmentService.ALL_VOXELS_SEGMENT;
    private GuiTransferFunction _current_transfer_function = new GuiTransferFunction();
    private final Map<Segment, GuiTransferFunction> _transfer_function_map = new LinkedHashMap<Segment, GuiTransferFunction>();
    private final List<YObserver> _transfer_function_observers = new ArrayList<YObserver>();
    private final StyleChooser _style_chooser;
    private final SegmentService _segment_service;
    private volatile BufferedImage _bimg;
    private int _img_left;
    private int _img_right;
    private int _img_bottom;
    private int _img_top;
    private boolean _use_log;
    private static final float EXPONENT = 6.0f;
    private GuiControlPoint _hovered;
    private boolean _drag;
    private final int LEFT_OFF = 10;
    private final int RIGHT_OFF = 10;
    private final int TOP_OFF = 10;
    private final int BOTTOM_OFF = 15;

    public TransferFunctionPanel(StyleChooser style_chooser, SegmentService segment_service) {
        ImageStack is = MasterControl.get_is();
        this._style_chooser = style_chooser;
        this._segment_service = segment_service;
        this._segment_service.addObserver(this, "TransferFunctionPanel()");
        is.addObserver(this, "TransferFunctionPanel()");
        Settings.register_class_listener(TransferFunctionTab.class, this);
        Settings.register_class_listener(TransferFunctionPanel.class, this);
        is.get_vch().addObserver(this, "TransferFunctionPanel()");
        this.add_transfer_function_observer(this);
        this._current_transfer_function.addObserver(this, "TransferFunctionPanel()");
        this._transfer_function_map.put(this._seg, this._current_transfer_function);
        for (String s : is.get_seg_map().keySet()) {
            this.add_segment(is.get_segment(s));
        }
        this._hovered = null;
        this._drag = false;
        this._bimg = null;
        this._use_log = Settings.get_bool_option(TransferFunctionPanel.class, OPT_USE_OPACITY_LOG);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = Math.max(TransferFunctionPanel.this._img_left, Math.min(TransferFunctionPanel.this._img_right, e.getX()));
                int y = Math.max(TransferFunctionPanel.this._img_top, Math.min(TransferFunctionPanel.this._img_bottom, e.getY()));
                int density = TransferFunctionPanel.this.pos_x_to_density(x);
                float opacity = TransferFunctionPanel.this.pos_y_to_opacity(y);
                switch (e.getButton()) {
                    case 2: {
                        if (TransferFunctionPanel.this._hovered == null) break;
                        TransferFunctionPanel.this._current_transfer_function.remove(TransferFunctionPanel.this._hovered);
                        break;
                    }
                    case 3: {
                        if (TransferFunctionPanel.this._hovered == null) break;
                        if (e.isShiftDown()) {
                            TransferFunctionPanel.this._style_chooser.set_color_and_repaint(TransferFunctionPanel.this._hovered.get_color().get());
                            TransferFunctionPanel.this._style_chooser.set_style_and_repaint(TransferFunctionPanel.this._hovered.get_style());
                            break;
                        }
                        TransferFunctionPanel.this._hovered.set_color(new Color4f(TransferFunctionPanel.this._style_chooser.get_color()));
                        TransferFunctionPanel.this._hovered.set_style(TransferFunctionPanel.this._style_chooser.get_style());
                        break;
                    }
                    default: {
                        if (TransferFunctionPanel.this._hovered != null) break;
                        RenderMethod.Style style_type = TransferFunctionPanel.this._style_chooser.get_display_mode();
                        Color4f cp_color = new Color4f(TransferFunctionPanel.this._style_chooser.get_color());
                        StyleImage cp_style = TransferFunctionPanel.this._style_chooser.get_style();
                        GuiControlPoint new_cp = new GuiControlPoint(density, opacity, style_type, cp_color, cp_style);
                        TransferFunctionPanel.this._hovered = new_cp;
                        TransferFunctionPanel.this._current_transfer_function.add(new_cp);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && TransferFunctionPanel.this._hovered != null) {
                    TransferFunctionPanel.this._drag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TransferFunctionPanel.this._drag = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TransferFunctionPanel.this._drag) {
                    int x = Math.max(TransferFunctionPanel.this._img_left, Math.min(TransferFunctionPanel.this._img_right, e.getX()));
                    int y = Math.max(TransferFunctionPanel.this._img_top, Math.min(TransferFunctionPanel.this._img_bottom, e.getY()));
                    int density = TransferFunctionPanel.this.pos_x_to_density(x);
                    float opacity = TransferFunctionPanel.this.pos_y_to_opacity(y);
                    TransferFunctionPanel.this._current_transfer_function.move(TransferFunctionPanel.this._hovered, density, opacity);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                GuiControlPoint near = TransferFunctionPanel.this.find_point_near(e.getX(), e.getY());
                if (TransferFunctionPanel.this._hovered != near) {
                    TransferFunctionPanel.this._hovered = near;
                    TransferFunctionPanel.this.repaint();
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponents(g2);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.get_voxel_histogram();
        this.draw_voxel_histogram(g2);
        this.draw_axis_labels(g2);
        this.draw_vertical_line_at_seed_position(g2);
        this.draw_background_transfer_functions(g2);
        this.draw_active_transfer_function(g2);
    }

    private void get_voxel_histogram() {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 2 && this.resize_if_needed()) {
            boolean use_logarithmic = true;
            boolean show_all = false;
            MasterControl.get_is().get_vch().render_image(this._bimg, Color.WHITE, Color.LIGHT_GRAY, true, false);
        }
    }

    private void draw_voxel_histogram(Graphics g) {
        g.drawImage(this._bimg, this._img_left, this._img_top, this._bimg.getWidth(), this._bimg.getHeight(), null);
    }

    private void draw_axis_labels(Graphics2D g) {
        g.setColor(Color.black);
        g.drawString("density", this.getWidth() / 2, this.getHeight() - 3);
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int char_height = fm.getHeight() - 1;
        String opacity_str = "opacity";
        int i = 0;
        while (i < "opacity".length()) {
            g.drawString("opacity".substring(i, i + 1), 2, 5 + (i + 1) * char_height);
            ++i;
        }
    }

    private void draw_vertical_line_at_seed_position(Graphics2D g) {
        g.setColor(new Color(64, 64, 64, 128));
        for (Voxel v : MasterControl.get_is().get_seeds()) {
            int seed_density = MasterControl.get_is().get_voxel_cube().get(v._x, v._y, v._z);
            int seed_x = this.density_to_pos_x(seed_density);
            g.drawLine(seed_x, this._img_top, seed_x, this._img_bottom);
        }
    }

    private void draw_background_transfer_functions(Graphics2D g) {
        for (Map.Entry<Segment, GuiTransferFunction> entry : this._transfer_function_map.entrySet()) {
            Segment segment = entry.getKey();
            if (segment == this._seg) continue;
            GuiTransferFunction transfer_function = entry.getValue();
            g.setColor(new Color(segment.get_color()));
            this.draw_transfer_function_points(g, segment, transfer_function);
            this.draw_transfer_function(g, segment, transfer_function);
        }
    }

    private void draw_active_transfer_function(Graphics2D g) {
        g.setColor(Color.BLACK);
        this.draw_transfer_function_points(g, this._seg, this._current_transfer_function);
        this.draw_transfer_function(g, this._seg, this._current_transfer_function);
    }

    private void draw_transfer_function_points(Graphics2D g, Segment segment, GuiTransferFunction transfer_function) {
        for (GuiControlPoint cp : transfer_function) {
            int x = this.density_to_pos_x(cp.get_intensity());
            int y = this.opacity_to_pos_y(cp.get_opacity());
            g.translate(x, y);
            if (cp == this._hovered) {
                cp.paint(g, transfer_function.get_render_method(), true);
            } else {
                cp.paint(g, transfer_function.get_render_method(), false);
            }
            g.translate(-x, -y);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void draw_transfer_function(Graphics g, Segment segment, GuiTransferFunction transfer_function) {
        int prev_x = -1;
        int prev_y = -1;
        Iterator<GuiControlPoint> iterator = transfer_function.iterator();
        if (!iterator.hasNext()) {
            g.drawLine(this._img_left, this._img_bottom, this._img_right, this._img_bottom);
            return;
        }
        GuiControlPoint cp = iterator.next();
        int x = this.density_to_pos_x(cp.get_intensity());
        int y = this.opacity_to_pos_y(cp.get_opacity());
        prev_x = x;
        prev_y = y;
        g.drawLine(this._img_left, this._img_bottom, x, this._img_bottom);
        g.drawLine(x, this._img_bottom, x, y);
        while (iterator.hasNext()) {
            cp = iterator.next();
            x = this.density_to_pos_x(cp.get_intensity());
            y = this.opacity_to_pos_y(cp.get_opacity());
            if (prev_x != -1) {
                g.drawLine(prev_x, prev_y, x, y);
            }
            prev_x = x;
            prev_y = y;
        }
        g.drawLine(prev_x, prev_y, prev_x, this._img_bottom);
        g.drawLine(prev_x, this._img_bottom, this._img_right, this._img_bottom);
    }

    private boolean resize_if_needed() {
        int img_width = this.getWidth() - 10 - 10;
        int img_height = this.getHeight() - 10 - 15;
        if (this._bimg == null || this._bimg.getWidth() != img_width || this._bimg.getHeight() != img_height) {
            this._img_top = 10;
            this._img_left = 10;
            this._img_bottom = this.getHeight() - 15 - 1;
            this._img_right = this.getWidth() - 10 - 1;
            this._bimg = new BufferedImage(img_width, img_height, 2);
            return true;
        }
        return false;
    }

    public GuiTransferFunction get_current_transfer_function() {
        return this._current_transfer_function;
    }

    public GuiTransferFunction get_transfer_function(Segment segment) {
        return this._transfer_function_map.get(segment);
    }

    private float pos_y_to_opacity(int y) {
        float opacity = Interpolation.linear(y, this._img_bottom, this._img_top, 0.0f, 1.0f);
        if (this._use_log) {
            return ((float)Math.pow(6.0, opacity) - 1.0f) / 5.0f;
        }
        return opacity;
    }

    private int opacity_to_pos_y(float opacity) {
        float fy = opacity;
        if (this._use_log) {
            fy = (float)(Math.log(fy * 5.0f + 1.0f) / Math.log(6.0));
        }
        return Math.round(Interpolation.linear(fy, 0.0f, 1.0f, this._img_bottom, this._img_top));
    }

    private int pos_x_to_density(int x) {
        VoxelCubeHistogram vch = MasterControl.get_is().get_vch();
        return Interpolation.linear_int(x, this._img_left, this._img_right, vch._min_nonzero_index, vch._max_nonzero_index);
    }

    private int density_to_pos_x(int d) {
        VoxelCubeHistogram vch = MasterControl.get_is().get_vch();
        return Interpolation.linear_int(d, vch._min_nonzero_index, vch._max_nonzero_index, this._img_left, this._img_right);
    }

    private GuiControlPoint find_point_near(int x, int y) {
        Iterator<GuiControlPoint> cp_iterator = this._current_transfer_function.iterator();
        int point_size = GuiControlPoint.get_point_size();
        int point_size_halfed = point_size / 2 + 1;
        while (cp_iterator.hasNext()) {
            GuiControlPoint cp = cp_iterator.next();
            int cp_x = this.density_to_pos_x(cp.get_intensity());
            int cp_y = this.opacity_to_pos_y(cp.get_opacity());
            if (this.values_are_within_range(x, cp_x, point_size_halfed) && this.values_are_within_range(y, cp_y, point_size_halfed)) {
                return cp;
            }
            if (this.intensity_is_too_big(x, point_size_halfed, cp_x)) break;
        }
        return null;
    }

    private boolean values_are_within_range(int value1, int value2, int epsilon) {
        return Math.abs(value1 - value2) < epsilon;
    }

    private boolean intensity_is_too_big(int x, int point_size_halfed, int cp_x) {
        return cp_x > x + point_size_halfed;
    }

    public void clear_current_transfer_function() {
        this._current_transfer_function.clear();
    }

    public void select_transfer_function(Segment segment) {
        this._seg = segment;
        this._current_transfer_function = this._transfer_function_map.get(segment);
    }

    public void add_transfer_function_observer(YObserver observer) {
        this._transfer_function_observers.add(observer);
    }

    public void set_transfer_function(Segment segment, TransferFunctionSetting setting) {
        GuiTransferFunction tf = this._transfer_function_map.get(segment);
        if (tf != null) {
            tf.clear();
            tf.set_render_method(setting.get_render_method());
            for (ControlPoint cp : setting) {
                GuiControlPoint gcp = new GuiControlPoint(cp);
                tf.add(gcp);
            }
        }
    }

    @Override
    public void update(YObservable o, Message m) {
        if (o.getClass() == Segment.class) {
            this.repaint();
        } else if (o.getClass() == GuiTransferFunction.class) {
            this.repaint();
            this.update_3d_preview(o, m);
        } else if (m._type == SegmentService.M_SEGMENT_ACTIVATION_CHANGED) {
            this.update_3d_preview(o, m);
        } else if (m._type == SegmentService.M_SEGMENT_POSITION_CHANGED) {
            SegmentTfMerger tf_merger = (SegmentTfMerger)Settings.get_enum_option(TransferFunctionTab.class, TransferFunctionTab.OPT_SEGMENT_TF_MERGE_MODE);
            if (tf_merger.considers_order()) {
                this.update_3d_preview(o, m);
            }
        } else if (m._type == VoxelCubeHistogram.M_VCH_UPDATE) {
            if (this._bimg != null) {
                MasterControl.get_is().get_vch().render_image(this._bimg, Color.WHITE, Color.LIGHT_GRAY, true, false);
            }
        } else if (m._type == ImageStack.M_SELECTXYZ) {
            this.repaint();
        } else if (m._type == ImageStack.M_CLEAR || m._type == ImageStack.M_LOADING_START) {
            this._current_transfer_function.clear();
            this._transfer_function_map.clear();
            this._transfer_function_map.put(SegmentService.ALL_VOXELS_SEGMENT, this._current_transfer_function);
        } else if (m._type == ImageStack.M_NEW_SEGMENT) {
            Segment seg = (Segment)m._obj;
            this.add_segment(seg);
        } else if (m._type == ImageStack.M_DEL_SEGMENT) {
            Segment seg = (Segment)m._obj;
            seg.deleteObserver(this);
            this._transfer_function_map.remove(seg);
        }
    }

    private void add_segment(Segment seg) {
        if (seg.get_name() != ToolSegGen.TMP_SEG_NAME) {
            GuiTransferFunction tf = new GuiTransferFunction();
            for (YObserver observer : this._transfer_function_observers) {
                tf.addObserver(observer, "TransferFunctionPanel::update new segment");
            }
            seg.addObserver(this, "TransferFunctionPanel::update new segment");
            this._transfer_function_map.put(seg, tf);
        }
    }

    private void update_3d_preview(YObservable o, Message m) {
        SegmentColorTableMap color_table_map = this.create_color_table_map();
        for (YObserver observer : this._transfer_function_observers) {
            if (observer == this) continue;
            observer.update(o, new Message(m._type, color_table_map));
        }
    }

    private SegmentColorTableMap create_color_table_map() {
        RegularGrid3i voxel_cube = MasterControl.get_is().get_voxel_cube();
        GuiTransferFunction global_transfer_function = this._transfer_function_map.get(SegmentService.ALL_VOXELS_SEGMENT);
        int[] global_color_table = global_transfer_function.get_color_table();
        SegmentTfMerger tf_merger = (SegmentTfMerger)Settings.get_enum_option(TransferFunctionTab.class, TransferFunctionTab.OPT_SEGMENT_TF_MERGE_MODE);
        SegmentColorTableMap color_table_map = new SegmentColorTableMap(tf_merger, voxel_cube, global_color_table);
        List<Segment> segment_list = this._segment_service.get_segment_list();
        for (Segment segment : segment_list) {
            GuiTransferFunction transfer_function = this._transfer_function_map.get(segment);
            int[] segment_color_table = transfer_function.get_color_table();
            color_table_map.add_segment(segment, segment_color_table);
        }
        return color_table_map;
    }

    @Override
    public final String get_name() {
        return "tf panel for offline rendering";
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj == TransferFunctionPanel.class) {
            if (opt_name == OPT_USE_OPACITY_LOG) {
                this._use_log = Settings.get_bool_option(TransferFunctionPanel.class, OPT_USE_OPACITY_LOG);
            }
            this.repaint();
        } else if (obj == TransferFunctionTab.class) {
            if (opt_name == TransferFunctionTab.OPT_RENDER_METHOD) {
                this._current_transfer_function.set_render_method((RenderMethod)((Object)opt));
                this.repaint();
            }
            if (opt_name == TransferFunctionTab.OPT_SEGMENT_TF_MERGE_MODE) {
                this.update_3d_preview(this._current_transfer_function, new Message(RenderOptionTab.M_SEGMENT_TF_MERGER_CHANGED));
            }
        }
    }
}

