/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import gui.SegSelector;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.vecmath.Color4f;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import misc.messages.YObservable;
import misc.messages.YObserver;
import misc.messages.YObserverWantsAWTThread;
import raycaster.SegmentNormalMerger;
import raycaster.SegmentTfMerger;
import raycaster.gui.GuiControlPoint;
import raycaster.gui.GuiTransferFunction;
import raycaster.gui.SegSelectorWithAllVoxelsSegment;
import raycaster.gui.SegmentService;
import raycaster.gui.StyleChooser;
import raycaster.gui.TransferFunctionPanel;
import raycaster.renderer.RenderMethod;
import raycaster.settings.SegmentSetting;
import raycaster.settings.SegmentSettings;
import settings.JBoolOptionCheckbox;
import settings.JEnumOptionComboBox;
import settings.Settings;
import settings.SettingsOwner;

public final class TransferFunctionTab
extends GMPanel
implements YObserverWantsAWTThread,
SettingsOwner {
    public static final String OPT_RENDER_METHOD = Settings.register_enum_opt(TransferFunctionTab.class, "Render Method", "Method used to render voxel data", RenderMethod.LSM_DEFAULT);
    public static final String OPT_SEGMENT_TF_MERGE_MODE = Settings.register_enum_opt(TransferFunctionTab.class, "Segment TF merge mode", "Determines how to merge the different Segment Transfer Functions", SegmentTfMerger.AVERAGE);
    public static final String OPT_SEGMENT_NORMAL_MERGE_MODE = Settings.register_enum_opt(TransferFunctionTab.class, "Segment Normal merge mode", "Determines how to merge data and segment normals", SegmentNormalMerger.GLOBAL_NORMAL);
    public static final String OPT_CONTOUR_THICKNESS = Settings.register_double_opt(TransferFunctionTab.class, "Contour Thickness", "Contour Thickness in voxel dimension (works with LSM_CURVATURE_CONTOURS / LSM_DOT_PRODUCT_CONTOURS), also has effect on the illustrative transparency setting", 0.0);
    public static final String OPT_USE_TRANSPARENCY = Settings.register_bool_opt(TransferFunctionTab.class, "Use illustrative transparency", "Use illustrative transparency (this is affected by the contour thickness of each segment)", false);
    public static final String OPT_CROP_SIZE = Settings.register_int_opt(TransferFunctionTab.class, "Crop LitSphereMaps", "Cuts off specified number of pixels on all four side (use when getting out of LSM-Area)", 3);
    public static final String OPT_CONTOUR_COLOR = Settings.register_color_opt(TransferFunctionTab.class, "Contour color", "Sets the contour color (works with LSM_CURVATURE_CONTOURS / LSM_DOT_PRODUCT_CONTOURS)", new Color(255, 255, 255));
    public static final String OPT_USE_ACCURATE_SURFACE_DETECTION = Settings.register_bool_opt(TransferFunctionTab.class, "Accurate segment surface detection", "Approximates the segment surface more accurately and thus better surface normals", false);
    private final SegmentService _segment_service;
    private final SegSelectorWithAllVoxelsSegment _segment_selector;
    private final JButton _jb_clear_tf;
    private final StyleChooser _style_chooser;
    private final JBoolOptionCheckbox _jboc_use_log_opacity;
    private final TransferFunctionPanel _tf_panel;
    private final JEnumOptionComboBox _jeocb_render_method_selector;

    TransferFunctionTab(SegmentService segment_service, TransferFunctionPanel tf_panel, StyleChooser style_chooser) {
        this._segment_service = segment_service;
        this._jeocb_render_method_selector = new JEnumOptionComboBox(TransferFunctionTab.class, OPT_RENDER_METHOD);
        this._tf_panel = tf_panel;
        this._segment_selector = new SegSelectorWithAllVoxelsSegment(this._segment_service);
        this._segment_selector.addPropertyChangeListener(SegSelector.SEG_SELECTION_CHANGED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Segment selected_segment = TransferFunctionTab.this._segment_selector.get_selected_segment();
                TransferFunctionTab.this._tf_panel.select_transfer_function(selected_segment);
                TransferFunctionTab.this._tf_panel.repaint();
                Settings.set_class_enum_option(TransferFunctionTab.class, OPT_RENDER_METHOD, TransferFunctionTab.this._tf_panel.get_current_transfer_function().get_render_method());
            }
        });
        this._jb_clear_tf = new JButton("clear");
        this._jb_clear_tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferFunctionTab.this._tf_panel.clear_current_transfer_function();
            }
        });
        this._style_chooser = style_chooser;
        this._jboc_use_log_opacity = new JBoolOptionCheckbox(TransferFunctionPanel.class, TransferFunctionPanel.OPT_USE_OPACITY_LOG);
        this.add("_segment_selector", this._segment_selector);
        this.add("_jeocb_render_method_selector", this._jeocb_render_method_selector);
        this.add("_jb_clear_tf", this._jb_clear_tf);
        this.add("_tf_panel", this._tf_panel);
        this.add("_style_chooser", this._style_chooser);
        this.add("_jboc_use_log_opacity", this._jboc_use_log_opacity);
        this.set_layout("<table border='0' width='100%' height='100%'>  <tr height='99%'>    <td fill='both' width='1%'>::_segment_selector::</td>    <td fill='both' width='99%'>::_tf_panel::</td>  </tr><tr height='1%'>    <td fill='both' colspan='2'>      <table anchor='center' border='0'>        <tr>          <td anchor='east'>Render Method</td>          <td anchor='west'>::_jeocb_render_method_selector::</td>          <td>::_style_chooser::</td>          <td>::_jboc_use_log_opacity::</td>          <td>::_jb_clear_tf::</td>        </tr>      </table>    </td>  </tr></table>");
        MasterControl.get_is().addObserver(this, "TransferFunctionTab()");
        Settings.register_owner(this);
    }

    public static RenderMethod get_current_render_method() {
        return (RenderMethod)Settings.get_enum_option(TransferFunctionTab.class, OPT_RENDER_METHOD);
    }

    public GuiTransferFunction get_current_transfer_function() {
        return this._tf_panel.get_current_transfer_function();
    }

    public GuiTransferFunction get_transfer_function(Segment segment) {
        return this._tf_panel.get_transfer_function(segment);
    }

    public void add_transfer_function_observer(YObserver observer) {
        this._tf_panel.add_transfer_function_observer(observer);
    }

    public final SegmentSettings get_segment_settings() {
        SegmentSettings segment_settings = new SegmentSettings();
        segment_settings.set_use_accurate_surface_detection(Settings.get_bool_option(TransferFunctionTab.class, OPT_USE_ACCURATE_SURFACE_DETECTION));
        segment_settings.set_segment_tf_merge_mode((SegmentTfMerger)Settings.get_enum_option(TransferFunctionTab.class, OPT_SEGMENT_TF_MERGE_MODE));
        this.add_segment_settings(segment_settings);
        this.set_values_for_segment_settings(segment_settings);
        return segment_settings;
    }

    private void add_segment_settings(SegmentSettings segment_settings) {
        List<Segment> segment_list = this._segment_service.get_segment_list();
        for (Segment segment : segment_list) {
            segment_settings.add_segment(segment, this.get_transfer_function(segment).get_settings());
        }
    }

    private void set_values_for_segment_settings(SegmentSettings segment_settings) {
        for (SegmentSetting setting : segment_settings) {
            Segment segment = setting.segment();
            setting.set_segment_normal_merger(this._segment_service.get_segment_normal_merger(segment));
            setting.set_surface_opacity(this._segment_service.get_surface_opacity(segment));
            setting.set_surface_rendering(this._segment_service.is_surface_rendering(segment));
            setting.set_show_backplane(this._segment_service.is_show_backplane(segment));
            setting.set_contour_color(new Color4f(this._segment_service.get_contour_color(segment)));
            setting.set_contour_thickness(this._segment_service.get_contour_thickness(segment));
        }
    }

    public final void set_segment_settings(SegmentSettings segment_settings) {
        Settings.set_class_enum_option(TransferFunctionTab.class, OPT_SEGMENT_TF_MERGE_MODE, segment_settings.get_segment_tf_merge_mode());
        Segment active_segment = this._segment_selector.get_selected_segment();
        Settings.set_class_bool_option(TransferFunctionTab.class, OPT_USE_ACCURATE_SURFACE_DETECTION, segment_settings.get_use_accurate_surface_detection());
        this.set_transfer_functions_from_segment_settings(segment_settings);
        this.set_values_from_segment_settings(segment_settings);
        Settings.set_class_enum_option(TransferFunctionTab.class, OPT_SEGMENT_NORMAL_MERGE_MODE, this._segment_service.get_segment_normal_merger(active_segment));
    }

    private void set_transfer_functions_from_segment_settings(SegmentSettings segment_settings) {
        for (SegmentSetting seg_setting : segment_settings) {
            Segment segment = seg_setting.segment();
            this._tf_panel.set_transfer_function(segment, seg_setting.get_transfer_function());
        }
    }

    private void set_values_from_segment_settings(SegmentSettings segment_settings) {
        for (SegmentSetting setting : segment_settings) {
            Segment segment = setting.segment();
            this._segment_service.set_surface_opacity(segment, setting.get_surface_opacity());
            this._segment_service.set_segment_normal_merger(segment, setting.get_segment_normal_merger());
            this._segment_service.set_surface_rendering(segment, setting.is_surface_rendering());
            this._segment_service.set_show_backplane(segment, setting.is_show_backplane());
            this._segment_service.set_contour_color(segment, setting.get_contour_color().get());
            this._segment_service.set_contour_thickness(segment, setting.get_contour_thickness());
        }
    }

    @Override
    public void update(YObservable o, Message m) {
        int cfr_ignored_0 = m._type;
    }

    private void set_default_transfer_function() {
        int roi_max;
        ImageStack is = MasterControl.get_is();
        double slope = is.get_slope();
        double intercept = is.get_intercept();
        int window_center = is.get_grey_window_center();
        int window_width = is.get_grey_window_width();
        int roi_center = (int)(((double)window_center - intercept) / slope);
        int roi_min = roi_center - window_width / 2;
        int max_voxel_value = is.get_voxel_value_range() - 1;
        if (roi_min < 0) {
            roi_min = 0;
        }
        if (roi_min > max_voxel_value) {
            roi_min = max_voxel_value;
        }
        if ((roi_max = roi_center + window_width / 2) < 0) {
            roi_max = 0;
        }
        if (roi_max > max_voxel_value) {
            roi_max = max_voxel_value;
        }
        this._tf_panel.get_transfer_function(SegmentService.ALL_VOXELS_SEGMENT).add(new GuiControlPoint(roi_min, 0.0f));
        this._tf_panel.get_transfer_function(SegmentService.ALL_VOXELS_SEGMENT).add(new GuiControlPoint(roi_max, 0.5f));
    }

    @Override
    public void settings_changed(Object obj, String optName, Object opt) {
    }

    @Override
    public String get_name() {
        return "TransferFunctionTab";
    }
}

