/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.util.Iterator;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import main.tools.ToolRayCasting;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import raycaster.gui.GuiControlPoint;
import raycaster.gui.GuiTransferFunction;
import raycaster.gui.StyleChooser;
import raycaster.gui.StyleImage;
import raycaster.gui.TransferFunctionTab;
import raycaster.renderer.RenderMethod;
import settings.Settings;

public class TransferFunctionTest {
    private final float epsilon = 1.0E-4f;
    private GuiTransferFunction _tf;
    private final int _density = 34;
    private final float _opacity = 0.4f;
    private final Color4f _color = new Color4f(1.0f, 0.0f, 0.0f, 0.0f);
    private StyleImage _style;

    @Before
    public void init() {
        Settings.register_str_opt(ToolRayCasting.class, "resources directory", "", "resources");
        Settings.set_class_enum_option(TransferFunctionTab.class, TransferFunctionTab.OPT_RENDER_METHOD, RenderMethod.PHONG_SHADING);
        this._tf = new GuiTransferFunction();
        this._style = StyleChooser.get_default_style();
    }

    @Test
    public void test_insert() {
        GuiControlPoint cp = new GuiControlPoint(34, 0.4f);
        cp.set_color(this._color);
        cp.set_style(this._style);
        this._tf.add(cp);
        Iterator<GuiControlPoint> it = this._tf.iterator();
        GuiControlPoint cp_test = it.next();
        Assert.assertSame((Object)cp, (Object)cp_test);
        Assert.assertEquals((long)34L, (long)cp_test.get_intensity());
        Assert.assertEquals((double)0.4f, (double)cp_test.get_opacity(), (double)1.0E-4f);
        Assert.assertNotSame((Object)this._color, (Object)cp_test.get_color());
        Assert.assertEquals((Object)this._color, (Object)cp_test.get_color());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void test_clear() {
        this._tf.add(new GuiControlPoint(34, 0.4f));
        this._tf.add(new GuiControlPoint(35, 0.4f));
        this._tf.add(new GuiControlPoint(36, 0.4f));
        Iterator<GuiControlPoint> it = this._tf.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertNotNull((Object)it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertNotNull((Object)it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertNotNull((Object)it.next());
        Assert.assertFalse((boolean)it.hasNext());
        this._tf.clear();
        it = this._tf.iterator();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void test_sorted_iterator() {
        this._tf.add(new GuiControlPoint(245, 0.4f));
        this._tf.add(new GuiControlPoint(12, 0.4f));
        this._tf.add(new GuiControlPoint(912, 0.4f));
        this._tf.add(new GuiControlPoint(900, 0.4f));
        this._tf.add(new GuiControlPoint(123, 0.4f));
        Iterator<GuiControlPoint> it = this._tf.iterator();
        int d_prev = it.next().get_intensity();
        while (it.hasNext()) {
            int d = it.next().get_intensity();
            Assert.assertTrue((d > d_prev ? 1 : 0) != 0);
            d_prev = d;
        }
    }

    @Test
    public void test_calculate_color_table() {
        Color4f[] color_table;
        int ct_size = 100;
        GuiControlPoint cp1 = new GuiControlPoint(50, 0.5f);
        cp1.set_color(new Color4f(1.0f, 0.0f, 0.0f, 1.0f));
        GuiControlPoint cp2 = new GuiControlPoint(70, 0.3f);
        cp2.set_color(new Color4f(0.0f, 1.0f, 0.5f, 1.0f));
        GuiControlPoint cp3 = new GuiControlPoint(10, 0.7f);
        cp3.set_color(new Color4f(0.4f, 0.2f, 0.5f, 1.0f));
        Color4f result_cp1 = new Color4f(1.0f, 0.0f, 0.0f, 0.5f);
        Color4f result_cp2 = new Color4f(0.0f, 1.0f, 0.5f, 0.3f);
        Color4f result_cp3 = new Color4f(0.4f, 0.2f, 0.5f, 0.7f);
        Color4f tmp_color = new Color4f();
        Color4f[] color4fArray = color_table = this._tf.calculateColorTable(100);
        int n = color_table.length;
        int n2 = 0;
        while (n2 < n) {
            Color4f c = color4fArray[n2];
            Assert.assertEquals((double)0.0, (double)c.w, (double)0.0);
            ++n2;
        }
        this._tf.add(cp1);
        color_table = this._tf.calculateColorTable(100);
        Assert.assertEquals((Object)result_cp1, (Object)color_table[cp1.get_intensity()]);
        int i = 0;
        while (i < cp1.get_intensity()) {
            Assert.assertEquals((double)0.0, (double)color_table[i].w, (double)1.0E-4f);
            ++i;
        }
        i = cp1.get_intensity() + 1;
        while (i < 100) {
            Assert.assertEquals((double)0.0, (double)color_table[i].w, (double)1.0E-4f);
            ++i;
        }
        this._tf.add(cp2);
        color_table = this._tf.calculateColorTable(100);
        Assert.assertEquals((Object)result_cp1, (Object)color_table[cp1.get_intensity()]);
        Assert.assertEquals((Object)result_cp2, (Object)color_table[cp2.get_intensity()]);
        int checkpoint = (cp1.get_intensity() + cp2.get_intensity()) / 2;
        tmp_color.interpolate((Tuple4f)result_cp1, (Tuple4f)result_cp2, 0.5f);
        Assert.assertEquals((Object)tmp_color, (Object)color_table[checkpoint]);
        int i2 = 0;
        while (i2 < cp1.get_intensity()) {
            Assert.assertEquals((double)0.0, (double)color_table[i2].w, (double)1.0E-4f);
            ++i2;
        }
        i2 = cp2.get_intensity() + 1;
        while (i2 < 100) {
            Assert.assertEquals((double)0.0, (double)color_table[i2].w, (double)1.0E-4f);
            ++i2;
        }
        this._tf.add(cp3);
        color_table = this._tf.calculateColorTable(100);
        Assert.assertEquals((Object)result_cp1, (Object)color_table[cp1.get_intensity()]);
        Assert.assertEquals((Object)result_cp2, (Object)color_table[cp2.get_intensity()]);
        Assert.assertEquals((Object)result_cp3, (Object)color_table[cp3.get_intensity()]);
        checkpoint = (cp1.get_intensity() + cp2.get_intensity()) / 2;
        tmp_color.interpolate((Tuple4f)result_cp1, (Tuple4f)result_cp2, 0.5f);
        Assert.assertEquals((Object)tmp_color, (Object)color_table[checkpoint]);
        checkpoint = (cp3.get_intensity() + cp1.get_intensity()) / 2;
        tmp_color.interpolate((Tuple4f)result_cp3, (Tuple4f)result_cp1, 0.5f);
        Assert.assertEquals((Object)tmp_color, (Object)color_table[checkpoint]);
        i2 = 0;
        while (i2 < cp3.get_intensity()) {
            Assert.assertEquals((double)0.0, (double)color_table[i2].w, (double)1.0E-4f);
            ++i2;
        }
        i2 = cp2.get_intensity() + 1;
        while (i2 < 100) {
            Assert.assertEquals((double)0.0, (double)color_table[i2].w, (double)1.0E-4f);
            ++i2;
        }
    }
}

