/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import javax.vecmath.Color4f;
import raycaster.renderer.RenderData;
import raycaster.renderer.Renderer;
import raycaster.settings.SegmentSetting;

public final class CurvatureRenderer
extends Renderer {
    private final float _contour_thickness;

    public CurvatureRenderer(RenderData render_data, SegmentSetting segment_setting, Color4f return_color) {
        super(render_data, return_color);
        this._contour_thickness = segment_setting.get_contour_thickness();
    }

    @Override
    public void calculate_sample_color() {
        if (this._contour_thickness > 0.0f) {
            this._return_color.x = this._render_data.curvature * this._contour_thickness;
            this._return_color.y = this._render_data.curvature * this._contour_thickness;
            this._return_color.z = this._render_data.curvature * this._contour_thickness;
            this._return_color.w = 1.0f;
        }
    }

    @Override
    public boolean needs_curvature() {
        return true;
    }
}

