/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import raycaster.LitSphereMap;
import raycaster.renderer.LSMRenderer;
import raycaster.renderer.RenderData;
import raycaster.settings.RenderSettings;
import raycaster.settings.SegmentSetting;

public final class LSMCurvatureBasedContourRenderer
extends LSMRenderer {
    private final Color4f _contour_color;
    private LitSphereMap _left_map;
    private LitSphereMap _right_map;
    private float _ray_surface_product_abs;

    public LSMCurvatureBasedContourRenderer(RenderData render_data, RenderSettings render_settings, SegmentSetting segment_setting, Color4f return_color) {
        super(render_data, render_settings, segment_setting.get_transfer_function(), return_color);
        this._contour_color = new Color4f(segment_setting.get_contour_color());
    }

    @Override
    public void calculate_sample_color() {
        this._return_color.x = 0.0f;
        this._return_color.y = 0.0f;
        this._return_color.z = 0.0f;
        this._return_color.w = 0.0f;
        int i = (int)this._render_data.intensity;
        this._left_map = this._left_maps[i];
        this._right_map = this._right_maps[i];
        if (this._left_map == null || this._right_map == null) {
            return;
        }
        this._ray_surface_product_abs = this._render_data.ray_surface_product;
        if (this._ray_surface_product_abs < 0.0f) {
            this._ray_surface_product_abs = -this._ray_surface_product_abs;
        }
        if (this._ray_surface_product_abs <= this._render_data.contour_threshold) {
            this._return_color.set((Tuple4f)this._contour_color);
        } else {
            float weight = (this._render_data.intensity - (float)this._left_map.get_intensity()) / (float)(this._right_map.get_intensity() - this._left_map.get_intensity());
            this._left_map.addSampleWeighted(this._render_data.nx, this._render_data.ny, 1.0f - weight);
            this._right_map.addSampleWeighted(this._render_data.nx, this._render_data.ny, weight);
        }
    }

    @Override
    public boolean needs_contour_threshold() {
        return true;
    }

    @Override
    public boolean needs_ray_surface_product() {
        return true;
    }
}

