/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import javax.vecmath.Color4f;
import raycaster.LitSphereMap;
import raycaster.renderer.LSMRenderer;
import raycaster.renderer.RenderData;
import raycaster.settings.RenderSettings;
import raycaster.settings.TransferFunctionSetting;

public final class LSMDefaultRenderer
extends LSMRenderer {
    private float _left_intensity;
    private float _right_intensity;
    private LitSphereMap _left_map;
    private LitSphereMap _right_map;

    public LSMDefaultRenderer(RenderData render_data, RenderSettings render_settings, TransferFunctionSetting transfer_function, Color4f return_color) {
        super(render_data, render_settings, transfer_function, return_color);
    }

    @Override
    public void calculate_sample_color() {
        this._return_color.x = 0.0f;
        this._return_color.y = 0.0f;
        this._return_color.z = 0.0f;
        this._return_color.w = 0.0f;
        this._map_index = (int)this._render_data.intensity;
        this._left_map = this._left_maps[this._map_index];
        this._right_map = this._right_maps[this._map_index];
        if (this._left_map == null || this._right_map == null) {
            return;
        }
        this._left_intensity = this._left_map.get_intensity();
        this._right_intensity = this._right_map.get_intensity();
        float weight = (this._render_data.intensity - this._left_intensity) / (this._right_intensity - this._left_intensity);
        this._left_map.addSampleWeighted(this._render_data.nx, this._render_data.ny, 1.0f - weight);
        this._right_map.addSampleWeighted(this._render_data.nx, this._render_data.ny, weight);
    }
}

