/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Color4f;
import raycaster.LitSphereMap;
import raycaster.gui.StyleImage;
import raycaster.renderer.RenderData;
import raycaster.renderer.Renderer;
import raycaster.settings.ControlPoint;
import raycaster.settings.RenderSettings;
import raycaster.settings.TransferFunctionSetting;

public abstract class LSMRenderer
extends Renderer {
    protected final LitSphereMap[] _left_maps;
    protected final LitSphereMap[] _right_maps;
    protected final TransferFunctionSetting _transfer_function;
    protected int _map_index;

    public LSMRenderer(RenderData render_data, RenderSettings render_settings, TransferFunctionSetting transfer_function, Color4f return_color) {
        super(render_data, return_color);
        int max_voxel_value = render_settings.get_render_info().get_max_voxel_value();
        this._left_maps = new LitSphereMap[max_voxel_value + 1];
        this._right_maps = new LitSphereMap[max_voxel_value + 1];
        this._transfer_function = transfer_function;
        Iterator<LitSphereMap> map_iter = this.lit_sphere_list_iterator(render_settings);
        LitSphereMap left = null;
        if (map_iter.hasNext()) {
            LitSphereMap right = map_iter.next();
            while (map_iter.hasNext()) {
                left = right;
                right = map_iter.next();
                int i = left.get_intensity();
                while (i < right.get_intensity()) {
                    this._left_maps[i] = left;
                    this._right_maps[i] = right;
                    ++i;
                }
            }
        }
    }

    private Iterator<LitSphereMap> lit_sphere_list_iterator(RenderSettings render_settings) {
        Iterator<ControlPoint> control_point_iter = this._transfer_function.get_control_points().iterator();
        ArrayList<LitSphereMap> lit_sphere_list = new ArrayList<LitSphereMap>();
        while (control_point_iter.hasNext()) {
            ControlPoint point = control_point_iter.next();
            try {
                StyleImage style = StyleImage.create(point.get_style_source());
                lit_sphere_list.add(new LitSphereMap(style.get_image(), point.get_opacity(), point.get_intensity(), this._return_color));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lit_sphere_list.iterator();
    }

    @Override
    public boolean needs_intensity() {
        return true;
    }

    @Override
    public boolean needs_normal() {
        return true;
    }
}

