/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import javax.vecmath.Color4f;
import raycaster.LitSphereMap;
import raycaster.renderer.LSMRenderer;
import raycaster.renderer.RenderData;
import raycaster.settings.RenderSettings;
import raycaster.settings.TransferFunctionSetting;

public final class LSMStyleContourRenderer
extends LSMRenderer {
    private LitSphereMap _left_map;
    private LitSphereMap _right_map;
    private float _length;
    private float _contour_scaling_factor;
    private float _x;
    private float _y;
    private float _ray_surface_product_abs;
    private float _max_term;

    public LSMStyleContourRenderer(RenderData render_data, RenderSettings render_settings, TransferFunctionSetting transfer_function, Color4f return_color) {
        super(render_data, render_settings, transfer_function, return_color);
    }

    @Override
    public void calculate_sample_color() {
        this._return_color.x = 0.0f;
        this._return_color.y = 0.0f;
        this._return_color.z = 0.0f;
        this._return_color.w = 0.0f;
        this._x = this._render_data.nx;
        this._y = this._render_data.ny;
        this._ray_surface_product_abs = this._render_data.ray_surface_product;
        if (this._ray_surface_product_abs < 0.0f) {
            this._ray_surface_product_abs = -this._ray_surface_product_abs;
        }
        this._max_term = this._render_data.contour_threshold - this._ray_surface_product_abs;
        if (this._max_term < 0.0f) {
            this._max_term = 0.0f;
        }
        this._contour_scaling_factor = 1.0f - this._max_term / this._render_data.contour_threshold;
        if (this._contour_scaling_factor > 0.0f) {
            this._x /= this._contour_scaling_factor;
            this._y /= this._contour_scaling_factor;
        }
        this._length = (float)Math.sqrt(this._x * this._x + this._y * this._y);
        if (this._length > 1.0f) {
            this._x /= this._length;
            this._y /= this._length;
        }
        int i = (int)this._render_data.intensity;
        this._left_map = this._left_maps[i];
        this._right_map = this._right_maps[i];
        if (this._left_map == null || this._right_map == null) {
            return;
        }
        float weight = (this._render_data.intensity - (float)this._left_map.get_intensity()) / (float)(this._right_map.get_intensity() - this._left_map.get_intensity());
        this._left_map.addSampleWeighted(this._x, this._y, 1.0f - weight);
        this._right_map.addSampleWeighted(this._x, this._y, weight);
    }

    @Override
    public boolean needs_contour_threshold() {
        return true;
    }

    @Override
    public boolean needs_ray_surface_product() {
        return true;
    }
}

