/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import main.view3d.Shader;
import raycaster.gui.GuiTransferFunction;
import raycaster.renderer.RenderData;
import raycaster.renderer.Renderer;
import raycaster.settings.LightingSettings;
import raycaster.settings.RenderSettings;
import raycaster.settings.TmpRenderSettings;
import raycaster.settings.TransferFunctionSetting;

public final class PhongShadingRenderer
extends Renderer {
    private final RenderSettings _render_settings;
    private final Color4f[] _color_table;
    private final boolean _use_gradient_weight;
    private final boolean _use_lighting;
    private final Transform3D _light_transform;
    private final Transform3D _world_transform;
    private final Transform3D _inverse_world_transform = new Transform3D();
    private final Transform3D _normal_transform = new Transform3D();
    private final float _f_diff;
    private final float _f_spec;
    private final float _f_amb;
    private final Shader _shader_chain;
    private final float _spec_exp;
    private final Color4f _diffuse_light_color = new Color4f();
    private final Color4f _ambient_light_color = new Color4f();
    private final Color4f _specular_light_color = new Color4f();
    private final Vector3f _normal = new Vector3f();
    private final Point3f _sample_point = new Point3f();

    public PhongShadingRenderer(RenderData render_data, RenderSettings render_settings, TransferFunctionSetting transfer_function, float[] opacity_table, Color4f return_color, Shader shader_chain) {
        super(render_data, return_color);
        this._render_settings = render_settings;
        this._color_table = this.create_color_table(transfer_function, opacity_table);
        this._light_transform = render_settings.get_light_transform();
        this._world_transform = render_settings.get_world_transform();
        this._inverse_world_transform.invert(this._world_transform);
        this._normal_transform.mul(this._light_transform, this._inverse_world_transform);
        TmpRenderSettings tmp_settings = render_settings.get_tmp_settings();
        this._use_gradient_weight = tmp_settings.is_use_gradient_weight();
        LightingSettings lighting_settings = render_settings.get_lighting_settings();
        this._use_lighting = lighting_settings.get_use_lighting();
        this._spec_exp = lighting_settings.get_specular_exponent();
        this._f_amb = lighting_settings.get_ambient();
        this._f_spec = lighting_settings.get_specular();
        this._f_diff = lighting_settings.get_diffuse();
        this._shader_chain = shader_chain;
    }

    @Override
    public void calculate_sample_color() {
        this._return_color.set((Tuple4f)this._color_table[(int)this._render_data.intensity]);
        if (this._use_gradient_weight) {
            this._return_color.w *= this._render_data.gradient_length;
        }
        if (this._use_lighting) {
            this._normal.x = this._render_data.nx;
            this._normal.y = this._render_data.ny;
            this._normal.z = this._render_data.nz;
            this._sample_point.set((Tuple3f)this._render_data.sample_point);
            this.transform_for_lighting();
            this.lighting(this._render_data.gradient_length);
        }
    }

    private final void transform_for_lighting() {
        this._light_transform.transform(this._sample_point);
        this._normal_transform.transform(this._normal);
        this._normal.normalize();
    }

    private final void lighting(float gradient_length) {
        this._diffuse_light_color.set(0.0f, 0.0f, 0.0f, 0.0f);
        this._ambient_light_color.set(0.0f, 0.0f, 0.0f, 0.0f);
        this._specular_light_color.set(0.0f, 0.0f, 0.0f, 0.0f);
        Shader.shade_all(this._shader_chain, this._normal, this._sample_point, this._ambient_light_color, this._diffuse_light_color, this._specular_light_color, this._spec_exp, false);
        float w = this._diffuse_light_color.w;
        float sw = this._specular_light_color.w;
        float aw = this._ambient_light_color.w;
        this._return_color.x = this._return_color.x * (this._diffuse_light_color.x + w) * this._f_diff + (this._specular_light_color.x + sw) * this._f_spec + (this._ambient_light_color.x + aw) * this._f_amb;
        this._return_color.y = this._return_color.y * (this._diffuse_light_color.y + w) * this._f_diff + (this._specular_light_color.y + sw) * this._f_spec + (this._ambient_light_color.y + aw) * this._f_amb;
        this._return_color.z = this._return_color.z * (this._diffuse_light_color.z + w) * this._f_diff + (this._specular_light_color.z + sw) * this._f_spec + (this._ambient_light_color.z + aw) * this._f_amb;
    }

    @Override
    public boolean needs_gradient_length() {
        return this._use_gradient_weight || this._use_lighting;
    }

    @Override
    public boolean needs_intensity() {
        return true;
    }

    @Override
    public boolean needs_normal() {
        return this._use_lighting;
    }

    @Override
    public boolean needs_sample_point() {
        return this._use_lighting;
    }

    private Color4f[] create_color_table(TransferFunctionSetting transfer_function, float[] opacity_table) {
        int max_voxel_value = this._render_settings.get_render_info().get_max_voxel_value();
        GuiTransferFunction tf = new GuiTransferFunction(transfer_function);
        Color4f[] color_table = tf.calculateColorTable(max_voxel_value);
        int i = 0;
        while (i < color_table.length) {
            color_table[i].w = opacity_table[i];
            ++i;
        }
        return color_table;
    }
}

