/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import javax.vecmath.Color4f;
import raycaster.renderer.RenderData;

public abstract class Renderer {
    protected final Color4f _return_color;
    protected final RenderData _render_data;

    public Renderer(RenderData render_data, Color4f return_color) {
        this._render_data = render_data;
        this._return_color = return_color;
    }

    public abstract void calculate_sample_color();

    public boolean needs_intensity() {
        return false;
    }

    public boolean needs_normal() {
        return false;
    }

    public boolean needs_ray_surface_product() {
        return false;
    }

    public boolean needs_curvature() {
        return false;
    }

    public boolean needs_contour_threshold() {
        return false;
    }

    public boolean needs_gradient_length() {
        return false;
    }

    public boolean needs_sample_point() {
        return false;
    }

    public void print_render_data() {
        System.out.println("====== Renderer: " + this.getClass() + " ======");
        if (this.needs_normal()) {
            System.out.println("renderdata.normal: " + this._render_data.nx + "," + this._render_data.ny + "," + this._render_data.nz + ",");
        }
        if (this.needs_intensity()) {
            System.out.println("renderdata.intensity: " + this._render_data.intensity);
        }
        if (this.needs_curvature()) {
            System.out.println("renderdata.curvature: " + this._render_data.curvature);
        }
        if (this.needs_contour_threshold()) {
            System.out.println("renderdata.contour_threshold: " + this._render_data.contour_threshold);
        }
        if (this.needs_ray_surface_product()) {
            System.out.println("renderdata.ray_surface_product: " + this._render_data.ray_surface_product);
        }
        if (this.needs_gradient_length()) {
            System.out.println("renderdata.gradient_length: " + this._render_data.gradient_length);
        }
        if (this.needs_sample_point()) {
            System.out.println("renderdata.sample_point: " + this._render_data.sample_point);
        }
        System.out.println("result-color = " + this._return_color);
    }
}

