/*
 * Decompiled with CFR 0.152.
 */
package raycaster.renderer;

import javax.vecmath.Color4f;
import main.view3d.Shader;
import raycaster.renderer.CurvatureRenderer;
import raycaster.renderer.LSMCurvatureBasedContourRenderer;
import raycaster.renderer.LSMDefaultRenderer;
import raycaster.renderer.LSMDotProductContourRenderer;
import raycaster.renderer.LSMStyleContourRenderer;
import raycaster.renderer.NormalRenderer;
import raycaster.renderer.PhongShadingRenderer;
import raycaster.renderer.RaySurfaceProductRenderer;
import raycaster.renderer.RenderData;
import raycaster.renderer.Renderer;
import raycaster.settings.RenderSettings;
import raycaster.settings.SegmentSetting;
import raycaster.settings.TransferFunctionSetting;

public class RendererFactory {
    private final RenderSettings _render_settings;
    private final RenderData _render_data;
    private final Shader _shader_chain;

    public RendererFactory(RenderSettings render_settings, RenderData render_data, Shader shader_chain) {
        this._render_settings = render_settings;
        this._render_data = render_data;
        this._shader_chain = shader_chain;
    }

    public Renderer create(SegmentSetting segment_setting, float[] opacity_table, Color4f return_color) {
        TransferFunctionSetting transfer_function = segment_setting.get_transfer_function();
        switch (transfer_function.get_render_method()) {
            case NORMALS: {
                return new NormalRenderer(this._render_data, return_color);
            }
            case RAY_SURFACE_PRODUCT: {
                return new RaySurfaceProductRenderer(this._render_data, return_color);
            }
            case CURVATURE: {
                return new CurvatureRenderer(this._render_data, segment_setting, return_color);
            }
            case LSM_DEFAULT: {
                return new LSMDefaultRenderer(this._render_data, this._render_settings, transfer_function, return_color);
            }
            case LSM_DOT_PRODUCT_CONTOURS: {
                return new LSMDotProductContourRenderer(this._render_data, this._render_settings, segment_setting, return_color);
            }
            case LSM_CURVATURE_CONTOURS: {
                return new LSMCurvatureBasedContourRenderer(this._render_data, this._render_settings, segment_setting, return_color);
            }
            case LSM_STYLE_CONTOURS: {
                return new LSMStyleContourRenderer(this._render_data, this._render_settings, transfer_function, return_color);
            }
            case PHONG_SHADING: {
                return new PhongShadingRenderer(this._render_data, this._render_settings, transfer_function, opacity_table, return_color, this._shader_chain);
            }
        }
        return new Renderer(null, null){

            @Override
            public void calculate_sample_color() {
            }
        };
    }
}

