/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings;

import misc.Assertions;
import misc.grid.filter.CubicFilter;
import misc.grid.filter.FilterOptions;
import misc.grid.filter.FilterType;

public class FilterSettings {
    private FilterType _filter_type;
    private FilterSpecificSettings _filter_options = null;

    public FilterSettings() {
    }

    public FilterSettings(FilterType type) {
        this._filter_type = type;
    }

    public FilterType get_filter_type() {
        return this._filter_type;
    }

    public void set_filter_type(FilterType filter_type) {
        this._filter_type = filter_type;
    }

    public FilterSpecificSettings get_filter_options() {
        return this._filter_options;
    }

    public void set_filter_options(FilterSpecificSettings filter_options) {
        Assertions.assertNotNull(filter_options);
        this._filter_options = filter_options;
    }

    public String toString() {
        String filter_type = this._filter_type.toString();
        String filter_options = this._filter_options == null ? "" : this._filter_options.toString();
        return String.valueOf(filter_type) + filter_options;
    }

    public static FilterSettings fromString(String value) {
        FilterSettings settings = new FilterSettings();
        int index_of_options_string = value.indexOf("(");
        boolean has_filter_options = index_of_options_string != -1;
        String filter_name = has_filter_options ? value.substring(0, index_of_options_string) : value;
        FilterType filter_type = FilterSettings.get_filter_type(filter_name);
        settings.set_filter_type(filter_type);
        if (has_filter_options) {
            String filter_options_as_string = value.substring(index_of_options_string);
            switch (filter_type) {
                case CUBIC: {
                    settings.set_filter_options(new CubicFilterSettings(filter_options_as_string));
                }
            }
        }
        return settings;
    }

    private static FilterType get_filter_type(String filter_name) {
        if (filter_name.equals("NEARESTNEIGHBOUR")) {
            return FilterType.NEAREST_NEIGHBOUR;
        }
        if (filter_name.equals("SINC")) {
            return FilterType.WINDOWED_SINC;
        }
        return Enum.valueOf(FilterType.class, filter_name);
    }

    public static class CubicFilterSettings
    implements FilterSpecificSettings {
        private float _b;
        private float _c;

        public CubicFilterSettings(float b, float c) {
            this._b = b;
            this._c = c;
        }

        public float get_b() {
            return this._b;
        }

        public void set_b(float b) {
            this._b = b;
        }

        public float get_c() {
            return this._c;
        }

        public void set_c(float c) {
            this._c = c;
        }

        public CubicFilterSettings(String string_representation) {
            String string_representation_without_braces = string_representation.substring(1, string_representation.length() - 1);
            String[] values = string_representation_without_braces.split(", ");
            this._b = Float.parseFloat(values[0]);
            this._c = Float.parseFloat(values[1]);
        }

        public String toString() {
            return String.format("(%f, %f)", Float.valueOf(this._b), Float.valueOf(this._c));
        }

        @Override
        public CubicFilter.CubicFilterOptions toFilterOptions() {
            return new CubicFilter.CubicFilterOptions(this._b, this._c);
        }
    }

    public static interface FilterSpecificSettings {
        public FilterOptions toFilterOptions();
    }
}

