/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings;

import javax.vecmath.Vector3f;
import main.MasterControl;
import main.view3d.Shader;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunctionType;
import raycaster.settings.GradientSettings;

public final class LightingSettings {
    private boolean _use_lighting = false;
    private Shader _shader_chain = null;
    private float _ambient = 0.8f;
    private float _diffuse = 0.8f;
    private float _specular = 0.8f;
    private float _specular_exponent = 20.0f;
    private Vector3f _light_direction = new Vector3f(0.5f, 0.5f, -2.0f);
    private GradientSettings _gradient_settings = new GradientSettings(GradientFunctionType.CENTRAL_DIFFERENCES, GradientCachingMethod.HASH);

    public boolean get_use_lighting() {
        return this._use_lighting;
    }

    public float get_ambient() {
        return this._ambient;
    }

    public float get_diffuse() {
        return this._diffuse;
    }

    public float get_specular() {
        return this._specular;
    }

    public Shader shader_chain() {
        return this._shader_chain;
    }

    public float get_specular_exponent() {
        return this._specular_exponent;
    }

    public GradientSettings get_gradient_settings() {
        return this._gradient_settings;
    }

    public Vector3f get_light_direction() {
        return this._light_direction;
    }

    public void set_light_direction(Vector3f light_direction) {
        this._light_direction = light_direction;
    }

    public void set_use_lighting(boolean use_lighting) {
        if (use_lighting && MasterControl.get_v3d() != null) {
            this._use_lighting = use_lighting;
            this._shader_chain = MasterControl.get_v3d().get_shader_chain();
        }
    }

    public void set_ambient(float ambient) {
        this._ambient = ambient;
    }

    public void set_diffuse(float diffuse) {
        this._diffuse = diffuse;
    }

    public void set_specular(float specular) {
        this._specular = specular;
    }

    public void set_specular_exponent(float specularExponent) {
        this._specular_exponent = specularExponent;
    }

    public void set_gradient_settings(GradientSettings gradientSettings) {
        this._gradient_settings = gradientSettings;
    }
}

