/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import raycaster.settings.RenderSettings;
import raycaster.settings.betwixt.BetwixtUtils;
import raycaster.settings.converter.VersionConverter;

public final class RenderSettingsIO {
    public static void write(Writer writer, RenderSettings render_settings, long render_time) throws Exception {
        BeanWriter beanWriter = BetwixtUtils.createBeanWriter(writer);
        render_settings.get_render_info().set_render_time(render_time);
        beanWriter.write((Object)render_settings);
        beanWriter.close();
    }

    public static RenderSettings read(Reader reader) throws Exception {
        String xml_string = RenderSettingsIO.get_xml_string_for_current_version(reader);
        BeanReader beanReader = BetwixtUtils.createBeanReader();
        beanReader.registerBeanClass(RenderSettings.class);
        Object result = beanReader.parse((Reader)new StringReader(xml_string));
        return (RenderSettings)result;
    }

    private static String get_xml_string_for_current_version(Reader reader) throws IOException, Exception {
        String xml_string = RenderSettingsIO.get_reader_contents(new BufferedReader(reader));
        VersionConverter converter = new VersionConverter();
        String converted_xml_string = converter.convert_render_settings(xml_string);
        return converted_xml_string;
    }

    private static String get_reader_contents(BufferedReader reader) throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        while ((s = reader.readLine()) != null) {
            sb.append(s);
        }
        return sb.toString();
    }
}

