/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings;

import java.awt.Color;
import java.io.StringReader;
import java.io.StringWriter;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;
import main.Segment;
import misc.grid.filter.FilterType;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunctionType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import raycaster.renderer.RenderMethod;
import raycaster.settings.ControlPoint;
import raycaster.settings.FilterSettings;
import raycaster.settings.GradientSettings;
import raycaster.settings.LightingSettings;
import raycaster.settings.RenderInfo;
import raycaster.settings.RenderSettings;
import raycaster.settings.RenderSettingsIO;
import raycaster.settings.SegmentRetrieverMock;
import raycaster.settings.SegmentSettingFactory;
import raycaster.settings.SegmentSettings;
import raycaster.settings.TransferFunctionSetting;

public class RenderSettingsIoTest {
    private final int CUBE_SIZE = 10;
    private final int VOXEL_VALUE_RANGE = 10;
    private final Color4f cp_default_color = new Color4f(Color.BLUE);
    private final String style_default_path = "resources/sphere1.png";
    private RenderSettings settings;

    @Before
    public void setUp() {
        this.settings = this.get_render_settings();
    }

    @Test
    public void testReadAndWriteForTrilinearFilter() throws Exception {
        FilterSettings fs = new FilterSettings(FilterType.TRILINEAR);
        this.settings.set_filter_settings(fs);
        this.testReadAndWrite();
    }

    @Test
    public void testReadAndWriteForCubicFilter() throws Exception {
        FilterSettings fs = new FilterSettings(FilterType.CUBIC);
        FilterSettings.CubicFilterSettings cfo = new FilterSettings.CubicFilterSettings(1.0f, 2.0f);
        fs.set_filter_options(cfo);
        this.settings.set_filter_settings(fs);
        this.testReadAndWrite();
    }

    public void testReadAndWrite() throws Exception {
        StringWriter writer = new StringWriter();
        int render_time = 123;
        RenderSettingsIO.write(writer, this.settings, 123L);
        String result = writer.toString();
        RenderSettings read_settings = RenderSettingsIO.read(new StringReader(result));
        StringWriter writer2 = new StringWriter();
        RenderSettingsIO.write(writer2, read_settings, 123L);
        String result2 = writer2.toString();
        this.assert_strings_are_equal(result, result2);
    }

    private void print_results(String result, String result2) {
        System.out.println(result);
        System.out.println("====================================");
        System.out.println("====================================");
        System.out.println("====================================");
        System.out.println();
        System.out.println(result2);
    }

    private void assert_strings_are_equal(String result1, String result2) {
        Assert.assertNotNull((Object)result1);
        Assert.assertFalse((boolean)result1.equals(""));
        String[] results1 = result1.split("\n");
        String[] results2 = result2.split("\n");
        int i = 0;
        while (i < results1.length) {
            Assert.assertEquals((Object)results1[i], (Object)results2[i]);
            ++i;
        }
        Assert.assertEquals((long)results1.length, (long)results2.length);
    }

    public RenderSettings get_render_settings() {
        Segment all_voxels = new Segment("All Voxels", 10, 10, 10);
        Segment segment = new Segment("seg 1", 10, 10, 10);
        segment.set_color(0xFFFF00);
        Segment segment2 = new Segment("seg 2", 10, 10, 10);
        segment2.set_color(65280);
        LightingSettings lighting_settings = new LightingSettings();
        lighting_settings.set_gradient_settings(new GradientSettings(GradientFunctionType.NEUMANN_4D_LINEAR_REGRESSION, GradientCachingMethod.PRE_CALC));
        lighting_settings.set_ambient(0.5f);
        lighting_settings.set_diffuse(0.4f);
        lighting_settings.set_diffuse(0.3f);
        lighting_settings.set_specular_exponent(30.0f);
        TransferFunctionSetting tf = new TransferFunctionSetting();
        tf.set_render_method(RenderMethod.LSM_DEFAULT);
        ControlPoint cp1 = new ControlPoint(0, 0.0f);
        tf.add_control_point(cp1);
        ControlPoint cp2 = new ControlPoint(25, 0.2f);
        tf.add_control_point(cp2);
        ControlPoint cp3 = new ControlPoint(99, 1.0f);
        tf.add_control_point(cp3);
        for (ControlPoint cp : tf) {
            cp.set_color(this.cp_default_color);
            cp.set_style_source("resources/sphere1.png");
        }
        TransferFunctionSetting seg_tf = new TransferFunctionSetting();
        seg_tf.set_render_method(RenderMethod.PHONG_SHADING);
        ControlPoint seg_cp1 = new ControlPoint(9, 0.0f);
        seg_tf.add_control_point(seg_cp1);
        ControlPoint seg_cp2 = new ControlPoint(12, 0.2f);
        seg_tf.add_control_point(seg_cp2);
        ControlPoint seg_cp3 = new ControlPoint(50, 1.0f);
        seg_tf.add_control_point(seg_cp3);
        for (ControlPoint cp : seg_tf) {
            cp.set_color(this.cp_default_color);
            cp.set_style_source("resources/sphere1.png");
        }
        SegmentSettingFactory.set_segment_retriever(new SegmentRetrieverMock(segment, segment2));
        SegmentSettings segment_settings = new SegmentSettings();
        segment_settings.add_segment(all_voxels, tf);
        segment_settings.add_segment(segment, seg_tf);
        segment_settings.add_segment(segment2, seg_tf);
        Transform3D view_transform = new Transform3D();
        view_transform.setTranslation(new Vector3d(0.0, 0.0, 1.0 + Math.sqrt(2.0)));
        Transform3D world_transform = new Transform3D();
        RenderSettings settings = new RenderSettings();
        settings.set_segment_settings(segment_settings);
        settings.set_lighting_settings(lighting_settings);
        settings.set_width(500);
        settings.set_height(500);
        settings.set_sampling_rate(10.0f);
        settings.set_ray_termination(0.005f);
        settings.set_thread_count(4);
        settings.set_use_octree(true);
        settings.set_view_transform(view_transform);
        settings.set_world_transform(world_transform);
        settings.set_light_transform(new Transform3D());
        RenderInfo info = new RenderInfo();
        info.set_slice_count(10);
        info.set_slice_height(10);
        info.set_slice_width(10);
        info.set_max_voxel_value(10);
        settings.set_render_info(info);
        return settings;
    }
}

