/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings;

import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import main.Segment;
import raycaster.SegmentNormalMerger;
import raycaster.settings.SegmentRetriever;
import raycaster.settings.SegmentSettingFactory;
import raycaster.settings.TransferFunctionSetting;

public final class SegmentSetting {
    private final SegmentRetriever segment_retriever;
    private Segment _segment;
    private TransferFunctionSetting _transfer_function;
    private final Color4f _color = new Color4f();
    private float _surface_opacity = 0.0f;
    private SegmentNormalMerger _segment_normal_merger = SegmentNormalMerger.GLOBAL_NORMAL;
    private boolean _surface_rendering = false;
    private boolean _show_backplane = true;
    private float _contour_thickness = 1.0f;
    private Color4f _contour_color = new Color4f();

    public float get_contour_thickness() {
        return this._contour_thickness;
    }

    public void set_contour_thickness(float contour_thickness) {
        this._contour_thickness = contour_thickness;
    }

    public Color4f get_contour_color() {
        return new Color4f(this._contour_color);
    }

    public void set_contour_color(Color4f contour_color) {
        this._contour_color.set((Tuple4f)contour_color);
    }

    public SegmentSetting() {
        this.segment_retriever = SegmentSettingFactory.get_segment_retriever();
    }

    public SegmentSetting(SegmentRetriever sr) {
        this.segment_retriever = sr;
    }

    SegmentSetting(SegmentRetriever sr, Segment segment) {
        this(sr);
        this._segment = segment;
    }

    public Segment segment() {
        return this._segment;
    }

    public void set_transfer_function(TransferFunctionSetting transfer_function) {
        this._transfer_function = transfer_function;
    }

    public TransferFunctionSetting get_transfer_function() {
        return this._transfer_function;
    }

    public String get_name() {
        return this._segment.get_name();
    }

    public void set_name(String name) {
        this._segment = this.segment_retriever.segment_for_name(name);
    }

    public void set_color(Color4f color) {
        this._color.set((Tuple4f)color);
    }

    public Color4f get_color() {
        return this._color;
    }

    public float get_surface_opacity() {
        return this._surface_opacity;
    }

    public void set_surface_opacity(float surface_opacity) {
        this._surface_opacity = surface_opacity;
    }

    public SegmentNormalMerger get_segment_normal_merger() {
        return this._segment_normal_merger;
    }

    public void set_segment_normal_merger(SegmentNormalMerger segment_normal_merger) {
        this._segment_normal_merger = segment_normal_merger;
    }

    public void set_surface_rendering(boolean surface_rendering) {
        this._surface_rendering = surface_rendering;
    }

    public boolean is_surface_rendering() {
        return this._surface_rendering;
    }

    public void set_show_backplane(boolean show_backplane) {
        this._show_backplane = show_backplane;
    }

    public boolean is_show_backplane() {
        return this._show_backplane;
    }
}

