/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Color4f;
import main.Segment;
import raycaster.SegmentTfMerger;
import raycaster.settings.SegmentSetting;
import raycaster.settings.SegmentSettingFactory;
import raycaster.settings.TransferFunctionSetting;

public final class SegmentSettings
implements Iterable<SegmentSetting> {
    private boolean _use_accurate_surface_detection = false;
    private final List<SegmentSetting> _segments = new ArrayList<SegmentSetting>();
    private SegmentTfMerger _segment_tf_merge_mode = SegmentTfMerger.SUM;

    public int get_segment_count() {
        return this._segments.size() - 1;
    }

    public void add_segment(Segment segment, TransferFunctionSetting transfer_function) {
        String segment_name = segment.get_name();
        SegmentSetting segmentSetting = SegmentSettingFactory.create_segment_setting(segment_name);
        segmentSetting.set_transfer_function(transfer_function);
        segmentSetting.set_color(new Color4f(new Color(segment.get_color())));
        this.add_segment(segmentSetting);
    }

    public void add_segment(SegmentSetting segment_setting) {
        this._segments.add(segment_setting);
    }

    public List<SegmentSetting> get_segments() {
        return this._segments;
    }

    public SegmentTfMerger get_segment_tf_merge_mode() {
        return this._segment_tf_merge_mode;
    }

    public void set_segment_tf_merge_mode(SegmentTfMerger segmentTfMergeMode) {
        this._segment_tf_merge_mode = segmentTfMergeMode;
    }

    @Override
    public Iterator<SegmentSetting> iterator() {
        return this._segments.iterator();
    }

    public SegmentSetting get_setting_for_segment(Segment segment) {
        for (SegmentSetting seg_setting : this) {
            if (seg_setting.segment() != segment) continue;
            return seg_setting;
        }
        return null;
    }

    public boolean get_use_accurate_surface_detection() {
        return this._use_accurate_surface_detection;
    }

    public void set_use_accurate_surface_detection(boolean useAccurateSurfaceDetection) {
        this._use_accurate_surface_detection = useAccurateSurfaceDetection;
    }
}

