/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings.betwixt;

import java.awt.Color;
import java.util.Locale;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.strategy.ConvertUtilsObjectStringConverter;
import raycaster.settings.FilterSettings;

public class CustomObjectStringConverter
extends ConvertUtilsObjectStringConverter {
    private final Locale _locale = Locale.ENGLISH;

    public String objectToString(Object object, Class type, String flavour, Context context) {
        if (type != null && object != null) {
            if (type.isEnum()) {
                return object.toString();
            }
            if (type == Transform3D.class) {
                return this.convertTransform3dToString(object);
            }
            if (type == Color4f.class) {
                return this.convertColor4fToString(object);
            }
            if (type == Color3f.class) {
                return this.convertColor3fToString(object);
            }
            if (type == Color.class) {
                return this.convertColorToString(object);
            }
            if (type == Vector4f.class) {
                return this.convertVector4fToString(object);
            }
            if (type == Vector3f.class) {
                return this.convertVector3fToString(object);
            }
            if (type == FilterSettings.class) {
                return object.toString();
            }
        }
        return super.objectToString(object, type, flavour, context);
    }

    private String convertTransform3dToString(Object object) {
        Transform3D transform = (Transform3D)object;
        float[] array = new float[16];
        transform.get(array);
        StringBuilder sb = new StringBuilder();
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            sb.append(value);
            sb.append(" ");
            ++n2;
        }
        int lastCharIndex = sb.length() - 1;
        sb.deleteCharAt(lastCharIndex);
        return sb.toString();
    }

    private String convertColor4fToString(Object object) {
        Color4f color = (Color4f)object;
        return String.format(this._locale, "R:%f G:%f B:%f A:%f", Float.valueOf(color.getX()), Float.valueOf(color.getY()), Float.valueOf(color.getZ()), Float.valueOf(color.getW()));
    }

    private String convertColor3fToString(Object object) {
        Color3f color = (Color3f)object;
        return String.format(this._locale, "R:%f G:%f B:%f", Float.valueOf(color.getX()), Float.valueOf(color.getY()), Float.valueOf(color.getZ()));
    }

    private String convertColorToString(Object object) {
        Color color = (Color)object;
        return String.format(this._locale, "R:%d G:%d B:%d", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String convertVector4fToString(Object object) {
        Vector4f vector = (Vector4f)object;
        return String.format(this._locale, "X:%f Y:%f Z:%f W:%f", Float.valueOf(vector.getX()), Float.valueOf(vector.getY()), Float.valueOf(vector.getZ()), Float.valueOf(vector.getW()));
    }

    private String convertVector3fToString(Object object) {
        Vector3f vector = (Vector3f)object;
        return String.format(this._locale, "X:%f Y:%f Z:%f", Float.valueOf(vector.getX()), Float.valueOf(vector.getY()), Float.valueOf(vector.getZ()));
    }

    public Object stringToObject(String value, Class type, String flavour, Context context) {
        if (type != null) {
            if (type.isEnum()) {
                try {
                    return Enum.valueOf(type, value);
                }
                catch (EnumConstantNotPresentException e) {
                    e.printStackTrace();
                    return type.getEnumConstants()[0];
                }
            }
            if (type == Transform3D.class) {
                return this.convertStringToTransform3d(value);
            }
            if (Tuple4f.class.isAssignableFrom(type)) {
                return this.convertStringToTuple4f(value, type);
            }
            if (Tuple3f.class.isAssignableFrom(type)) {
                return this.convertStringToTuple3f(value, type);
            }
            if (type == Color.class) {
                return this.convertStringToColor(value);
            }
            if (type == FilterSettings.class) {
                return FilterSettings.fromString(value);
            }
        }
        return super.stringToObject(value, type, flavour, context);
    }

    private Object convertStringToTransform3d(String value) {
        String[] strings = value.split(" ");
        float[] floats = new float[16];
        int i = 0;
        while (i < floats.length) {
            floats[i] = Float.parseFloat(strings[i]);
            ++i;
        }
        return new Transform3D(floats);
    }

    private Object convertStringToTuple4f(String value, Class<? extends Tuple4f> type) {
        String[] values = value.substring(2).split(" .:");
        Tuple4f tuple = this.createObjectOfType(type);
        tuple.setX(Float.parseFloat(values[0]));
        tuple.setY(Float.parseFloat(values[1]));
        tuple.setZ(Float.parseFloat(values[2]));
        tuple.setW(Float.parseFloat(values[3]));
        return tuple;
    }

    private Object convertStringToTuple3f(String value, Class<? extends Tuple3f> type) {
        String[] values = value.substring(2).split(" .:");
        Tuple3f tuple = this.createObjectOfType(type);
        tuple.setX(Float.parseFloat(values[0]));
        tuple.setY(Float.parseFloat(values[1]));
        tuple.setZ(Float.parseFloat(values[2]));
        return tuple;
    }

    private <T> T createObjectOfType(Class<T> type) {
        T tuple = null;
        try {
            tuple = type.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return tuple;
    }

    private Object convertStringToColor(String value) {
        String[] values = value.substring(2).split(" .:");
        int red = Integer.parseInt(values[0]);
        int green = Integer.parseInt(values[1]);
        int blue = Integer.parseInt(values[2]);
        return new Color(red, green, blue);
    }
}

