/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings.converter;

import misc.Assertions;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class SettingsConverter {
    SettingsConverter() {
    }

    void convert(Document document) {
        if (this.can_convert(this.get_version_string(document))) {
            this.perform_conversion(document);
        }
    }

    private String get_version_string(Document document) {
        Node render_settings_node = document.getFirstChild();
        NamedNodeMap attributes = render_settings_node.getAttributes();
        Node version_node = attributes.getNamedItem("version");
        String version = version_node.getNodeValue();
        return version;
    }

    abstract boolean can_convert(String var1);

    abstract void perform_conversion(Document var1);

    protected static Node find_sibling(Node parent, String child_name) {
        Node node = parent.getFirstChild();
        while (!node.getNodeName().equals(child_name)) {
            if ((node = node.getNextSibling()) != null) continue;
            throw new Assertions.ShouldNotReachHereException();
        }
        return node;
    }

    protected static void remove_text_siblings(Node parent) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                parent.removeChild(child);
            }
            ++i;
        }
    }
}

