/*
 * Decompiled with CFR 0.152.
 */
package raycaster.settings.converter;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import raycaster.settings.converter.SettingsConverter;
import raycaster.settings.converter.SettingsConverters;

public class VersionConverter {
    public String convert_render_settings(String xml_settings) {
        try {
            Document settings = this.create_DOM_document(xml_settings);
            SettingsConverters[] settingsConvertersArray = SettingsConverters.values();
            int n = settingsConvertersArray.length;
            int n2 = 0;
            while (n2 < n) {
                SettingsConverters factory = settingsConvertersArray[n2];
                SettingsConverter converter = factory.get_converter_impl();
                converter.convert(settings);
                ++n2;
            }
            String converted_settings = this.create_string_from_dom(settings);
            return converted_settings;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Document create_DOM_document(String xml_settings) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringReader reader = new StringReader(xml_settings);
        InputSource is = new InputSource(reader);
        Document settings = builder.parse(is);
        return settings;
    }

    private String create_string_from_dom(Document document) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        DOMSource input = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult output = new StreamResult(writer);
        transformer.transform(input, output);
        return writer.toString();
    }
}

