/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.LinkedList;
import javax.vecmath.Point3f;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.seggen.atlas.Atlas;
import misc.VoxelColorTable;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import misc.transform.Transformation;
import renderer.Renderer2d;
import renderer.SegRenderer2d;
import settings.Settings;
import settings.SettingsOwner;

public final class AtlasRenderer2d
extends Renderer2d
implements SettingsOwner {
    public static final String OPT_W_CENTER = Settings.register_int_opt(AtlasRenderer2d.class, "window center", "Window center for the ROI function (see DICOM standard to find out more)", 0);
    public static final String OPT_W_WIDTH = Settings.register_int_opt(AtlasRenderer2d.class, "window width", "Window width for the ROI function (see DICOM standard to find out more)", 0);
    public static final String OPT_COLOR_MODE = Settings.register_enum_opt(AtlasRenderer2d.class, "color mode", "Chosses between grey, pseudo color or custom rendering", VoxelColorTable.VoxelColorMode.GREY);
    public static final String OPT_VISIBLE = Settings.register_bool_opt(AtlasRenderer2d.class, "visible", "If set to false, the BG image is always rendered black", true);
    private int _window_min;
    private int _window_max;
    private int _window_width;
    private int _window_center;
    private final String _name;
    private VoxelColorTable _vct;
    private final int _displacement;
    private int _alpha;
    private Atlas _atlas;
    private final int[] _atlas_w = new int[3];
    private final int[] _atlas_h = new int[3];

    public AtlasRenderer2d(String name, Atlas atlas) {
        this(name, 0, 255);
        this._atlas = atlas;
        this._alpha = 0;
        this.allocate();
        this._atlas.addObserver(this, "AtlasRenderer2d()");
    }

    public AtlasRenderer2d(String name, int displacement, int alpha) {
        this._name = name;
        this._vct = new VoxelColorTable(MasterControl.get_is().get_voxel_value_range());
        this._displacement = displacement;
        this._alpha = alpha << 24;
        Settings.register_owner(this);
        this.init_roi_func();
    }

    public void set_default_alpha(int def) {
        this._alpha = def << 24;
    }

    public VoxelColorTable get_voxel_color_table() {
        return this._vct;
    }

    public void init_roi_func() {
        ImageStack is = MasterControl.get_is();
        Settings.set_class_int_option(AtlasRenderer2d.class, OPT_W_CENTER, is.get_grey_window_center());
        Settings.set_class_int_option(AtlasRenderer2d.class, OPT_W_WIDTH, is.get_grey_window_width());
        this.update_roi_func();
    }

    private final void update_roi_func() {
        ImageStack is = MasterControl.get_is();
        int slope = is.get_slope();
        int intercept = is.get_intercept();
        this._window_center = (Settings.get_int_option(this, OPT_W_CENTER) - intercept) / slope;
        this._window_width = Settings.get_int_option(this, OPT_W_WIDTH) / slope;
        this._window_min = this._window_center - this._window_width / 2;
        this._window_max = this._window_center + this._window_width / 2;
        this._vct.init_roi_func(this._window_min, this._window_max, (VoxelColorTable.VoxelColorMode)Settings.get_enum_option(this, OPT_COLOR_MODE));
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    @Override
    public void allocate() {
        super.allocate();
        RegularGrid3i vc = this._atlas.get_voxel_cube();
        this._atlas_w[0] = vc.get_dim_x();
        this._atlas_w[1] = vc.get_dim_y();
        this._atlas_w[2] = vc.get_dim_x();
        this._atlas_h[0] = vc.get_dim_y();
        this._atlas_h[1] = vc.get_dim_z();
        this._atlas_h[2] = vc.get_dim_z();
    }

    private double helper(Transformation trans, int x, int y, int z, double length) {
        Point3f trans_pos = new Point3f((float)x, (float)y, (float)z);
        Point3f vert = new Point3f((float)x, (float)y, (float)z);
        trans.transform(trans_pos);
        double result = trans_pos.distanceSquared(vert);
        if (result > length) {
            return result;
        }
        return length;
    }

    private double calc_max_dist(Atlas atlas) {
        RegularGrid3i atlas_vc = atlas.get_voxel_cube();
        int x = atlas_vc.get_dim_x();
        int y = atlas_vc.get_dim_y();
        int z = atlas_vc.get_dim_z();
        Transformation atlas_trans = this._atlas.get_trans();
        double length = -2.147483648E9;
        length = this.helper(atlas_trans, 0, 0, 0, length);
        length = this.helper(atlas_trans, x, 0, 0, length);
        length = this.helper(atlas_trans, 0, y, 0, length);
        length = this.helper(atlas_trans, 0, 0, z, length);
        length = this.helper(atlas_trans, x, y, 0, length);
        length = this.helper(atlas_trans, 0, y, z, length);
        length = this.helper(atlas_trans, x, 0, z, length);
        length = this.helper(atlas_trans, x, y, z, length);
        return Math.sqrt(length);
    }

    @Override
    public final Image render_image(int mode, int idx) {
        block17: {
            Point3f trans_pos;
            double length;
            int data_dim_z;
            int data_dim_x;
            int atlas_dim_z;
            int atlas_dim_y;
            int atlas_dim_x;
            Transformation atlas_trans;
            RegularGrid3i atlas_vc;
            block18: {
                int data_dim_y;
                block16: {
                    int ATLAS_COLOR = 255;
                    ImageStack is = MasterControl.get_is();
                    if (is.get_state() == 0 || !Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
                        return this._bimg[mode];
                    }
                    idx += this._displacement;
                    atlas_vc = this._atlas.get_voxel_cube();
                    RegularGrid3i data_vc = is.get_voxel_cube();
                    atlas_trans = this._atlas.get_trans();
                    atlas_dim_x = atlas_vc.get_dim_x();
                    atlas_dim_y = atlas_vc.get_dim_y();
                    atlas_dim_z = atlas_vc.get_dim_z();
                    data_dim_x = data_vc.get_dim_x();
                    data_dim_y = data_vc.get_dim_y();
                    data_dim_z = data_vc.get_dim_z();
                    int i = 0;
                    while (i < this._pixels[mode].length) {
                        this._pixels[mode][i] = 0;
                        ++i;
                    }
                    length = this.calc_max_dist(this._atlas);
                    trans_pos = new Point3f();
                    if (mode != 0) break block16;
                    int min_z = Math.max(0, (int)((double)idx - length) - 1);
                    int max_z = Math.min(atlas_dim_z, (int)((double)idx + length) + 1);
                    int z = min_z;
                    while (z < max_z) {
                        int y = 0;
                        while (y < atlas_dim_y) {
                            int x = 0;
                            while (x < atlas_dim_x) {
                                trans_pos.x = x;
                                trans_pos.y = y;
                                trans_pos.z = z;
                                atlas_trans.transform(trans_pos);
                                if ((int)((double)trans_pos.z + 0.5) == idx) {
                                    int ix = (int)((double)trans_pos.x + 0.5);
                                    int iy = (int)((double)trans_pos.y + 0.5);
                                    if (ix >= 0 && ix < data_dim_x && iy >= 0 && iy < data_dim_y) {
                                        int value = atlas_vc.get(x, y, z);
                                        int pixpos = iy * data_dim_x + ix;
                                        this._pixels[mode][pixpos] = this._vct._colors[value] | 0xFF & (0xFFFFF | this._alpha);
                                    }
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++z;
                    }
                    break block17;
                }
                if (mode != 1) break block18;
                int min_x = Math.max(0, (int)((double)idx - length) - 1);
                int max_x = Math.min(atlas_dim_x, (int)((double)idx + length) + 1);
                int z = 0;
                while (z < atlas_dim_z) {
                    int y = 0;
                    while (y < atlas_dim_y) {
                        int x = min_x;
                        while (x < max_x) {
                            trans_pos.x = x;
                            trans_pos.y = y;
                            trans_pos.z = z;
                            atlas_trans.transform(trans_pos);
                            int iy = (int)((double)trans_pos.y + 0.5);
                            int iz = (int)((double)trans_pos.z + 0.5);
                            if (iy >= 0 && iy < data_dim_y && iz >= 0 && iz < data_dim_z) {
                                int value = atlas_vc.get(x, y, z);
                                int pixpos = iz * data_dim_y + iy;
                                this._pixels[mode][pixpos] = this._vct._colors[value] | 0xFF & (0xFFFFF | this._alpha);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                break block17;
            }
            if (mode != 2) break block17;
            int min_y = Math.max(0, (int)((double)idx - length) - 1);
            int max_y = Math.min(atlas_dim_y, (int)((double)idx + length) + 1);
            int z = 0;
            while (z < atlas_dim_z) {
                int y = min_y;
                while (y < max_y) {
                    int x = 0;
                    while (x < atlas_dim_x) {
                        trans_pos.x = x;
                        trans_pos.y = y;
                        trans_pos.z = z;
                        atlas_trans.transform(trans_pos);
                        if ((int)((double)trans_pos.y + 0.5) == idx) {
                            int ix = (int)((double)trans_pos.x + 0.5);
                            int iz = (int)((double)trans_pos.z + 0.5);
                            if (ix >= 0 && ix < data_dim_x && iz >= 0 && iz < data_dim_z) {
                                int value = atlas_vc.get(x, y, z);
                                int pixpos = iz * data_dim_x + ix;
                                this._pixels[mode][pixpos] = this._vct._colors[value] | 0xFF & (0xFFFFF | this._alpha);
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return this._bimg[mode];
    }

    public final void render_scaled_alpha_bg_image(BufferedImage bimg_alpha, int mode, int idx, LinkedList<SegRenderer2d> seg_renders, VoxelColorTable custom_colors) {
        int ATLAS_COLOR = 255;
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 0 || !Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
            return;
        }
        RegularGrid3i atlas_vc = this._atlas.get_voxel_cube();
        RegularGrid3i data_vc = is.get_voxel_cube();
        Transformation atlas_trans = this._atlas.get_trans();
        int atlas_dim_x = atlas_vc.get_dim_x();
        int atlas_dim_y = atlas_vc.get_dim_y();
        int atlas_dim_z = atlas_vc.get_dim_z();
        int data_dim_x = data_vc.get_dim_x();
        int data_dim_y = data_vc.get_dim_y();
        int i = 0;
        while (i < this._pixels[mode].length) {
            this._pixels[mode][i] = 0;
            ++i;
        }
        Point3f trans_pos = new Point3f();
        int z = 0;
        while (z < atlas_dim_z) {
            int y = 0;
            while (y < atlas_dim_y) {
                int x = 0;
                while (x < atlas_dim_x) {
                    trans_pos.x = x;
                    trans_pos.y = y;
                    trans_pos.z = z;
                    atlas_trans.transform(trans_pos);
                    if (mode == 0 && (int)((double)trans_pos.z + 0.5) == idx) {
                        int ix = (int)((double)trans_pos.x + 0.5);
                        int iy = (int)((double)trans_pos.y + 0.5);
                        if (ix >= 0 && ix < data_dim_x && iy >= 0 && iy < data_dim_y) {
                            int value = atlas_vc.get(x, y, z);
                            int pixpos = iy * data_dim_x + ix;
                            this._pixels[mode][pixpos] = this._vct._colors[value] | 0xFF & (0xFFFFF | this._alpha);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        int[] bimg_alpha_pixels = ((DataBufferInt)bimg_alpha.getRaster().getDataBuffer()).getData();
        int i2 = 0;
        while (i2 < bimg_alpha_pixels.length) {
            bimg_alpha_pixels[i2] = 0;
            ++i2;
        }
        Graphics2D g2 = (Graphics2D)bimg_alpha.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2.drawImage(this._bimg[mode], 0, 0, bimg_alpha.getWidth(), bimg_alpha.getHeight(), null);
    }

    public final void render_alpha_bg_image(BufferedImage bimg_alpha, int mode, int idx, LinkedList<SegRenderer2d> seg_renders, VoxelColorTable custom_colors) {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 0 || !Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
            return;
        }
        RegularGrid3i atlas_vc = this._atlas.get_voxel_cube();
        RegularGrid3i data_vc = is.get_voxel_cube();
        Transformation atlas_trans = this._atlas.get_trans();
        int atlas_dim_x = atlas_vc.get_dim_x();
        int atlas_dim_y = atlas_vc.get_dim_y();
        int atlas_dim_z = atlas_vc.get_dim_z();
        int data_dim_x = data_vc.get_dim_x();
        int data_dim_y = data_vc.get_dim_y();
        int[] color_table = custom_colors != null ? custom_colors._colors : this._vct._colors;
        int[] pixels = ((DataBufferInt)bimg_alpha.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < pixels.length) {
            pixels[i] = 0;
            ++i;
        }
        Point3f trans_pos = new Point3f();
        int z = 0;
        while (z < atlas_dim_z) {
            int y = 0;
            while (y < atlas_dim_y) {
                int x = 0;
                while (x < atlas_dim_x) {
                    trans_pos.x = x;
                    trans_pos.y = y;
                    trans_pos.z = z;
                    atlas_trans.transform(trans_pos);
                    if (mode == 0 && (int)((double)trans_pos.z + 0.5) == idx) {
                        int ix = (int)((double)trans_pos.x + 0.5);
                        int iy = (int)((double)trans_pos.y + 0.5);
                        if (ix >= 0 && ix < data_dim_x && iy >= 0 && iy < data_dim_y) {
                            int value = atlas_vc.get(x, y, z);
                            int pixpos = iy * data_dim_x + ix;
                            pixels[pixpos] = color_table[value];
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    public void cleanup() {
        Settings.unregister_owner(this);
    }

    @Override
    public final void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == ImageStack.M_LOADING_FIRST_IMAGE) {
            this._vct = new VoxelColorTable(MasterControl.get_is().get_voxel_value_range());
        } else if (m._type == ImageStack.M_FILTER3D_STEP || m._type == ImageStack.M_FILTER3D_END) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        } else if (m._type == Atlas.M_ATLAS_TRANSFORMATION_SET) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }

    @Override
    public final String get_name() {
        return this._name;
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_W_CENTER || opt_name == OPT_W_WIDTH) {
            this.update_roi_func();
        }
        if (opt_name == OPT_COLOR_MODE) {
            this.update_roi_func();
        }
        if (opt_name == OPT_VISIBLE) {
            if (!((Boolean)opt).booleanValue()) {
                int m = 0;
                while (m < 3) {
                    int i = 0;
                    while (i < this._pixels[m].length) {
                        this._pixels[m][i] = 0;
                        ++i;
                    }
                    ++m;
                }
            }
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }
}

