/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import java.awt.image.DataBufferInt;
import java.util.Observable;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.seggen.atlas.Atlas;
import main.view3d.Viewport3d;
import misc.VoxelColorTable;
import misc.grid.RegularGrid3i;
import misc.transform.NonrigidTransformation;
import misc.transform.Transformation;
import renderer.AtlasRenderer2d;
import renderer.Tex3Cube;
import renderer.TexRenderer3d;
import settings.Settings;
import settings.SettingsOwner;
import threads.RenderThread;

public final class AtlasRenderer3d
extends TexRenderer3d
implements SettingsOwner {
    public static final String OPT_TEX_DIM = Settings.register_int_opt(AtlasRenderer3d.class, "texture dimension", "Texture image dimensions: A 3D texture can be seen as a stack of 2d images.", 256);
    public static final String OPT_ALWAYS_USE_TEX_DIM = Settings.register_bool_opt(AtlasRenderer3d.class, "texture dimension always", "Uses the texture dimension even if non-power of two is supported (e.g. to reduce memory usage)", false);
    public static final String OPT_TEX_STEPS = Settings.register_int_opt(AtlasRenderer3d.class, "texture steps", "The maximum number of planes that would be usefull is divided by this number. Larger values for thissettings result in less memory usage and worse rendering quality.", 2);
    public static final String OPT_BG_TRANS = Settings.register_double_opt(AtlasRenderer3d.class, "bg transparency", "Transparency valuef for the background rendering.", 0.5);
    public static final String OPT_BG_COLOR = Settings.register_color_opt(AtlasRenderer3d.class, "bg color", "Color of the planes if the child image renderer is not set to pseudo color.", new Color(255, 128, 128));
    public static final String OPT_RENDER_BG = Settings.register_bool_opt(AtlasRenderer3d.class, "render background", "Render DICOM data as 3D Texture.", false);
    public static final String OPT_NICEST_FILTERING = Settings.register_bool_opt(AtlasRenderer3d.class, "nices filtering", "use nicest texture filtering available", false);
    public static final String OPT_RENDER_SHADED = Settings.register_bool_opt(AtlasRenderer3d.class, "shaded rendering", "use shading in the 3d texture renderin", false);
    public static final String OPT_DEBUG_VISUALIZE_NORMALS = Settings.register_bool_opt(AtlasRenderer3d.class, "debug: colored normals", "use normal direction as color", false);
    public static final String OPT_DEBUG_SHOW_BORDERS = Settings.register_bool_opt(AtlasRenderer3d.class, "debug: show borders", "Shows Plane Borders", false);
    public static final String OPT_RENDER_CTRL_GRIDPOINTS = Settings.register_bool_opt(AtlasRenderer3d.class, "show control grid points", "Shows the points of the control grid", false);
    public static final String OPT_RENDER_GRID_POINTS = Settings.register_bool_opt(AtlasRenderer3d.class, "show grid", "Shows the points of a deformed grid", true);
    public static final String OPT_RENDER_GRID_LINES = Settings.register_bool_opt(AtlasRenderer3d.class, "show grid lines", "Shows the lines of a deformed grid", true);
    private ImageComponent3D _ic3d;
    private final Tex3Cube _tex3_cube;
    private Tex3RenderThread _render_thread;
    private AtlasRenderer2d _ar2d;
    private final BranchGroup _bg_spin;
    private final Shape3D _shp_ctrl_grid_points;
    private final Shape3D _shp_grid_points;
    private final Shape3D _shp_grid_lines;

    public AtlasRenderer3d(Viewport3d v3d, int scene_id, TransformGroup spin) {
        super(v3d, scene_id);
        this._visible = false;
        Settings.register_owner(this);
        float trans = Settings.get_double_option(this, OPT_BG_TRANS).floatValue();
        TransparencyAttributes bg_trans_att = new TransparencyAttributes(2, trans);
        bg_trans_att.setCapability(3);
        ColoringAttributes bg_col_att = new ColoringAttributes();
        bg_col_att.setColor(new Color3f(Settings.get_color_option(this, OPT_BG_COLOR)));
        bg_col_att.setCapability(1);
        this._tex3_cube = new Tex3Cube(bg_trans_att, bg_col_att, spin, MasterControl.get_v3d().get_canvas3d());
        this._render_thread = null;
        this._bg_spin = new BranchGroup();
        this._bg_spin.setCapability(14);
        this._bg_spin.setCapability(17);
        Appearance ap = new Appearance();
        PointAttributes point_att = new PointAttributes();
        point_att.setPointSize(6.0f);
        point_att.setPointAntialiasingEnable(true);
        ap.setPointAttributes(point_att);
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(new Color3f(1.0f, 0.0f, 0.0f));
        ap.setColoringAttributes(ca);
        this._shp_ctrl_grid_points = new Shape3D(null, ap);
        this._shp_ctrl_grid_points.setCapability(13);
        ap = new Appearance();
        point_att = new PointAttributes();
        point_att.setPointSize(3.0f);
        point_att.setPointAntialiasingEnable(true);
        ap.setPointAttributes(point_att);
        ca = new ColoringAttributes();
        ca.setColor(new Color3f(0.0f, 1.0f, 0.0f));
        ap.setColoringAttributes(ca);
        this._shp_grid_points = new Shape3D(null, ap);
        this._shp_grid_points.setCapability(13);
        ap = new Appearance();
        this._shp_grid_lines = new Shape3D(null, ap);
        this._shp_grid_lines.setCapability(13);
        this._bg_spin.addChild((Node)this._shp_ctrl_grid_points);
        this._bg_spin.addChild((Node)this._shp_grid_points);
        this._bg_spin.addChild((Node)this._shp_grid_lines);
        this._imr2d.addObserver(this, "AtlasRenderer3d()");
        Atlas.get_instance().addObserver(this, "AtlasRenderer3d()");
    }

    @Override
    public final void set_visible(boolean visible) {
        if (!this._visible && visible) {
            int tex_steps = Settings.get_int_option(this, OPT_TEX_STEPS);
            this.calc_dimensions(Settings.get_int_option(this, OPT_TEX_DIM), Settings.get_bool_option(this, OPT_ALWAYS_USE_TEX_DIM));
            this._tex3_cube._show_debug_border = Settings.get_bool_option(this, OPT_DEBUG_SHOW_BORDERS);
            this._tex3_cube.set_size(tex_steps, this._w, this._h);
            this._tex3_cube.attach(this._bg);
            this._ar2d = new AtlasRenderer2d("T3D AtlasRenderer2d", Atlas.get_instance());
        }
        super.set_visible(visible);
    }

    @Override
    public final void free_ressources() {
        this._tex3_cube.free_ressources(this._bg);
        this._bg_spin.detach();
        this._ic3d = null;
        this._ar2d = null;
        System.gc();
        System.gc();
    }

    @Override
    public final void create_scene() {
        ImageStack is;
        if (this._visible && (is = MasterControl.get_is()).get_state() != 1 && is.get_state() != 3) {
            if (this._render_thread == null || this._render_thread.getState() == Thread.State.TERMINATED) {
                this._render_thread = new Tex3RenderThread(this);
                this._render_thread.start();
            } else {
                this._render_thread.restart();
            }
        }
    }

    public final void update_rotation() {
        if (this._visible) {
            this._tex3_cube.update_tex_coords();
        }
    }

    private VoxelColorTable alpha_adjusted_color_table(VoxelColorTable source_table) {
        int steps = Settings.get_int_option(this, OPT_TEX_STEPS);
        double sample_dist = (double)steps / Math.sqrt(3.0);
        int size = source_table._colors.length;
        VoxelColorTable vct = new VoxelColorTable(size);
        int i = 0;
        while (i < size) {
            int argb = source_table._colors[i];
            int rgb = 0xFFFFFF & argb;
            int a_old = (0xFF000000 & argb) >> 24 & 0xFF;
            int a_new = (int)(0.5 + 255.0 * (1.0 - Math.pow(1.0 - (double)a_old / 255.0, sample_dist)));
            a_new = Math.max(0, Math.min(255, a_new));
            vct._colors[i] = a_new << 24 | rgb;
            ++i;
        }
        return vct;
    }

    void render_ctrl_grid_points() {
        Atlas atlas = Atlas.get_instance();
        Transformation atlas_trans = atlas.get_trans();
        if (atlas_trans.getClass() == NonrigidTransformation.class) {
            NonrigidTransformation nrt = (NonrigidTransformation)atlas_trans;
            Point3i grid_dim = nrt.get_grid_dim();
            PointArray points = new PointArray(grid_dim.x * grid_dim.y * grid_dim.z, 1);
            int idx = 0;
            int z = 0;
            while (z < grid_dim.z) {
                int y = 0;
                while (y < grid_dim.y) {
                    int x = 0;
                    while (x < grid_dim.x) {
                        points.setCoordinate(idx++, nrt.get_grid_point(x, y, z));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            this._shp_ctrl_grid_points.setGeometry((Geometry)points);
        } else {
            this._shp_ctrl_grid_points.setGeometry(null);
        }
    }

    void render_grid() {
        int max_x;
        Atlas atlas = Atlas.get_instance();
        RegularGrid3i atlas_vc = atlas.get_voxel_cube();
        Transformation atlas_trans = atlas.get_trans();
        int GNA = 8;
        int max_z = atlas_vc.get_dim_z() % 8 == 0 ? atlas_vc.get_dim_z() / 8 : atlas_vc.get_dim_z() / 8 + 1;
        int max_y = atlas_vc.get_dim_y() % 8 == 0 ? atlas_vc.get_dim_y() / 8 : atlas_vc.get_dim_y() / 8 + 1;
        int n = max_x = atlas_vc.get_dim_x() % 8 == 0 ? atlas_vc.get_dim_x() / 8 : atlas_vc.get_dim_x() / 8 + 1;
        if (Settings.get_bool_option(this, OPT_RENDER_GRID_POINTS).booleanValue()) {
            PointArray points = new PointArray(max_z * max_y * max_x, 1);
            int idx = 0;
            int z = 0;
            while (z < max_z) {
                int y = 0;
                while (y < max_y) {
                    int x = 0;
                    while (x < max_x) {
                        Point3f trans_grid = new Point3f((float)(x * 8), (float)(y * 8), (float)(z * 8));
                        atlas_trans.transform(trans_grid);
                        points.setCoordinate(idx++, trans_grid);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            this._shp_grid_points.setGeometry((Geometry)points);
        } else {
            this._shp_grid_points.setGeometry(null);
        }
        if (Settings.get_bool_option(this, OPT_RENDER_GRID_LINES).booleanValue()) {
            boolean show_x = true;
            boolean show_y = true;
            LineArray lines = new LineArray(max_z * max_y * max_x * 6, 1);
            int idx = 0;
            int y = 0;
            while (y < max_y) {
                int x = 0;
                while (x < max_x) {
                    Point3f trans_grid;
                    if (x != max_x - 1) {
                        trans_grid = new Point3f((float)(x * 8), (float)(y * 8), 4.0f);
                        atlas_trans.transform(trans_grid);
                        lines.setCoordinate(idx++, trans_grid);
                        trans_grid = new Point3f((float)((x + 1) * 8), (float)(y * 8), 5.0f);
                        atlas_trans.transform(trans_grid);
                        lines.setCoordinate(idx++, trans_grid);
                    }
                    if (y != max_y - 1) {
                        trans_grid = new Point3f((float)(x * 8), (float)(y * 8), 5.0f);
                        atlas_trans.transform(trans_grid);
                        lines.setCoordinate(idx++, trans_grid);
                        trans_grid = new Point3f((float)(x * 8), (float)((y + 1) * 8), 5.0f);
                        atlas_trans.transform(trans_grid);
                        lines.setCoordinate(idx++, trans_grid);
                    }
                    ++x;
                }
                ++y;
            }
            this._shp_grid_lines.setGeometry((Geometry)lines);
        } else {
            this._shp_grid_lines.setGeometry(null);
        }
    }

    public void cleanup() {
        this._ar2d.cleanup();
        this._ar2d = null;
        Settings.unregister_owner(this);
    }

    public void update(Observable o, Object arg) {
        Message m = (Message)arg;
        if (arg instanceof Message && m._type == Atlas.M_ATLAS_TRANSFORMATION_SET) {
            this.create_scene();
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_ALWAYS_USE_TEX_DIM) {
            if (this._visible) {
                this.set_visible(false);
                this.set_visible(true);
            }
        } else if (opt_name == OPT_TEX_STEPS || opt_name == OPT_TEX_DIM) {
            if (this._visible) {
                this.set_visible(false);
                this.set_visible(true);
            }
        } else if (opt_name == OPT_DEBUG_SHOW_BORDERS) {
            if (this._visible) {
                this.set_visible(false);
                this.set_visible(true);
            }
        } else if (opt_name == OPT_BG_TRANS) {
            Double trans = Settings.get_double_option(this, OPT_BG_TRANS);
            this._tex3_cube._bg_trans_att.setTransparency(trans.floatValue());
        } else if (opt_name == OPT_BG_COLOR) {
            Color col = Settings.get_color_option(this, OPT_BG_COLOR);
            this._tex3_cube._bg_col_att.setColor(new Color3f(col));
        } else if (opt_name == OPT_RENDER_BG) {
            this.set_visible((Boolean)opt);
        } else if (opt_name == OPT_RENDER_CTRL_GRIDPOINTS) {
            if (Settings.get_bool_option(this, OPT_RENDER_CTRL_GRIDPOINTS).booleanValue()) {
                this.render_ctrl_grid_points();
            } else {
                this._shp_ctrl_grid_points.setGeometry(null);
            }
        } else if (opt_name == OPT_RENDER_GRID_POINTS) {
            if (Settings.get_bool_option(this, OPT_RENDER_GRID_POINTS).booleanValue()) {
                this.render_grid();
            } else {
                this._shp_grid_points.setGeometry(null);
                this._shp_grid_lines.setGeometry(null);
            }
        } else if (opt_name == OPT_RENDER_GRID_LINES) {
            if (Settings.get_bool_option(this, OPT_RENDER_GRID_LINES).booleanValue()) {
                this.render_grid();
            } else {
                this._shp_grid_lines.setGeometry(null);
            }
        }
    }

    @Override
    public String get_name() {
        return this.toString();
    }

    private final class Tex3RenderThread
    extends RenderThread {
        public Tex3RenderThread(SettingsOwner parent) {
            super(parent, false);
        }

        @Override
        public final void my_run() {
            do {
                this._restart = false;
                VoxelColorTable vct = AtlasRenderer3d.this.alpha_adjusted_color_table(AtlasRenderer3d.this._ar2d.get_voxel_color_table());
                int[] color_table = vct != null ? vct._colors : ((AtlasRenderer3d)AtlasRenderer3d.this)._ar2d.get_voxel_color_table()._colors;
                ImageStack is = MasterControl.get_is();
                Atlas atlas = Atlas.get_instance();
                RegularGrid3i atlas_vc = atlas.get_voxel_cube();
                RegularGrid3i data_vc = is.get_voxel_cube();
                Transformation atlas_trans = atlas.get_trans();
                int atlas_dim_x = atlas_vc.get_dim_x();
                int atlas_dim_y = atlas_vc.get_dim_y();
                int atlas_dim_z = atlas_vc.get_dim_z();
                int data_dim_x = data_vc.get_dim_x();
                int data_dim_y = data_vc.get_dim_y();
                int data_dim_z = data_vc.get_dim_z();
                int[][] pixels = new int[((AtlasRenderer3d)AtlasRenderer3d.this)._tex3_cube._bg_imgs.length][];
                int i = 0;
                while (i < ((AtlasRenderer3d)AtlasRenderer3d.this)._tex3_cube._bg_imgs.length) {
                    pixels[i] = ((DataBufferInt)((AtlasRenderer3d)AtlasRenderer3d.this)._tex3_cube._bg_imgs[i].getRaster().getDataBuffer()).getData();
                    int j = 0;
                    while (j < pixels[i].length) {
                        pixels[i][j] = 0;
                        ++j;
                    }
                    ++i;
                }
                Point3f trans_pos = new Point3f();
                int z = 0;
                while (z < atlas_dim_z) {
                    int y = 0;
                    while (y < atlas_dim_y) {
                        int x = 0;
                        while (x < atlas_dim_x) {
                            trans_pos.x = x;
                            trans_pos.y = y;
                            trans_pos.z = z;
                            atlas_trans.transform(trans_pos);
                            int ix = (int)((double)trans_pos.x + 0.5);
                            int iy = (int)((double)trans_pos.y + 0.5);
                            int iz = (int)((double)trans_pos.z + 0.5);
                            if (ix >= 0 && ix < data_dim_x && iy >= 0 && iy < data_dim_y && iz > 0 && iz < data_dim_z) {
                                int value = atlas_vc.get(x, y, z);
                                int pixpos = iy * data_dim_x + ix;
                                pixels[iz][pixpos] = color_table[value];
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                if (!this._restart) {
                    AtlasRenderer3d.this._ic3d = new ImageComponent3D(2, ((AtlasRenderer3d)AtlasRenderer3d.this)._tex3_cube._bg_imgs, true, true);
                    ((AtlasRenderer3d)AtlasRenderer3d.this)._tex3_cube._bg_tex.setImage(0, (ImageComponent)AtlasRenderer3d.this._ic3d);
                }
                if (this._stop_soon) {
                    return;
                }
                if (Settings.get_bool_option(this._parent, OPT_RENDER_CTRL_GRIDPOINTS).booleanValue()) {
                    AtlasRenderer3d.this.render_ctrl_grid_points();
                }
                if (!Settings.get_bool_option(this._parent, OPT_RENDER_GRID_POINTS).booleanValue()) continue;
                AtlasRenderer3d.this.render_grid();
            } while (this._restart && !this._stop_soon);
        }
    }
}

