/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import main.Message;
import misc.AxisAlignedBoundingBox;
import misc.messages.YObservable;
import renderer.Renderer2d;
import settings.Settings;
import settings.SettingsOwner;

public final class BBoxRenderer2d
extends Renderer2d
implements SettingsOwner {
    public static final String OPT_COLOR = Settings.register_color_opt(BBoxRenderer2d.class, "bbox color", "The color of the bounding box.", new Color(255, 255, 255));
    public static final String OPT_VISIBLE = Settings.register_bool_opt(BBoxRenderer2d.class, "visible", "True if the bounding box is visible, false if not.", false);
    private final AxisAlignedBoundingBox _bb_model;
    private final String _name;

    public BBoxRenderer2d(AxisAlignedBoundingBox bb_model, String name) {
        this._name = name;
        this._bb_model = bb_model;
        bb_model.addObserver(this, "BBoxRenderer2d()");
        Settings.register_owner(this);
    }

    @Override
    public Image render_image(int mode, int idx) {
        if (Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
            int i = 0;
            while (i < this._pixels[mode].length) {
                this._pixels[mode][i] = 0;
                ++i;
            }
            Graphics g = this._bimg[mode].getGraphics();
            g.setColor(Settings.get_color_option(this, OPT_COLOR));
            int[] bb_min = this._bb_model.get_min();
            int[] bb_max = this._bb_model.get_max();
            if (mode == 0 && idx >= bb_min[2] && idx <= bb_max[2]) {
                g.drawRect(bb_min[0], bb_min[1], bb_max[0] - bb_min[0], bb_max[1] - bb_min[1]);
            } else if (mode == 1 && idx >= bb_min[0] && idx <= bb_max[0]) {
                g.drawRect(bb_min[1], bb_min[2], bb_max[1] - bb_min[1], bb_max[2] - bb_min[2]);
            } else if (mode == 2 && idx >= bb_min[1] && idx <= bb_max[1]) {
                g.drawRect(bb_min[0], bb_min[2], bb_max[0] - bb_min[0], bb_max[2] - bb_min[2]);
            }
        }
        return this._bimg[mode];
    }

    @Override
    public final void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == AxisAlignedBoundingBox.M_BB_CHANGED) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }

    @Override
    public String get_name() {
        return this._name;
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_COLOR) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        } else if (opt_name == OPT_VISIBLE) {
            int mode = 0;
            while (mode < 3) {
                int i = 0;
                while (i < this._pixels[mode].length) {
                    this._pixels[mode][i] = 0;
                    ++i;
                }
                ++mode;
            }
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }
}

