/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import main.Message;
import main.view3d.Viewport3d;
import misc.AxisAlignedBoundingBox;
import misc.messages.YObservable;
import renderer.Renderer3d;
import settings.Settings;
import settings.SettingsOwner;

public final class BBoxRenderer3d
extends Renderer3d
implements SettingsOwner {
    public static final String OPT_COLOR = Settings.register_color_opt(BBoxRenderer3d.class, "bbox color", "Color of the bounding box", new Color(255, 255, 255));
    public static final String OPT_AUTO_COLOR = Settings.register_bool_opt(BBoxRenderer3d.class, "bbox auto color", "Always use a color that contrasts the background.", true);
    public static final String OPT_VISIBLE = Settings.register_bool_opt(BBoxRenderer3d.class, "visible", "True if the bounding box should be visible", true);
    private final AxisAlignedBoundingBox _bb_model;
    private final Shape3D _cube_shp;
    private final String _name;

    public BBoxRenderer3d(Viewport3d v3d, int scene_id, AxisAlignedBoundingBox bb_model, String name) {
        super(v3d, scene_id);
        this._name = name;
        Settings.register_owner(this);
        this._cube_shp = new Shape3D();
        this._cube_shp.setCapability(13);
        this._cube_shp.setCapability(15);
        Appearance app = new Appearance();
        ColoringAttributes cola = new ColoringAttributes();
        cola.setCapability(1);
        LineAttributes lina = new LineAttributes();
        lina.setLineAntialiasingEnable(true);
        app.setColoringAttributes(cola);
        app.setLineAttributes(lina);
        this._cube_shp.setAppearance(app);
        this.update_border_color();
        this._bg.addChild((Node)this._cube_shp);
        this._bb_model = bb_model;
        bb_model.addObserver(this, "BBoxRenderer3d()");
        Settings.register_class_listener(Viewport3d.class, this);
    }

    @Override
    public final void create_scene() {
    }

    private final void update_border_color() {
        Color border_col;
        if (Settings.get_bool_option(this, OPT_AUTO_COLOR).booleanValue()) {
            double mean_rgb;
            int min_rgb;
            Color bg_col = Settings.get_color_option(Viewport3d.class, Viewport3d.OPT_BG_COLOR);
            int r = bg_col.getRed();
            int g = bg_col.getGreen();
            int b = bg_col.getBlue();
            int max_rgb = Math.max(Math.max(r, g), b);
            border_col = max_rgb - (min_rgb = Math.min(Math.min(r, g), b)) < 20 && max_rgb > 100 && max_rgb < 156 && min_rgb > 100 && min_rgb < 156 ? ((mean_rgb = (double)(r + b + g / 3)) > 127.0 ? new Color(0, 0, 0) : new Color(255, 255, 255)) : new Color(bg_col.getRGB() ^ 0xFFFFFF);
        } else {
            border_col = Settings.get_color_option(this, OPT_COLOR);
        }
        this._cube_shp.getAppearance().getColoringAttributes().setColor(new Color3f(border_col));
    }

    private void render_box() {
        if (Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
            int[] bb_min = this._bb_model.get_min();
            int[] bb_max = this._bb_model.get_max();
            Point3f a = new Point3f((float)bb_min[0], (float)bb_min[1], (float)bb_min[2]);
            Point3f b = new Point3f((float)bb_max[0], (float)bb_min[1], (float)bb_min[2]);
            Point3f c = new Point3f((float)bb_max[0], (float)bb_max[1], (float)bb_min[2]);
            Point3f d = new Point3f((float)bb_min[0], (float)bb_max[1], (float)bb_min[2]);
            Point3f e = new Point3f((float)bb_min[0], (float)bb_min[1], (float)bb_max[2]);
            Point3f f = new Point3f((float)bb_max[0], (float)bb_min[1], (float)bb_max[2]);
            Point3f g = new Point3f((float)bb_max[0], (float)bb_max[1], (float)bb_max[2]);
            Point3f h = new Point3f((float)bb_min[0], (float)bb_max[1], (float)bb_max[2]);
            LineArray lines = new LineArray(24, 1);
            lines.setCoordinate(0, a);
            lines.setCoordinate(1, b);
            lines.setCoordinate(2, a);
            lines.setCoordinate(3, d);
            lines.setCoordinate(4, a);
            lines.setCoordinate(5, e);
            lines.setCoordinate(6, g);
            lines.setCoordinate(7, h);
            lines.setCoordinate(8, g);
            lines.setCoordinate(9, f);
            lines.setCoordinate(10, g);
            lines.setCoordinate(11, c);
            lines.setCoordinate(12, b);
            lines.setCoordinate(13, c);
            lines.setCoordinate(14, b);
            lines.setCoordinate(15, f);
            lines.setCoordinate(16, d);
            lines.setCoordinate(17, c);
            lines.setCoordinate(18, d);
            lines.setCoordinate(19, h);
            lines.setCoordinate(20, e);
            lines.setCoordinate(21, f);
            lines.setCoordinate(22, e);
            lines.setCoordinate(23, h);
            this._cube_shp.setGeometry((Geometry)lines);
        } else {
            this._cube_shp.setGeometry(null);
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._type == AxisAlignedBoundingBox.M_BB_CHANGED) {
            this.render_box();
        }
    }

    @Override
    public final String get_name() {
        return this._name;
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj == Viewport3d.class) {
            if (opt_name == Viewport3d.OPT_BG_COLOR && Settings.get_bool_option(this, OPT_AUTO_COLOR).booleanValue()) {
                this.update_border_color();
            }
        } else if (opt_name == OPT_AUTO_COLOR || opt_name == OPT_COLOR) {
            this.update_border_color();
        } else if (opt_name == OPT_VISIBLE) {
            this.render_box();
        }
    }
}

