/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.LinkedList;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.VoxelCubeHistogram;
import misc.Voxel;
import misc.VoxelColorTable;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import renderer.Renderer2d;
import renderer.SegRenderer2d;
import renderer.SegmentColorTableMap;
import settings.Settings;
import settings.SettingsOwner;

public final class BGImageRenderer2d
extends Renderer2d
implements SettingsOwner {
    public static final String OPT_W_CENTER = Settings.register_int_opt(BGImageRenderer2d.class, "window center", "Window center for the ROI function (see DICOM standard to find out more)", 0);
    public static final String OPT_W_WIDTH = Settings.register_int_opt(BGImageRenderer2d.class, "window width", "Window width for the ROI function (see DICOM standard to find out more)", 0);
    public static final String OPT_COLOR_MODE = Settings.register_enum_opt(BGImageRenderer2d.class, "color mode", "Chooses between grey, pseudo color or custom rendering", VoxelColorTable.VoxelColorMode.GREY);
    public static final String OPT_VISIBLE = Settings.register_bool_opt(BGImageRenderer2d.class, "visible", "If set to false, the BG image is always rendered black", true);
    private int _window_min;
    private int _window_max;
    private int _window_width;
    private int _window_center;
    private final String _name;
    private VoxelColorTable _vct;
    private SegmentColorTableMap _color_table_map;
    private final int _displacement;
    private int _alpha;
    public boolean _use_tf_hack = false;

    public BGImageRenderer2d(String name) {
        this(name, 0, 255);
    }

    public BGImageRenderer2d(String name, int displacement, int alpha) {
        this._name = name;
        this._vct = null;
        this._displacement = displacement;
        this._alpha = alpha << 24;
        Settings.register_owner(this);
        MasterControl.get_is().get_vch().addObserver(this, "BGImageRenderer2d");
    }

    public void set_default_alpha(int def) {
        this._alpha = def << 24;
    }

    public VoxelColorTable get_voxel_color_table() {
        return this._vct;
    }

    public void init_roi_func() {
        ImageStack is = MasterControl.get_is();
        Settings.set_class_int_option(BGImageRenderer2d.class, OPT_W_CENTER, is.get_grey_window_center());
        Settings.set_class_int_option(BGImageRenderer2d.class, OPT_W_WIDTH, is.get_grey_window_width());
        this.update_roi_func();
    }

    @Override
    public void allocate() {
        super.allocate();
        this.build_vct();
    }

    private final void update_roi_func() {
        ImageStack is = MasterControl.get_is();
        int slope = is.get_slope();
        int intercept = is.get_intercept();
        this._window_center = (Settings.get_int_option(this, OPT_W_CENTER) - intercept) / slope;
        this._window_width = Settings.get_int_option(this, OPT_W_WIDTH) / slope;
        this._window_min = this._window_center - this._window_width / 2;
        this._window_max = this._window_center + this._window_width / 2;
        if (this._vct == null) {
            this.build_vct();
        }
        this._vct.init_roi_func(this._window_min, this._window_max, (VoxelColorTable.VoxelColorMode)Settings.get_enum_option(this, OPT_COLOR_MODE));
        this._use_tf_hack = false;
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    public int get_dim(int viewmode) {
        ImageStack is = MasterControl.get_is();
        RegularGrid3i vc = is.get_voxel_cube();
        switch (viewmode) {
            case 0: {
                return vc.get_dim_z();
            }
            case 1: {
                return vc.get_dim_x();
            }
            case 2: {
                return vc.get_dim_y();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final Image render_image(int mode, int idx) {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 0 || !Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
            return this._bimg[mode];
        }
        RegularGrid3i vc = is.get_voxel_cube();
        if ((idx += this._displacement) < 0 || idx >= this.get_dim(mode)) {
            this.clear(mode);
            return this._bimg[mode];
        }
        LinkedList<Voxel> seeds = is.get_seeds();
        int pixel_counter = 0;
        int seed_color = 0xFF00FF | this._alpha;
        if (mode == 0) {
            int y = 0;
            while (y < _h[mode]) {
                pixel_counter = y * _w[mode];
                int x = 0;
                while (x < _w[mode]) {
                    int value = vc.get(x, y, idx);
                    this._pixels[mode][pixel_counter++] = this._vct._colors[value] & 0xFFFFFF | this._alpha;
                    ++x;
                }
                ++y;
            }
            for (Voxel seed : seeds) {
                if (idx != seed._z) continue;
                this._pixels[mode][seed._y * BGImageRenderer2d._w[mode] + seed._x] = seed_color;
            }
        } else if (mode == 1) {
            int z = 0;
            while (z < _h[mode]) {
                pixel_counter = z * _w[mode];
                int y = 0;
                while (y < _w[mode]) {
                    int value = vc.get(idx, y, z);
                    this._pixels[mode][pixel_counter++] = this._vct._colors[value] & 0xFFFFFF | this._alpha;
                    ++y;
                }
                ++z;
            }
            for (Voxel seed : seeds) {
                if (idx != seed._x) continue;
                this._pixels[mode][seed._z * BGImageRenderer2d._w[mode] + seed._y] = seed_color;
            }
        } else {
            int z = 0;
            while (z < _h[mode]) {
                pixel_counter = z * _w[mode];
                int x = 0;
                while (x < _w[mode]) {
                    int value = vc.get(x, idx, z);
                    this._pixels[mode][pixel_counter++] = this._vct._colors[value] & 0xFFFFFF | this._alpha;
                    ++x;
                }
                ++z;
            }
            for (Voxel seed : seeds) {
                if (idx != seed._y) continue;
                this._pixels[mode][seed._z * BGImageRenderer2d._w[mode] + seed._x] = seed_color;
            }
        }
        return this._bimg[mode];
    }

    private void clear(int mode) {
        Arrays.fill(this._pixels[mode], 0);
    }

    public final void render_scaled_alpha_bg_image(BufferedImage bimg_alpha, int mode, int idx, LinkedList<SegRenderer2d> seg_renders, VoxelColorTable custom_colors) {
        int z;
        int z_size;
        int value;
        int x;
        int x_size;
        int[] color_table = custom_colors != null ? custom_colors._colors : this._vct._colors;
        ImageStack is = MasterControl.get_is();
        RegularGrid3i vc = is.get_voxel_cube();
        int pixelcounter = 0;
        if (mode == 0) {
            int y_size = vc.get_dim_y();
            x_size = vc.get_dim_x();
            int y = 0;
            while (y < y_size) {
                x = 0;
                while (x < x_size) {
                    value = vc.get(x, y, idx);
                    this._pixels[mode][pixelcounter++] = color_table[value];
                    ++x;
                }
                ++y;
            }
        } else if (mode == 1) {
            z_size = vc.get_dim_z();
            int y_size = vc.get_dim_y();
            z = 0;
            while (z < z_size) {
                int y = 0;
                while (y < y_size) {
                    value = vc.get(idx, y, z);
                    this._pixels[mode][pixelcounter++] = color_table[value];
                    ++y;
                }
                ++z;
            }
        } else {
            z_size = vc.get_dim_z();
            x_size = vc.get_dim_x();
            z = 0;
            while (z < z_size) {
                x = 0;
                while (x < x_size) {
                    value = vc.get(x, idx, z);
                    this._pixels[mode][pixelcounter++] = color_table[value];
                    ++x;
                }
                ++z;
            }
        }
        if (seg_renders != null && seg_renders.size() != 0) {
            Graphics2D g2 = (Graphics2D)this._bimg[mode].getGraphics();
            for (SegRenderer2d sr : seg_renders) {
                Image seg_img = sr.render_image(mode, idx);
                g2.drawImage(seg_img, 0, 0, this._bimg[mode].getWidth(), this._bimg[mode].getHeight(), null);
            }
        }
        int[] bimg_alpha_pixels = ((DataBufferInt)bimg_alpha.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < bimg_alpha_pixels.length) {
            bimg_alpha_pixels[i] = 0;
            ++i;
        }
        Graphics2D g2 = (Graphics2D)bimg_alpha.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2.drawImage(this._bimg[mode], 0, 0, bimg_alpha.getWidth(), bimg_alpha.getHeight(), null);
    }

    public final void render_scaled_alpha_bg_image_from_tf_set(BufferedImage bimg_alpha, int mode, int idx) {
        int z;
        int z_size;
        int x;
        int x_size;
        ImageStack is = MasterControl.get_is();
        RegularGrid3i vc = is.get_voxel_cube();
        int pixelcounter = 0;
        if (mode == 0) {
            int y_size = vc.get_dim_y();
            x_size = vc.get_dim_x();
            int y = 0;
            while (y < y_size) {
                x = 0;
                while (x < x_size) {
                    this._pixels[mode][pixelcounter++] = this._color_table_map.color_at(x, y, idx);
                    ++x;
                }
                ++y;
            }
        } else if (mode == 1) {
            z_size = vc.get_dim_z();
            int y_size = vc.get_dim_y();
            z = 0;
            while (z < z_size) {
                int y = 0;
                while (y < y_size) {
                    this._pixels[mode][pixelcounter++] = this._color_table_map.color_at(idx, y, z);
                    ++y;
                }
                ++z;
            }
        } else {
            z_size = vc.get_dim_z();
            x_size = vc.get_dim_x();
            z = 0;
            while (z < z_size) {
                x = 0;
                while (x < x_size) {
                    this._pixels[mode][pixelcounter++] = this._color_table_map.color_at(x, idx, z);
                    ++x;
                }
                ++z;
            }
        }
        int[] bimg_alpha_pixels = ((DataBufferInt)bimg_alpha.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < bimg_alpha_pixels.length) {
            bimg_alpha_pixels[i] = 0;
            ++i;
        }
        Graphics2D g2 = (Graphics2D)bimg_alpha.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2.drawImage(this._bimg[mode], 0, 0, bimg_alpha.getWidth(), bimg_alpha.getHeight(), null);
    }

    public final void render_alpha_bg_image(BufferedImage bimg_alpha, int mode, int idx, LinkedList<SegRenderer2d> seg_renders, VoxelColorTable custom_colors) {
        int z;
        int z_size;
        int value;
        int x;
        int x_size;
        ImageStack is = MasterControl.get_is();
        RegularGrid3i vc = is.get_voxel_cube();
        int[] color_table = custom_colors != null ? custom_colors._colors : this._vct._colors;
        int pixelcounter = 0;
        int[] pixels = ((DataBufferInt)bimg_alpha.getRaster().getDataBuffer()).getData();
        if (mode == 0) {
            int y_size = vc.get_dim_y();
            x_size = vc.get_dim_x();
            int y = 0;
            while (y < y_size) {
                x = 0;
                while (x < x_size) {
                    value = vc.get(x, y, idx);
                    pixels[pixelcounter++] = color_table[value];
                    ++x;
                }
                ++y;
            }
        } else if (mode == 1) {
            z_size = vc.get_dim_z();
            int y_size = vc.get_dim_y();
            z = 0;
            while (z < z_size) {
                int y = 0;
                while (y < y_size) {
                    value = vc.get(idx, y, z);
                    pixels[pixelcounter++] = color_table[value];
                    ++y;
                }
                ++z;
            }
        } else {
            z_size = vc.get_dim_z();
            x_size = vc.get_dim_x();
            z = 0;
            while (z < z_size) {
                x = 0;
                while (x < x_size) {
                    value = vc.get(x, idx, z);
                    pixels[pixelcounter++] = color_table[value];
                    ++x;
                }
                ++z;
            }
        }
        if (seg_renders != null && seg_renders.size() != 0) {
            Graphics2D g2 = (Graphics2D)bimg_alpha.getGraphics();
            for (SegRenderer2d sr : seg_renders) {
                Image seg_img = sr.render_image(mode, idx);
                g2.drawImage(seg_img, 0, 0, bimg_alpha.getWidth(), bimg_alpha.getHeight(), null);
            }
        }
    }

    public final void render_alpha_bg_image_from_tf_set(BufferedImage bimg_alpha, int mode, int idx) {
        ImageStack is = MasterControl.get_is();
        RegularGrid3i vc = is.get_voxel_cube();
        int pixelcounter = 0;
        int[] pixels = ((DataBufferInt)bimg_alpha.getRaster().getDataBuffer()).getData();
        if (mode == 0) {
            int y_size = vc.get_dim_y();
            int x_size = vc.get_dim_x();
            int y = 0;
            while (y < y_size) {
                int x = 0;
                while (x < x_size) {
                    pixels[pixelcounter++] = this._color_table_map.color_at(x, y, idx);
                    ++x;
                }
                ++y;
            }
        } else if (mode == 1) {
            int z_size = vc.get_dim_z();
            int y_size = vc.get_dim_y();
            int z = 0;
            while (z < z_size) {
                int y = 0;
                while (y < y_size) {
                    pixels[pixelcounter++] = this._color_table_map.color_at(idx, y, z);
                    ++y;
                }
                ++z;
            }
        } else {
            int z_size = vc.get_dim_z();
            int x_size = vc.get_dim_x();
            int z = 0;
            while (z < z_size) {
                int x = 0;
                while (x < x_size) {
                    pixels[pixelcounter++] = this._color_table_map.color_at(x, idx, z);
                    ++x;
                }
                ++z;
            }
        }
    }

    public void set_color_table_map(SegmentColorTableMap color_table_map) {
        this._color_table_map = color_table_map;
        this._use_tf_hack = true;
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    private void build_vct() {
        this._vct = new VoxelColorTable(MasterControl.get_is().get_voxel_value_range());
        this._use_tf_hack = false;
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    @Override
    public final void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == ImageStack.M_FILTER3D_STEP || m._type == ImageStack.M_FILTER3D_END || m._type == ImageStack.M_RESIZE_STEP || m._type == ImageStack.M_VC_CHANGED) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        } else if (m._type == VoxelCubeHistogram.M_VCH_UPDATE) {
            this.init_roi_func();
        }
    }

    @Override
    public final String get_name() {
        return this._name;
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_W_CENTER || opt_name == OPT_W_WIDTH) {
            this.update_roi_func();
        } else if (opt_name == OPT_COLOR_MODE) {
            this.update_roi_func();
        } else if (opt_name == OPT_VISIBLE) {
            if (!((Boolean)opt).booleanValue()) {
                int m = 0;
                while (m < 3) {
                    int i = 0;
                    while (i < this._pixels[m].length) {
                        this._pixels[m][i] = 0;
                        ++i;
                    }
                    ++m;
                }
            }
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }
}

