/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.view3d.Viewport3d;
import misc.messages.YObservable;
import renderer.Renderer3d;

public class LabelRenderer3d
extends Renderer3d {
    private final LinkedList<MyTextObject> _text_objects;
    private final TransformGroup _tg_root_spin;
    private final Transform3D _tf3d_spin = new Transform3D();
    private Transform3D _tf3_sam1 = new Transform3D();
    private Transform3D _spin = new Transform3D();
    private Transform3D _tf3_sam2_inv = new Transform3D();

    public LabelRenderer3d(Viewport3d v3d, TransformGroup root_spin) {
        super(v3d, 2);
        this._tg_root_spin = root_spin;
        this._text_objects = new LinkedList();
        MasterControl.get_is().addObserver(this, "LabelRenderer3d()");
        v3d._transform_notifier.addObserver(this, "LabelRenderer3d()");
        this.set_visible(true);
    }

    public Text3D add_label(String text, Point3d pos, Color col) {
        Font3D f3d = new Font3D(new Font("Arial", 0, 12), new FontExtrusion());
        Point3f pos3f = new Point3f(pos);
        Text3D label = new Text3D(f3d, text, pos3f);
        label.setCapability(3);
        label.setCapability(5);
        Shape3D shp = new Shape3D((Geometry)label);
        MyTextObject mto = new MyTextObject(label, pos3f, shp);
        this._text_objects.add(mto);
        mto.create_bg();
        this.update_text_pos(mto);
        this._bg.addChild((Node)mto._bg_dummy);
        return label;
    }

    public void rem_label(Text3D label) {
        Iterator it3d = this._text_objects.iterator();
        MyTextObject to = null;
        while (it3d.hasNext()) {
            to = (MyTextObject)it3d.next();
            if (to._text.equals(label)) break;
        }
        this._bg.removeChild((Node)to._bg_dummy);
        this._text_objects.remove(to);
    }

    public void set_label_visible(Text3D label, boolean visible) {
        Iterator it3d = this._text_objects.iterator();
        MyTextObject to = null;
        while (it3d.hasNext()) {
            to = (MyTextObject)it3d.next();
            if (to._text.equals(label)) break;
        }
        if (!visible) {
            this._bg.removeChild((Node)to._bg_dummy);
        } else {
            this._bg.addChild((Node)to._bg_dummy);
        }
    }

    public void init() {
        Node node = this._bg.getParent();
        while (node.getClass() != TransformGroup.class) {
            node = node.getParent();
        }
        MasterControl.get_v3d().get_sam1().getTransform(this._tf3_sam1);
        ((TransformGroup)node).getTransform(this._tf3_sam2_inv);
        this._tf3_sam2_inv.invert();
    }

    private void update_text_pos(MyTextObject mto) {
        this._tg_root_spin.getTransform(this._spin);
        this._tf3d_spin.set(this._tf3_sam2_inv);
        this._tf3d_spin.mul(this._spin);
        this._tf3d_spin.mul(this._tf3_sam1);
        Point3f new_pos = new Point3f(mto._pos);
        this._tf3d_spin.transform(new_pos);
        mto._text.setPosition(new_pos);
    }

    private void update_text_pos() {
        this._tg_root_spin.getTransform(this._spin);
        this._tf3d_spin.set(this._tf3_sam2_inv);
        this._tf3d_spin.mul(this._spin);
        this._tf3d_spin.mul(this._tf3_sam1);
        for (MyTextObject to : this._text_objects) {
            Point3f new_pos = new Point3f(to._pos);
            this._tf3d_spin.transform(new_pos);
            to._text.setPosition(new_pos);
        }
    }

    @Override
    public void update(YObservable yo, Message m) {
        if (yo.getClass() == ImageStack.class) {
            if (m._type == ImageStack.M_LOADING_END) {
                this.init();
            }
        } else if (yo.getClass() == Viewport3d.ObservableV3D.class && m._type == Viewport3d.M_ROTATION_CHANGED) {
            this.update_text_pos();
        }
    }

    @Override
    public void create_scene() {
    }

    private class MyTextObject {
        public Text3D _text;
        public Point3f _pos;
        public Shape3D _shp;
        public BranchGroup _bg_dummy;

        public MyTextObject(Text3D text, Point3f pos, Shape3D shp) {
            this._text = text;
            this._pos = pos;
            this._shp = shp;
        }

        public void create_bg() {
            this._bg_dummy = new BranchGroup();
            this._bg_dummy.setCapability(17);
            this._bg_dummy.setCapability(13);
            this._bg_dummy.setCapability(14);
            this._bg_dummy.addChild((Node)this._shp);
        }
    }
}

