/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import com.sun.j3d.utils.geometry.Sphere;
import java.util.HashMap;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.CoordinateConverter;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.view3d.LightMarker;
import main.view3d.Viewport3d;
import misc.geomarker.GMPlane;
import misc.geomarker.GMPoint;
import misc.geomarker.GMPolyCurve;
import misc.geomarker.GMSphere;
import misc.geomarker.GeoMarker;
import misc.messages.YObservable;
import renderer.LabelRenderer3d;
import renderer.MarkerRenderer;
import renderer.Renderer3d;
import settings.Settings;
import settings.SettingsOwner;

public class MarkerRenderer3d
extends Renderer3d
implements MarkerRenderer,
SettingsOwner {
    private final HashMap<GeoMarker, Boolean> _maker_visible = new HashMap();
    private final HashMap<GeoMarker, GMContainer> _gm_obj_storage = new HashMap();
    private final LabelRenderer3d _label_renderer;

    private TransformGroup create_nonscaling_move_transform() {
        TransformGroup tg_nonscaling_move = new TransformGroup();
        ImageStack is = MasterControl.get_is();
        int dim_x = is.get_dim_x();
        int dim_y = is.get_dim_y();
        int dim_z = is.get_dim_z();
        double x_spacing = is.get_x_spacing();
        double y_spacing = is.get_y_spacing();
        double z_spacing = is.get_z_spacing();
        double xmax_scaled = (double)dim_x * x_spacing;
        double ymax_scaled = (double)dim_y * y_spacing;
        double zmax_scaled = (double)dim_z * z_spacing;
        double max_scaled1 = Math.max(Math.max(xmax_scaled, ymax_scaled), zmax_scaled);
        double s1 = 1.5 / max_scaled1;
        double[] mat_scale1 = new double[]{s1 * x_spacing, 0.0, 0.0, 0.0, 0.0, s1 * y_spacing, 0.0, 0.0, 0.0, 0.0, s1 * z_spacing, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D tf_nonscaling_move = new Transform3D(mat_scale1);
        tf_nonscaling_move.setTranslation(new Vector3d(-(s1 * xmax_scaled) / 2.0, -(s1 * ymax_scaled) / 2.0, -(s1 * zmax_scaled) / 2.0));
        tf_nonscaling_move.invert();
        double[] mat_scale2 = new double[]{s1, 0.0, 0.0, 0.0, 0.0, s1, 0.0, 0.0, 0.0, 0.0, s1, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D tf_scale = new Transform3D(mat_scale2);
        tf_scale.mul(tf_nonscaling_move);
        tf_scale.setTranslation(new Vector3d(-(s1 * xmax_scaled) / 2.0, -(s1 * ymax_scaled) / 2.0, -(s1 * zmax_scaled) / 2.0));
        tg_nonscaling_move.setTransform(tf_scale);
        return tg_nonscaling_move;
    }

    public MarkerRenderer3d(Viewport3d v3d, int scene_id, TransformGroup root_spin) {
        super(v3d, scene_id);
        this._label_renderer = new LabelRenderer3d(v3d, root_spin);
        Settings.register_class_listener(MarkerRenderer3d.class, this);
        MasterControl.get_is().addObserver(this, "MarkerRenderer3d(");
        this.set_visible(true);
    }

    private void create_point_shape(GMContainer gmc, Point3d pos, Color3f col) {
        PointArray p_array = new PointArray(1, 1);
        p_array.setCoordinate(0, pos);
        PointAttributes poly_att = new PointAttributes();
        poly_att.setPointSize(5.0f);
        poly_att.setPointAntialiasingEnable(true);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setCapability(1);
        col_att.setColor(col);
        Appearance ap = new Appearance();
        ap.setPointAttributes(poly_att);
        ap.setColoringAttributes(col_att);
        Shape3D shp_point = new Shape3D((Geometry)p_array, ap);
        shp_point.setCapability(12);
        shp_point.setCapability(13);
        gmc._shp = shp_point;
        gmc._ca = col_att;
        gmc._bg_dummy.addChild((Node)gmc._shp);
    }

    private LineStripArray create_line_geometry(Point3d[] points) {
        int[] strip_vert_count = new int[]{points.length};
        LineStripArray ls_array = new LineStripArray(points.length, 1, strip_vert_count);
        int i = 0;
        while (i < points.length) {
            ls_array.setCoordinate(i, points[i]);
            ++i;
        }
        return ls_array;
    }

    private void create_line_shape(GMContainer gmc, Point3d[] points, Color3f col) {
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setCapability(1);
        col_att.setColor(col);
        Appearance ap = new Appearance();
        ap.setColoringAttributes(col_att);
        Shape3D shp_line = new Shape3D((Geometry)this.create_line_geometry(points), ap);
        shp_line.setCapability(12);
        shp_line.setCapability(13);
        gmc._shp = shp_line;
        gmc._ca = col_att;
        gmc._bg_dummy.addChild((Node)gmc._shp);
    }

    private void create_plane_shape(GMContainer gmc, Point3d a, Vector3d u, Vector3d v, Color3f col) {
    }

    private void create_sphere_shape(GMContainer gmc, Point3d c, double r, Color3f col) {
        Appearance ap_solid = LightMarker.make_solid_appearance(col.x, col.y, col.z, 0.6f);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setCapability(1);
        col_att.setColor(col);
        ap_solid.setColoringAttributes(col_att);
        Sphere sphere_wire = new Sphere((float)r, 0, 30, LightMarker.make_wire_appearance());
        Sphere sphere_solid = new Sphere((float)r, 0, 30, ap_solid);
        gmc._shp = sphere_wire.getShape();
        gmc._ca = col_att;
        Transform3D tr3d_trans = new Transform3D();
        CoordinateConverter cc = CoordinateConverter.get_converter(MasterControl.get_is());
        Vector3d trans = cc.grid_to_world_v3d(c.x, c.y, c.z);
        tr3d_trans.setTranslation(trans);
        TransformGroup tg_translate = new TransformGroup(tr3d_trans);
        TransformGroup tg_undo = this.create_nonscaling_move_transform();
        gmc._bg_dummy.addChild((Node)tg_undo);
        tg_undo.addChild((Node)tg_translate);
        tg_translate.addChild((Node)sphere_wire);
        tg_translate.addChild((Node)sphere_solid);
    }

    private void add_marker(GeoMarker gm) {
        GMContainer gmc = new GMContainer();
        this._gm_obj_storage.put(gm, gmc);
        if (gm.getClass() == GMPoint.class) {
            GMPoint gm_point = (GMPoint)gm;
            Point3d pos = gm_point.get_point();
            this.create_point_shape(gmc, pos, gm_point.get_color3f());
            gmc._label = this._label_renderer.add_label(gm_point.get_label(), pos, gm_point.get_color());
        } else if (gm.getClass() == GMPolyCurve.class) {
            GMPolyCurve gm_poly_curve = (GMPolyCurve)gm;
            Point3d[] points = gm_poly_curve.get_points();
            Point3d center = new Point3d(points[0]);
            int i = 1;
            while (i < gm_poly_curve.get_points().length) {
                center.add((Tuple3d)points[i]);
                ++i;
            }
            center.scale(1.0 / (double)points.length);
            this.create_line_shape(gmc, gm_poly_curve.get_points(), gm_poly_curve.get_color3f());
            gmc._label = this._label_renderer.add_label(gm_poly_curve.get_label(), center, gm_poly_curve.get_color());
        } else if (gm.getClass() == GMPlane.class) {
            GMPlane gm_plane = (GMPlane)gm;
            this.create_plane_shape(gmc, gm_plane.get_a(), gm_plane.get_u(), gm_plane.get_v(), gm_plane.get_color3f());
        } else if (gm.getClass() == GMSphere.class) {
            GMSphere gm_sphere = (GMSphere)gm;
            this.create_sphere_shape(gmc, gm_sphere.get_center(), gm_sphere.get_radius(), gm_sphere.get_color3f());
            gmc._label = this._label_renderer.add_label(gm_sphere.get_label(), gm_sphere.get_center(), gm_sphere.get_color());
        }
        this._bg.addChild((Node)gmc._bg_dummy);
    }

    @Override
    public void set_marker_visible(GeoMarker gm, boolean visible) {
        GMContainer gmc = this._gm_obj_storage.get(gm);
        if (!visible) {
            this._bg.removeChild((Node)gmc._bg_dummy);
            this._label_renderer.set_label_visible(gmc._label, false);
        } else {
            this._bg.addChild((Node)gmc._bg_dummy);
            this._label_renderer.set_label_visible(gmc._label, true);
        }
    }

    private void update_geometry(GeoMarker gm) {
        GMContainer gmc = this._gm_obj_storage.get(gm);
        if (gm.getClass() == GMPoint.class) {
            GMPoint gm_point = (GMPoint)gm;
            PointArray p_array = (PointArray)gmc._shp.getGeometry();
            p_array.setCoordinate(0, new Point3f(gm_point.get_point()));
        } else if (gm.getClass() == GMPolyCurve.class) {
            GMPolyCurve gm_poly_curve = (GMPolyCurve)gm;
            Shape3D shp = gmc._shp;
            shp.setGeometry((Geometry)this.create_line_geometry(gm_poly_curve.get_points()));
        } else if (gm.getClass() != GMPlane.class) {
            gm.getClass();
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (o.getClass() == ImageStack.class) {
            if (m._type != ImageStack.M_LOADING_END) {
                if (m._type == ImageStack.M_NEW_MARKER) {
                    this.add_marker((GeoMarker)m._obj);
                } else if (m._type == ImageStack.M_DEL_MARKER) {
                    GeoMarker gm = (GeoMarker)o;
                    GMContainer gmc = this._gm_obj_storage.get(gm);
                    this._label_renderer.rem_label(gmc._label);
                    this._maker_visible.remove(gm);
                    this._gm_obj_storage.remove(gm);
                } else if (m._type == ImageStack.M_CLEAR) {
                    this._maker_visible.clear();
                    this._gm_obj_storage.clear();
                }
            }
        } else if (m._type == GeoMarker.M_MARKER_LABEL_CHANGED) {
            GeoMarker gm = (GeoMarker)o;
            GMContainer gmc = this._gm_obj_storage.get(gm);
            gmc._label.setString(gm.get_label());
        } else if (m._type == GeoMarker.M_MARKER_COL_CHANGED) {
            GeoMarker gm = (GeoMarker)o;
            GMContainer gmc = this._gm_obj_storage.get(gm);
            gmc._ca.setColor(gm.get_color3f());
        } else if (m._type == GeoMarker.M_MARKER_GEO_CHANGED) {
            this.update_geometry((GeoMarker)o);
        }
    }

    @Override
    public void create_scene() {
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
    }

    @Override
    public String get_name() {
        return null;
    }

    private class GMContainer {
        public Text3D _label;
        public ColoringAttributes _ca;
        public Shape3D _shp;
        public BranchGroup _bg_dummy = new BranchGroup();

        public GMContainer() {
            this._bg_dummy.setCapability(17);
            this._bg_dummy.setCapability(13);
            this._bg_dummy.setCapability(14);
        }
    }
}

