/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Stripifier;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import main.ImageStack;
import main.MasterControl;
import main.Segment;
import main.YaDiV;
import misc.IntList;
import misc.MarchingTable;
import misc.StopWatch;
import misc.grid.BitCube;
import renderer.SegRenderer3d;
import settings.Settings;
import settings.SettingsOwner;
import threads.RenderThread;

public class McRenderThread
extends RenderThread {
    private final Segment _seg;
    private final Shape3D _shp_mc_body;
    private final Shape3D _shp_mc_closing;
    private final Point3f[] _scaled_v_cache;
    private final TransformGroup _tg_mc;
    private int[][] _mtable = MarchingTable._lookup_new;
    private final SoftReference<float[]>[] _smooth_multiplicator_cache = new SoftReference[1];
    private final SoftReference<float[]>[] _smooth_point_cache = new SoftReference[1];
    private final SoftReference<Vector3f[]>[] _vertex_normal_cache = new SoftReference[1];
    private SoftReference<Point3f[]> _vertex_cache = null;
    private final Point3f _tmp_point = new Point3f();
    private int _vertex_pool_remaining;
    private Point3f[] _vertex_pool;

    public McRenderThread(SettingsOwner parent, Segment seg, Shape3D shp_mc_body, Shape3D shp_mc_closing, TransformGroup tg_mc, McRenderThread predecessor) {
        super(parent, false);
        if (predecessor != null) {
            this._scaled_v_cache = predecessor._scaled_v_cache;
            this._smooth_multiplicator_cache[0] = predecessor._smooth_multiplicator_cache[0];
            this._smooth_point_cache[0] = predecessor._smooth_point_cache[0];
            this._vertex_normal_cache[0] = predecessor._vertex_normal_cache[0];
            this._vertex_cache = predecessor._vertex_cache;
        } else {
            this._scaled_v_cache = new Point3f[MarchingTable._v.length];
            int i = 0;
            while (i < MarchingTable._v.length) {
                this._scaled_v_cache[i] = new Point3f();
                ++i;
            }
        }
        this._seg = seg;
        this._shp_mc_body = shp_mc_body;
        this._shp_mc_closing = shp_mc_closing;
        this._tg_mc = tg_mc;
    }

    @Override
    public void my_run() {
        ArrayList<Point3f> verts = new ArrayList<Point3f>();
        ArrayList<Point3f> co_verts = new ArrayList<Point3f>();
        IntList trias = new IntList();
        IntList co_trias = new IntList();
        HashMap<Point3f, Integer> vt_old = new HashMap<Point3f, Integer>();
        HashMap<Point3f, Integer> vt_new = new HashMap<Point3f, Integer>();
        HashMap<Integer, Integer> shared_map = new HashMap<Integer, Integer>();
        int mc_tria_number = 0;
        boolean max_tria_num_reached = false;
        Point3f trans = new Point3f();
        BitCube bc = this._seg.get_bc();
        if (bc._bb_min[0] > bc._bb_max[0]) {
            this._shp_mc_body.setGeometry(null);
            this._shp_mc_closing.setGeometry(null);
            return;
        }
        this._mtable = Settings.get_bool_option(this._parent, SegRenderer3d.OPT_MC_OLD_LUT) != false ? MarchingTable._lookup_old : MarchingTable._lookup_new;
        do {
            int dmc = Settings.get_int_option(this._parent, SegRenderer3d.OPT_MC_DIST);
            this._restart = false;
            do {
                StopWatch sw = new StopWatch(true);
                int voxel_count = (bc._bb_max[0] - bc._bb_min[0]) * (bc._bb_max[1] - bc._bb_min[1]) * (bc._bb_max[2] - bc._bb_min[2]);
                if (Settings.get_bool_option(this._parent, SegRenderer3d.OPT_MC_REFINE).booleanValue() && voxel_count < Settings.get_int_option(this._parent, SegRenderer3d.OPT_MC_REFINE_MIN_BB_DIAG)) {
                    dmc = 1;
                }
                int i = 0;
                while (i < MarchingTable._v.length) {
                    this._scaled_v_cache[i].set((Tuple3f)MarchingTable._v[i]);
                    this._scaled_v_cache[i].scale((float)dmc);
                    ++i;
                }
                int dim_x = bc.get_dim_x();
                int dim_y = bc.get_dim_y();
                int dim_z = bc.get_dim_z();
                int min_x = (bc._bb_min[0] / dmc - 1) * dmc;
                int min_y = (bc._bb_min[1] / dmc - 1) * dmc;
                int min_z = (bc._bb_min[2] / dmc - 1) * dmc;
                int max_x = (bc._bb_max[0] / dmc + 1) * dmc;
                int max_y = (bc._bb_max[1] / dmc + 1) * dmc;
                int max_z = (bc._bb_max[2] / dmc + 1) * dmc;
                if (max_x + 0 * dmc >= bc.get_dim_x()) {
                    max_x -= dmc;
                }
                if (max_y + 0 * dmc >= bc.get_dim_y()) {
                    max_y -= dmc;
                }
                if (max_z + 0 * dmc >= bc.get_dim_z()) {
                    max_z -= dmc;
                }
                if (min_x < 0) {
                    min_x += dmc;
                }
                if (min_y < 0) {
                    min_y += dmc;
                }
                if (min_z < 0) {
                    min_z += dmc;
                }
                boolean close = Settings.get_bool_option(this._parent, SegRenderer3d.OPT_MC_CLOSING);
                verts.clear();
                trias.clear();
                vt_old.clear();
                vt_new.clear();
                shared_map.clear();
                if (this._vertex_cache != null) {
                    this._vertex_pool = this._vertex_cache.get();
                }
                int vertex_pool_initial_size = this._vertex_pool_remaining = this._vertex_pool == null ? 0 : this._vertex_pool.length;
                try {
                    int idx;
                    int y;
                    this.add_layer(0, verts, co_verts, trias, co_trias, vt_old, vt_new, trans, bc, dmc, min_x, min_y, max_x, max_y, dim_x, dim_y, close, shared_map);
                    HashMap<Point3f, Integer> temp = vt_old;
                    vt_old = vt_new;
                    vt_new = temp;
                    vt_new.clear();
                    if (close && min_z - dmc < 0) {
                        int z = min_z - dmc;
                        int x = min_x - dmc;
                        while (x < max_x + dmc) {
                            y = min_y - dmc;
                            while (y < max_y + dmc) {
                                idx = 0;
                                if (x + dmc < dim_x && y >= 0 && bc.getXYZ(x + dmc, y, z + dmc)) {
                                    idx |= 4;
                                }
                                if (x >= 0 && y >= 0 && bc.getXYZ(x, y, z + dmc)) {
                                    idx |= 8;
                                }
                                if (x + dmc < dim_x && y + dmc < dim_y && bc.getXYZ(x + dmc, y + dmc, z + dmc)) {
                                    idx |= 0x40;
                                }
                                if (x >= 0 && y + dmc < dim_y && bc.getXYZ(x, y + dmc, z + dmc)) {
                                    idx |= 0x80;
                                }
                                trans.set((float)x, (float)y, (float)z);
                                this.add_closing_cube(vt_old, vt_new, co_verts, co_trias, trans, idx, shared_map);
                                y += dmc;
                            }
                            x += dmc;
                        }
                        vt_new.clear();
                    }
                    int z = dmc;
                    while (z < max_z && !this._restart && !this._stop_soon) {
                        this.add_layer(z, verts, co_verts, trias, co_trias, vt_old, vt_new, trans, bc, dmc, min_x, min_y, max_x, max_y, dim_x, dim_y, close, shared_map);
                        HashMap<Point3f, Integer> temp2 = vt_old;
                        vt_old = vt_new;
                        vt_new = temp2;
                        vt_new.clear();
                        z += dmc;
                    }
                    if (close && max_z + dmc >= dim_z) {
                        z = max_z;
                        int x = min_x - dmc;
                        while (x < max_x + dmc) {
                            y = min_y - dmc;
                            while (y < max_y + dmc) {
                                idx = 0;
                                if (x >= 0 && y >= 0 && bc.getXYZ(x, y, z)) {
                                    idx |= 1;
                                }
                                if (x + dmc < dim_x && y >= 0 && bc.getXYZ(x + dmc, y, z)) {
                                    idx |= 2;
                                }
                                if (x >= 0 && y + dmc < dim_y && bc.getXYZ(x, y + dmc, z)) {
                                    idx |= 0x10;
                                }
                                if (x + dmc < dim_x && y + dmc < dim_y && bc.getXYZ(x + dmc, y + dmc, z)) {
                                    idx |= 0x20;
                                }
                                trans.set((float)x, (float)y, (float)z);
                                this.add_closing_cube(vt_old, vt_new, co_verts, co_trias, trans, idx, shared_map);
                                y += dmc;
                            }
                            x += dmc;
                        }
                    }
                    vt_new.clear();
                    vt_old.clear();
                }
                finally {
                    this._vertex_pool = null;
                }
                int inner_tria_count = trias.size();
                int inner_point_count = verts.size();
                mc_tria_number = trias.size() + co_trias.size();
                verts.addAll(co_verts);
                co_verts.clear();
                trias.ensureCapacity(trias.size() + co_trias.size());
                int[] tria_index_array = trias.clear();
                int i2 = 0;
                while (i2 < co_trias.size()) {
                    int value = co_trias.get(i2);
                    tria_index_array[i2 + inner_tria_count] = value < 0 ? inner_point_count + ~value : value;
                    ++i2;
                }
                co_trias.clear();
                if (this._restart) continue;
                if (this._stop_soon) {
                    return;
                }
                if (!close) {
                    this._shp_mc_closing.setGeometry(null);
                }
                max_tria_num_reached = inner_tria_count > 3 * Settings.get_int_option(this._parent, SegRenderer3d.OPT_MC_MAX_TRIAS);
                YaDiV.report(YaDiV.ReportType.REPORT_TIME, "Creating Triangles:     " + sw.toString());
                if (max_tria_num_reached) {
                    YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, String.valueOf(this._parent.get_name()) + " reached " + mc_tria_number / 3 + " trias, aborting rendering at " + dmc + " after " + sw.toString());
                } else {
                    Point3f[] point_array = new Point3f[verts.size()];
                    verts.toArray(point_array);
                    verts.clear();
                    if (vertex_pool_initial_size < point_array.length) {
                        this._vertex_cache = new SoftReference<Point3f[]>(point_array);
                    }
                    this._vertex_pool = null;
                    Vector3f[] vertex_normal_array = McRenderThread.reallocate(this._vertex_normal_cache, point_array.length, Vector3f.class);
                    this.smooth_mc_geometry(point_array, point_array.length, vertex_normal_array, tria_index_array, mc_tria_number, dim_x, dim_y, dim_z, close);
                    YaDiV.report(YaDiV.ReportType.REPORT_TIME, "Smoothing         :     " + sw.toString());
                    if (this._restart) continue;
                    if (this._stop_soon) {
                        return;
                    }
                    this.update_mc_geometry_simple(point_array, vertex_normal_array, tria_index_array, this._shp_mc_body, inner_tria_count, inner_point_count);
                    if (this._restart) continue;
                    if (this._stop_soon) {
                        return;
                    }
                    this.update_mc_geometry(point_array, vertex_normal_array, tria_index_array, this._shp_mc_closing, inner_tria_count, mc_tria_number, inner_point_count, point_array.length, shared_map);
                    YaDiV.report(YaDiV.ReportType.REPORT_TIME, "Updating          :     " + sw.toString());
                    YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, String.valueOf(this._parent.get_name()) + " rendered segment with " + mc_tria_number / 3 + " triangles at " + dmc + " in " + sw.toString());
                }
                if (!Settings.get_bool_option(this._parent, SegRenderer3d.OPT_MC_REFINE).booleanValue()) continue;
                dmc /= 2;
            } while (!max_tria_num_reached && !this._restart && !this._stop_soon && Settings.get_bool_option(this._parent, SegRenderer3d.OPT_MC_REFINE).booleanValue() && dmc > 0);
        } while (this._restart && !this._stop_soon);
    }

    private static <T> T[] reallocate(SoftReference<T[]>[] ref, int size, Class<T> klass) {
        Object[] ret;
        T[] TArray = ret = ref[0] == null ? null : ref[0].get();
        if (ret == null || ret.length < size) {
            ret = (Object[])Array.newInstance(klass, size);
            ref[0] = new SoftReference<T[]>(ret);
        }
        return ret;
    }

    private static float[] reallocate(SoftReference<float[]>[] ref, int size, boolean[] hit) {
        float[] ret;
        float[] fArray = ret = ref[0] == null ? null : ref[0].get();
        if (ret == null || ret.length < size) {
            ret = new float[size];
            ref[0] = new SoftReference<float[]>(ret);
            hit[0] = false;
        } else {
            hit[0] = true;
        }
        return ret;
    }

    private void add_layer(int z, ArrayList<Point3f> verts, ArrayList<Point3f> co_verts, IntList trias, IntList co_trias, HashMap<Point3f, Integer> vt_old, HashMap<Point3f, Integer> vt_new, Point3f trans, BitCube bc, int dmc, int xmin, int ymin, int xmax, int ymax, int xdim, int ydim, boolean close, Map<Integer, Integer> shared_map) {
        int y;
        int idx;
        trans.z = z;
        int x = xmin;
        while (x < xmax && !this._restart && !this._stop_soon) {
            idx = 0;
            if (bc.getXYZ(x, 0, z)) {
                idx |= 1;
            }
            if (bc.getXYZ(x + dmc, 0, z)) {
                idx |= 2;
            }
            if (bc.getXYZ(x + dmc, 0, z + dmc)) {
                idx |= 4;
            }
            if (bc.getXYZ(x, 0, z + dmc)) {
                idx |= 8;
            }
            trans.x = x;
            y = ymin;
            while (y < ymax) {
                if (bc.getXYZ(x, y + dmc, z)) {
                    idx |= 0x10;
                }
                if (bc.getXYZ(x + dmc, y + dmc, z)) {
                    idx |= 0x20;
                }
                if (bc.getXYZ(x + dmc, y + dmc, z + dmc)) {
                    idx |= 0x40;
                }
                if (bc.getXYZ(x, y + dmc, z + dmc)) {
                    idx |= 0x80;
                }
                if (idx != 0 && idx != 255) {
                    trans.y = y;
                    this.add_inner_cube(vt_old, vt_new, verts, trias, trans, idx);
                }
                idx >>>= 4;
                y += dmc;
            }
            x += dmc;
        }
        if (close) {
            int x2;
            int y2;
            x = xmin - dmc;
            if (x - dmc <= 0) {
                y = ymin;
                while (y < ymax) {
                    idx = 0;
                    if (y >= 0 && bc.getXYZ(x + dmc, y, z)) {
                        idx |= 2;
                    }
                    if (y >= 0 && bc.getXYZ(x + dmc, y, z + dmc)) {
                        idx |= 4;
                    }
                    if (y + dmc < ydim && bc.getXYZ(x + dmc, y + dmc, z)) {
                        idx |= 0x20;
                    }
                    if (y + dmc < ydim && bc.getXYZ(x + dmc, y + dmc, z + dmc)) {
                        idx |= 0x40;
                    }
                    trans.set((float)x, (float)y, (float)z);
                    this.add_closing_cube(vt_old, vt_new, co_verts, co_trias, trans, idx, shared_map);
                    y += dmc;
                }
            }
            if ((x = xmax) + dmc >= xdim) {
                y = ymin;
                while (y < ymax) {
                    idx = 0;
                    if (y >= 0 && bc.getXYZ(x, y, z)) {
                        idx |= 1;
                    }
                    if (y >= 0 && bc.getXYZ(x, y, z + dmc)) {
                        idx |= 8;
                    }
                    if (y + dmc < ydim && bc.getXYZ(x, y + dmc, z)) {
                        idx |= 0x10;
                    }
                    if (y + dmc < ydim && bc.getXYZ(x, y + dmc, z + dmc)) {
                        idx |= 0x80;
                    }
                    trans.set((float)x, (float)y, (float)z);
                    this.add_closing_cube(vt_old, vt_new, co_verts, co_trias, trans, idx, shared_map);
                    y += dmc;
                }
            }
            if ((y2 = 0 - dmc) - dmc < 0) {
                x2 = xmin - dmc;
                while (x2 < xmax + dmc) {
                    idx = 0;
                    if (x2 >= 0 && bc.getXYZ(x2, y2 + dmc, z)) {
                        idx |= 0x10;
                    }
                    if (x2 + dmc < xdim && bc.getXYZ(x2 + dmc, y2 + dmc, z)) {
                        idx |= 0x20;
                    }
                    if (x2 + dmc < xdim && bc.getXYZ(x2 + dmc, y2 + dmc, z + dmc)) {
                        idx |= 0x40;
                    }
                    if (x2 >= 0 && bc.getXYZ(x2, y2 + dmc, z + dmc)) {
                        idx |= 0x80;
                    }
                    trans.set((float)x2, (float)y2, (float)z);
                    this.add_closing_cube(vt_old, vt_new, co_verts, co_trias, trans, idx, shared_map);
                    x2 += dmc;
                }
            }
            if ((y2 = ymax) + dmc >= ydim) {
                x2 = xmin - dmc;
                while (x2 < xmax + dmc) {
                    idx = 0;
                    if (x2 >= 0 && bc.getXYZ(x2, y2, z)) {
                        idx |= 1;
                    }
                    if (x2 + dmc < xdim && bc.getXYZ(x2 + dmc, y2, z)) {
                        idx |= 2;
                    }
                    if (x2 + dmc < xdim && bc.getXYZ(x2 + dmc, y2, z + dmc)) {
                        idx |= 4;
                    }
                    if (x2 >= 0 && bc.getXYZ(x2, y2, z + dmc)) {
                        idx |= 8;
                    }
                    trans.set((float)x2, (float)y2, (float)z);
                    this.add_closing_cube(vt_old, vt_new, co_verts, co_trias, trans, idx, shared_map);
                    x2 += dmc;
                }
            }
        }
    }

    private void add_closing_cube(HashMap<Point3f, Integer> vt_old, HashMap<Point3f, Integer> vt_new, ArrayList<Point3f> v_vec, IntList trias, Point3f trans, int idx, Map<Integer, Integer> shared) {
        int[] mtrias = this._mtable[idx];
        Point3f a = this._tmp_point;
        int i = 0;
        while (i < mtrias.length) {
            a.set((Tuple3f)this._scaled_v_cache[mtrias[i]]);
            a.add((Tuple3f)trans);
            Integer pos = vt_old.containsKey(a) ? vt_old.get(a) : vt_new.get(a);
            if (pos == null) {
                Point3f new_point;
                pos = ~v_vec.size();
                if (this._vertex_pool_remaining == 0) {
                    new_point = new Point3f(a);
                } else {
                    new_point = this._vertex_pool[--this._vertex_pool_remaining];
                    new_point.set((Tuple3f)a);
                }
                vt_new.put(new_point, pos);
                v_vec.add(new_point);
            } else if (pos >= 0 && !shared.containsKey(pos)) {
                shared.put(pos, shared.size());
            }
            trias.add(pos);
            ++i;
        }
    }

    private void add_inner_cube(HashMap<Point3f, Integer> vt_old, HashMap<Point3f, Integer> vt_new, ArrayList<Point3f> v_vec, IntList trias, Point3f trans, int idx) {
        int[] mtrias = this._mtable[idx];
        Point3f a = this._tmp_point;
        int i = 0;
        while (i < mtrias.length) {
            a.set((Tuple3f)this._scaled_v_cache[mtrias[i]]);
            a.add((Tuple3f)trans);
            Integer pos = vt_old.containsKey(a) ? vt_old.get(a) : vt_new.get(a);
            if (pos == null) {
                Point3f new_point;
                pos = v_vec.size();
                if (this._vertex_pool_remaining == 0) {
                    new_point = new Point3f(a);
                } else {
                    new_point = this._vertex_pool[--this._vertex_pool_remaining];
                    new_point.set((Tuple3f)a);
                }
                new_point.set((Tuple3f)a);
                vt_new.put(new_point, pos);
                v_vec.add(new_point);
            }
            trias.add(pos);
            ++i;
        }
    }

    private void smooth_mc_geometry(Point3f[] point_array, int point_count, Vector3f[] vertex_normal_array, int[] tria_index_array, int tria_count, int xmax, int ymax, int zmax, boolean smooth_closing) {
        int i;
        int t2;
        int t0;
        float[] smooth_point_array;
        float[] multiplicator_array;
        int smooth_zmax;
        int smooth_ymax;
        int smooth_xmax;
        if (point_count == 0) {
            return;
        }
        if (vertex_normal_array.length < point_count) {
            throw new RuntimeException();
        }
        if (this._restart || this._stop_soon) {
            return;
        }
        Integer smooth_cycles = Settings.get_int_option(this._parent, SegRenderer3d.OPT_MC_SMOOTH);
        if (Settings.get_bool_option(this._parent, SegRenderer3d.OPT_MC_SMOOTH_SP).booleanValue()) {
            ImageStack is = MasterControl.get_is();
            double x_spacing = is.get_x_spacing();
            double y_spacing = is.get_y_spacing();
            double z_spacing = is.get_z_spacing();
            double min_spacing = Math.min(Math.min(x_spacing, y_spacing), z_spacing);
            smooth_xmax = (int)Math.round((double)smooth_cycles.intValue() * x_spacing / min_spacing);
            smooth_ymax = (int)Math.round((double)smooth_cycles.intValue() * y_spacing / min_spacing);
            smooth_zmax = (int)Math.round((double)smooth_cycles.intValue() * z_spacing / min_spacing);
        } else {
            smooth_ymax = smooth_zmax = smooth_cycles.intValue();
            smooth_xmax = smooth_zmax;
        }
        if (smooth_cycles > 0) {
            boolean[] hit = new boolean[1];
            multiplicator_array = McRenderThread.reallocate(this._smooth_multiplicator_cache, point_count, hit);
            if (hit[0]) {
                Arrays.fill(multiplicator_array, 0, point_count, 0.0f);
            }
            smooth_point_array = McRenderThread.reallocate(this._smooth_point_cache, point_count, hit);
            int i2 = 0;
            while (i2 < tria_count - 2) {
                t0 = tria_index_array[i2];
                int t1 = tria_index_array[i2 + 1];
                t2 = tria_index_array[i2 + 2];
                int n = t0;
                multiplicator_array[n] = multiplicator_array[n] + 1.0f;
                int n2 = t1;
                multiplicator_array[n2] = multiplicator_array[n2] + 1.0f;
                int n3 = t2;
                multiplicator_array[n3] = multiplicator_array[n3] + 1.0f;
                i2 += 3;
            }
            i2 = 0;
            while (i2 < point_count) {
                multiplicator_array[i2] = 1.0f / multiplicator_array[i2];
                ++i2;
            }
        } else {
            multiplicator_array = null;
            smooth_point_array = null;
        }
        int smooth_steps = 0;
        while (smooth_steps < smooth_xmax) {
            Arrays.fill(smooth_point_array, 0, point_count, 0.0f);
            if (this._restart || this._stop_soon) {
                return;
            }
            int i3 = 0;
            while (i3 < tria_count - 2) {
                t0 = tria_index_array[i3];
                int t1 = tria_index_array[i3 + 1];
                t2 = tria_index_array[i3 + 2];
                float middle = point_array[t0].x + point_array[t1].x + point_array[t2].x;
                int n = t0;
                smooth_point_array[n] = smooth_point_array[n] + middle;
                int n4 = t1;
                smooth_point_array[n4] = smooth_point_array[n4] + middle;
                int n5 = t2;
                smooth_point_array[n5] = smooth_point_array[n5] + middle;
                i3 += 3;
            }
            if (this._restart || this._stop_soon) {
                return;
            }
            i3 = 0;
            while (i3 < point_count) {
                if (point_array[i3].x > 0.0f && point_array[i3].x < (float)(xmax - 1) && (smooth_closing || point_array[i3].y > 0.0f && point_array[i3].y < (float)(ymax - 1) && point_array[i3].z > 0.0f && point_array[i3].z < (float)(zmax - 1))) {
                    int n = i3;
                    smooth_point_array[n] = smooth_point_array[n] * multiplicator_array[i3];
                    point_array[i3].x = (point_array[i3].x - smooth_point_array[i3]) * -0.5f;
                }
                ++i3;
            }
            if (this._restart || this._stop_soon) {
                return;
            }
            ++smooth_steps;
        }
        smooth_steps = 0;
        while (smooth_steps < smooth_ymax) {
            Arrays.fill(smooth_point_array, 0, point_count, 0.0f);
            if (this._restart || this._stop_soon) {
                return;
            }
            int i4 = 0;
            while (i4 < tria_count - 2) {
                t0 = tria_index_array[i4];
                int t1 = tria_index_array[i4 + 1];
                t2 = tria_index_array[i4 + 2];
                float middle = point_array[t0].y + point_array[t1].y + point_array[t2].y;
                int n = t0;
                smooth_point_array[n] = smooth_point_array[n] + middle;
                int n6 = t1;
                smooth_point_array[n6] = smooth_point_array[n6] + middle;
                int n7 = t2;
                smooth_point_array[n7] = smooth_point_array[n7] + middle;
                i4 += 3;
            }
            if (this._restart || this._stop_soon) {
                return;
            }
            i4 = 0;
            while (i4 < point_count) {
                if (point_array[i4].y > 0.0f && point_array[i4].y < (float)(ymax - 1) && (smooth_closing || point_array[i4].x > 0.0f && point_array[i4].x < (float)(xmax - 1) && point_array[i4].z > 0.0f && point_array[i4].z < (float)(zmax - 1))) {
                    int n = i4;
                    smooth_point_array[n] = smooth_point_array[n] * multiplicator_array[i4];
                    point_array[i4].y = (point_array[i4].y - smooth_point_array[i4]) * -0.5f;
                }
                ++i4;
            }
            if (this._restart || this._stop_soon) {
                return;
            }
            ++smooth_steps;
        }
        smooth_steps = 0;
        while (smooth_steps < smooth_zmax) {
            Arrays.fill(smooth_point_array, 0, point_count, 0.0f);
            if (this._restart || this._stop_soon) {
                return;
            }
            int i5 = 0;
            while (i5 < tria_count - 2) {
                t0 = tria_index_array[i5];
                int t1 = tria_index_array[i5 + 1];
                t2 = tria_index_array[i5 + 2];
                float middle = point_array[t0].z + point_array[t1].z + point_array[t2].z;
                int n = t0;
                smooth_point_array[n] = smooth_point_array[n] + middle;
                int n8 = t1;
                smooth_point_array[n8] = smooth_point_array[n8] + middle;
                int n9 = t2;
                smooth_point_array[n9] = smooth_point_array[n9] + middle;
                i5 += 3;
            }
            if (this._restart || this._stop_soon) {
                return;
            }
            i5 = 0;
            while (i5 < point_count) {
                if (point_array[i5].z > 0.0f && point_array[i5].z < (float)(zmax - 1) && (smooth_closing || point_array[i5].x > 0.0f && point_array[i5].x < (float)(xmax - 1) && point_array[i5].y > 0.0f && point_array[i5].y < (float)(ymax - 1))) {
                    int n = i5;
                    smooth_point_array[n] = smooth_point_array[n] * multiplicator_array[i5];
                    point_array[i5].z = (point_array[i5].z - smooth_point_array[i5]) * -0.5f;
                }
                ++i5;
            }
            if (this._restart || this._stop_soon) {
                return;
            }
            ++smooth_steps;
        }
        if (vertex_normal_array[point_count - 1] == null) {
            i = 0;
            while (i < point_count) {
                vertex_normal_array[i] = new Vector3f();
                ++i;
            }
        } else {
            i = 0;
            while (i < point_count) {
                vertex_normal_array[i].set(0.0f, 0.0f, 0.0f);
                ++i;
            }
        }
        if (this._restart || this._stop_soon) {
            return;
        }
        Vector3f tria_normal = new Vector3f();
        Vector3f ba = new Vector3f();
        Vector3f ca = new Vector3f();
        int i6 = 0;
        while (i6 < tria_count - 2) {
            int t02 = tria_index_array[i6];
            int t1 = tria_index_array[i6 + 1];
            int t22 = tria_index_array[i6 + 2];
            ba.sub((Tuple3f)point_array[t1], (Tuple3f)point_array[t02]);
            ca.sub((Tuple3f)point_array[t22], (Tuple3f)point_array[t02]);
            tria_normal.cross(ba, ca);
            tria_normal.normalize();
            vertex_normal_array[t02].add((Tuple3f)tria_normal);
            vertex_normal_array[t1].add((Tuple3f)tria_normal);
            vertex_normal_array[t22].add((Tuple3f)tria_normal);
            i6 += 3;
        }
        if (this._restart || this._stop_soon) {
            return;
        }
        i6 = 0;
        while (i6 < point_count) {
            vertex_normal_array[i6].normalize();
            ++i6;
        }
    }

    private void update_mc_geometry(Point3f[] point_array, Vector3f[] vertex_normal_array, int[] tria_index_array, Shape3D shp, int tria_offset, int tria_high, int vert_offset, int vert_high, Map<Integer, Integer> shared) {
        if (tria_offset == tria_high) {
            shp.setGeometry(null);
            return;
        }
        IndexedTriangleArray gtrias = new IndexedTriangleArray(shared.size() + vert_high - vert_offset, 3, tria_high - tria_offset);
        gtrias.setCoordinates(0, point_array, vert_offset, vert_high - vert_offset);
        gtrias.setNormals(0, vertex_normal_array, vert_offset, vert_high - vert_offset);
        for (Map.Entry<Integer, Integer> e : shared.entrySet()) {
            gtrias.setCoordinate(vert_high - vert_offset + e.getValue(), point_array[e.getKey()]);
            gtrias.setNormal(vert_high - vert_offset + e.getValue(), vertex_normal_array[e.getKey()]);
        }
        int i = tria_offset;
        while (i < tria_high) {
            int target = tria_index_array[i];
            target = target < vert_offset ? shared.get(target) + vert_high - vert_offset : (target -= vert_offset);
            gtrias.setCoordinateIndex(i - tria_offset, target);
            gtrias.setNormalIndex(i - tria_offset, target);
            ++i;
        }
        if (this._restart || this._stop_soon) {
            return;
        }
        this._tg_mc.setTransform(new Transform3D());
        shp.setGeometry((Geometry)gtrias);
    }

    private void update_mc_geometry_simple(Point3f[] point_array, Vector3f[] vertex_normal_array, int[] tria_index_array, Shape3D shp, int tria_high, int vert_high) {
        if (tria_high == 0) {
            shp.setGeometry(null);
            return;
        }
        IndexedTriangleArray gtrias = new IndexedTriangleArray(vert_high, 3, tria_high);
        gtrias.setCoordinates(0, point_array, 0, vert_high);
        gtrias.setNormals(0, vertex_normal_array, 0, vert_high);
        int i = 0;
        while (i < tria_high) {
            int target = tria_index_array[i];
            gtrias.setCoordinateIndex(i, target);
            gtrias.setNormalIndex(i, target);
            ++i;
        }
        if (this._restart || this._stop_soon) {
            return;
        }
        if (Settings.get_bool_option(this._parent, SegRenderer3d.OPT_STRIPIFY).booleanValue()) {
            this._tg_mc.setTransform(new Transform3D());
            GeometryInfo gi = new GeometryInfo((GeometryArray)gtrias);
            Stripifier st = new Stripifier();
            st.stripify(gi);
            TriangleStripArray itsa = (TriangleStripArray)gi.getGeometryArray();
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "Strips: " + itsa.getNumStrips());
            shp.setGeometry((Geometry)gi.getGeometryArray());
        } else {
            shp.setGeometry((Geometry)gtrias);
        }
    }
}

