/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.Geometry;
import javax.media.j3d.PointArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import main.Segment;
import main.YaDiV;
import misc.StopWatch;
import misc.grid.BitCube;
import renderer.SegRenderer3d;
import settings.Settings;
import settings.SettingsOwner;
import threads.RenderThread;

public class Points3dRenderThread
extends RenderThread {
    private static final Transform3D IDENTITY = new Transform3D();
    private final Segment _seg;
    private final TransformGroup _tg_points;
    private final Shape3D _shp_points;

    public Points3dRenderThread(SettingsOwner parent, Segment seg, Shape3D shp_points, TransformGroup tg_pts) {
        super(parent, false);
        this._seg = seg;
        this._shp_points = shp_points;
        this._tg_points = tg_pts;
    }

    @Override
    public void my_run() {
        LinkedList<Point3f> v_list = new LinkedList<Point3f>();
        StopWatch sw = new StopWatch();
        do {
            sw.reset();
            this._restart = false;
            v_list.clear();
            BitCube bc = this._seg.get_bc();
            int[] bb_min = new int[3];
            int[] bb_max = new int[3];
            System.arraycopy(bc._bb_min, 0, bb_min, 0, 3);
            System.arraycopy(bc._bb_max, 0, bb_max, 0, 3);
            int cluster_spacing = Settings.get_int_option(this._parent, SegRenderer3d.OPT_POINT_DIST);
            int max_point_number = Settings.get_int_option(this._parent, SegRenderer3d.OPT_POINT_MAX);
            if (bb_min[0] > bb_max[0]) {
                this._shp_points.setGeometry(null);
                return;
            }
            int z = bb_min[2];
            do {
                int y = bb_min[1];
                do {
                    int x = bb_min[0];
                    do {
                        if (!bc.getXYZ(x, y, z)) continue;
                        v_list.add(new Point3f((float)x, (float)y, (float)z));
                    } while ((x += cluster_spacing) <= bb_max[0]);
                } while ((y += cluster_spacing) <= bb_max[1]);
            } while ((z += cluster_spacing) <= bb_max[2] && v_list.size() <= max_point_number);
            if (v_list.size() > 0) {
                PointArray points = new PointArray(v_list.size(), 1);
                int pos = 0;
                Iterator vli = v_list.iterator();
                while (vli.hasNext()) {
                    points.setCoordinate(pos, (Point3f)vli.next());
                    ++pos;
                }
                this._tg_points.setTransform(IDENTITY);
                this._shp_points.setGeometry((Geometry)points);
            } else {
                this._tg_points.setTransform(IDENTITY);
                this._shp_points.setGeometry(null);
            }
            String debug_msg = new String(String.valueOf(this._parent.get_name()) + " rendered " + v_list.size() + " points in " + sw);
            if (v_list.size() > max_point_number) {
                debug_msg = String.valueOf(debug_msg) + " (aborted)";
            }
            YaDiV.report(YaDiV.ReportType.REPORT_TIME, debug_msg);
        } while (this._restart);
    }
}

