/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import misc.messages.YObservable;
import misc.messages.YObserver;

public abstract class Renderer2d
extends YObservable
implements YObserver {
    public static final int M_REQUEST_REDRAW = Message.register_message("Renderer2d RequestRedraw");
    protected static int[] _w = new int[3];
    protected static int[] _h = new int[3];
    protected boolean _visible = true;
    protected BufferedImage[] _bimg = new BufferedImage[3];
    protected int[][] _pixels = new int[3][];

    public Renderer2d() {
        MasterControl.get_is().addObserver(this, "Renderer2d()");
    }

    public void allocate() {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 0) {
            Renderer2d._w[0] = 5;
            Renderer2d._w[1] = 5;
            Renderer2d._w[2] = 5;
            Renderer2d._h[0] = 5;
            Renderer2d._h[1] = 5;
            Renderer2d._h[2] = 5;
        } else {
            Renderer2d._w[0] = is.get_dim_x();
            Renderer2d._w[1] = is.get_dim_y();
            Renderer2d._w[2] = is.get_dim_x();
            Renderer2d._h[0] = is.get_dim_y();
            Renderer2d._h[1] = is.get_dim_z();
            Renderer2d._h[2] = is.get_dim_z();
        }
        int i = 0;
        while (i < 3) {
            this._bimg[i] = new BufferedImage(_w[i], _h[i], 2);
            this._pixels[i] = ((DataBufferInt)this._bimg[i].getRaster().getDataBuffer()).getData();
            ++i;
        }
    }

    public boolean is_visible() {
        return this._visible;
    }

    public void set_visible(boolean visible) {
        this._visible = visible;
    }

    public abstract Image render_image(int var1, int var2);

    @Override
    public void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_VC_SET) {
            this.allocate();
        }
    }
}

