/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import misc.grid.BitCube;
import misc.messages.YObservable;
import renderer.Renderer2d;
import settings.Settings;
import settings.SettingsOwner;

public class SegRenderer2d
extends Renderer2d
implements SettingsOwner {
    public static final String OPT_ALPHA = Settings.register_int_opt(SegRenderer2d.class, "alpha", "Transparency value for segment rendering", 50);
    public static final String OPT_VISIBLE = Settings.register_bool_opt(SegRenderer2d.class, "visible", "If false, the segment is not rendered", true);
    public static final String OPT_SHOW_BB = Settings.register_bool_opt(SegRenderer2d.class, "show bb", "Enables tha optional rendering of the segment bounding box", false);
    private final Segment _seg;
    private final String _name;

    public SegRenderer2d(Segment seg) {
        this._seg = seg;
        this._name = "SR2d " + this._seg.get_name();
        this._seg.addObserver(this, "SegRenderer2d() ");
        Settings.register_owner(this);
    }

    public SegRenderer2d(Segment seg, String name) {
        this._seg = seg;
        this._name = String.valueOf(this._seg.get_name()) + " " + name;
        this._seg.addObserver(this, "SegRenderer2d() " + this._name);
        Settings.register_owner(this);
    }

    public void free_all() {
        this._seg.deleteObserver(this, "segment deleted");
        MasterControl.get_is().deleteObserver(this, "segment deleted");
        Settings.unregister_owner(this);
    }

    @Override
    public void set_visible(boolean visible) {
        if (this._visible && !visible) {
            this._seg.deleteObserver(this);
        }
        if (!this._visible && visible) {
            this._seg.addObserver(this, "SegRenderer2d::set_visible");
        }
        super.set_visible(visible);
    }

    @Override
    public Image render_image(int mode, int slice_number) {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 0 || !Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
            return this._bimg[mode];
        }
        int alpha = Settings.get_int_option(this, OPT_ALPHA);
        int argb = this._seg.get_color() | alpha << 24;
        BitCube bc = this._seg.get_bc();
        int[] pixels = this._pixels[mode];
        if (mode == 0) {
            int y = 0;
            while (y < _h[mode]) {
                int pixel_counter = y * _w[mode];
                int x = 0;
                while (x < _w[mode]) {
                    pixels[pixel_counter] = bc.getXYZ(x, y, slice_number) ? argb : 0;
                    ++pixel_counter;
                    ++x;
                }
                ++y;
            }
            if (Settings.get_bool_option(this, OPT_SHOW_BB).booleanValue()) {
                Graphics g = this._bimg[mode].getGraphics();
                g.setColor(Color.WHITE);
                g.drawRect(this._seg.get_bc()._bb_min[0], this._seg.get_bc()._bb_min[1], this._seg.get_bc()._bb_max[0] - this._seg.get_bc()._bb_min[0], this._seg.get_bc()._bb_max[1] - this._seg.get_bc()._bb_min[1]);
            }
        } else if (mode == 1) {
            int z = 0;
            while (z < _h[mode]) {
                int pixel_counter = z * _w[mode];
                int y = 0;
                while (y < _w[mode]) {
                    pixels[pixel_counter] = bc.getXYZ(slice_number, y, z) ? argb : 0;
                    ++pixel_counter;
                    ++y;
                }
                ++z;
            }
            if (Settings.get_bool_option(this, OPT_SHOW_BB).booleanValue()) {
                Graphics g = this._bimg[mode].getGraphics();
                g.setColor(Color.WHITE);
                g.drawRect(this._seg.get_bc()._bb_min[1], this._seg.get_bc()._bb_min[2], this._seg.get_bc()._bb_max[1] - this._seg.get_bc()._bb_min[1], this._seg.get_bc()._bb_max[2] - this._seg.get_bc()._bb_min[2]);
            }
        } else {
            int z = 0;
            while (z < _h[mode]) {
                int pixel_counter = z * _w[mode];
                int x = 0;
                while (x < _w[mode]) {
                    pixels[pixel_counter] = bc.getXYZ(x, slice_number, z) ? argb : 0;
                    ++pixel_counter;
                    ++x;
                }
                ++z;
            }
            if (Settings.get_bool_option(this, OPT_SHOW_BB).booleanValue()) {
                Graphics g = this._bimg[mode].getGraphics();
                g.setColor(Color.WHITE);
                g.drawRect(this._seg.get_bc()._bb_min[0], this._seg.get_bc()._bb_min[2], this._seg.get_bc()._bb_max[0] - this._seg.get_bc()._bb_min[0], this._seg.get_bc()._bb_max[2] - this._seg.get_bc()._bb_min[2]);
            }
        }
        return this._bimg[mode];
    }

    public final Segment get_seg() {
        return this._seg;
    }

    @Override
    public void update(YObservable o, Message m) {
        super.update(o, m);
        if (m._type == Segment.M_SEG_SIZE_CHANGED) {
            this.allocate();
        } else if (m._type == ImageStack.M_DEL_SEGMENT && m._obj == this._seg) {
            this.free_all();
        } else if (m._type == Segment.M_SEG_CHANGED || m._type == Segment.M_SEG_COL_CHANGED || m._type == Segment.M_SEG_SLICE_LOADED) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }

    @Override
    public String get_name() {
        return this._name;
    }

    public String toString() {
        return "SegRenderer2D: " + this.get_name();
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_ALPHA || opt_name == OPT_SHOW_BB) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
        if (opt_name == OPT_VISIBLE) {
            if (!((Boolean)opt).booleanValue()) {
                int m = 0;
                while (m < 3) {
                    int i = 0;
                    while (i < this._pixels[m].length) {
                        this._pixels[m][i] = 0;
                        ++i;
                    }
                    ++m;
                }
            }
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }
}

