/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.SegChangeInfo;
import main.Segment;
import main.view3d.Viewport3d;
import misc.messages.YObservable;
import renderer.McRenderThread;
import renderer.Points3dRenderThread;
import renderer.Renderer3d;
import settings.Settings;
import settings.SettingsOwner;

public final class SegRenderer3d
extends Renderer3d
implements SettingsOwner {
    public static final String OPT_SHOW_POINTS = Settings.register_bool_opt(SegRenderer3d.class, "draw points", "Enables or disables the rendering of the segment as a point cloud.", false);
    public static final String OPT_SHOW_MC = Settings.register_bool_opt(SegRenderer3d.class, "draw mc", "Enables or disables the Marching Cube rendering of the segment surface.", true);
    public static final String OPT_SHOW_TEX2D = Settings.register_bool_opt(SegRenderer3d.class, "draw tex 2d", "True if the segment should be shown in the texture2d background rendering.", false);
    public static final String OPT_SHOW_TEX3D = Settings.register_bool_opt(SegRenderer3d.class, "draw tex 3d", "True if the segment should be shown in the texture3d background rendering.", false);
    public static final String OPT_VISIBLE = Settings.register_bool_opt(SegRenderer3d.class, "visible", "Determines if the segment is visible or not.", false);
    public static final String OPT_POINT_TRANS = Settings.register_double_opt(SegRenderer3d.class, "point transparency", "Transparency for the PointCloud if show points is enabled.", 0.0);
    public static final String OPT_POINT_DIST = Settings.register_int_opt(SegRenderer3d.class, "point dist", "Distance between two voxels in point cloud rendering. Lower distances result in more dense point cloudand slower rendering.", 1);
    public static final String OPT_POINT_SIZE = Settings.register_int_opt(SegRenderer3d.class, "point size", "Size of the Points.", 2);
    public static final String OPT_POINT_CIRCLES = Settings.register_bool_opt(SegRenderer3d.class, "point style circles", "Draws Points as Circles.", false);
    public static final String OPT_POINT_MAX = Settings.register_int_opt(SegRenderer3d.class, "point max number", "Maximum number of points that will be send to the GFX card. This is necessary because some gfx cardsstop or even crash when to many points are sent.", 5000000);
    public static final String OPT_MC_CLOSING = Settings.register_bool_opt(SegRenderer3d.class, "mc closing", "Enables or disables if the Marching Cube closing surface (at the voxel cube borders) shouldbe shown.", true);
    public static final String OPT_MC_REFINE = Settings.register_bool_opt(SegRenderer3d.class, "mc refine", "If refining is enabled, the Marching Cube Algorithm starts with a low (but fast) resolution andwhich is refined step-wise.", true);
    public static final String OPT_MC_REFINE_MIN_BB_DIAG = Settings.register_int_opt(SegRenderer3d.class, "mc refine min bb", "Minimum bounding box size before the refining is enabled. Very small segments dont need to be refined.", 100000);
    public static final String OPT_MC_SMOOTH = Settings.register_int_opt(SegRenderer3d.class, "mc smooth", "Number of smoothing circles for the MC algorithm. The more circles, the smoother (but also more wrong) the resultingsurface. If set to 0, smoothing is completely disabled.", 3);
    public static final String OPT_MC_SMOOTH_SP = Settings.register_bool_opt(SegRenderer3d.class, "mc smooth spacing", "If set to true, the smoothing method tries to incorperate the spacings in x-, y and z-direction.", true);
    public static final String OPT_MC_MAX_TRIAS = Settings.register_int_opt(SegRenderer3d.class, "mc maximum tria num", "Maximum number of triangles for the Marching Cube algorithm. This is necessary because some gfx cardsstop when two many triangles are rendered.", 1000000);
    public static final String OPT_MC_WIREFRAME = Settings.register_bool_opt(SegRenderer3d.class, "mc wireframe", "Show MC Surface as wireframe", false);
    public static final String OPT_MC_DIST = Settings.register_int_opt(SegRenderer3d.class, "mc dist", "Voxel-Distance for the Marching Cube algorithm. Larger distance values results in faster renderingbut worse approximation. If refining is enabled, this option is used for the initial rendering.", 4);
    public static final String OPT_MC_OLD_LUT = Settings.register_bool_opt(SegRenderer3d.class, "mc old table", "True if the original marching cube table should be used. The new table does not produce holes.", false);
    public static final String OPT_STRIPIFY = Settings.register_bool_opt(SegRenderer3d.class, "stripify mc", "Use Java Stripifier", false);
    private final Segment _seg;
    private final Shape3D _shp_mc_body;
    private final Shape3D _shp_mc_closing;
    private final Shape3D _shp_points;
    private final ColoringAttributes _ca_mc = new ColoringAttributes();
    private final ColoringAttributes _ca_points = new ColoringAttributes();
    private final PolygonAttributes _pa_mc = new PolygonAttributes();
    private Material _mat_mc;
    private final TransformGroup _tg_mc;
    private final TransformGroup _tg_pts;
    private final PointAttributes _pa_points = new PointAttributes();
    private final TransparencyAttributes _point_trans;
    private McRenderThread _mc_render_thread;
    private Points3dRenderThread _point_render_thread;
    private final Appearance _point_appearance;

    public SegRenderer3d(Viewport3d v3d, int scene_id, Segment seg) {
        super(v3d, scene_id);
        this._seg = seg;
        Settings.register_owner(this);
        this._visible = Settings.get_bool_option(this, OPT_VISIBLE);
        this._tg_mc = new TransformGroup();
        this._tg_mc.setCapability(17);
        this._tg_mc.setCapability(18);
        this._tg_pts = new TransformGroup();
        this._tg_pts.setCapability(17);
        this._tg_pts.setCapability(18);
        this._bg.addChild((Node)this._tg_mc);
        this._bg.addChild((Node)this._tg_pts);
        float trans = Settings.get_double_option(this, OPT_POINT_TRANS).floatValue();
        this._point_trans = new TransparencyAttributes(2, trans);
        this._point_trans.setCapability(3);
        this._shp_mc_body = new Shape3D();
        this._shp_mc_body.setCapability(13);
        this._shp_mc_body.setCapability(15);
        this._shp_mc_body.setAppearance(this.create_mc_appearance());
        this._tg_mc.addChild((Node)this._shp_mc_body);
        this._shp_mc_closing = new Shape3D();
        this._shp_mc_closing.setCapability(13);
        this._shp_mc_closing.setCapability(15);
        this._shp_mc_closing.setAppearance(this.create_mc_closing_appearance());
        this._tg_mc.addChild((Node)this._shp_mc_closing);
        this._shp_points = new Shape3D();
        this._shp_points.setCapability(13);
        this._shp_points.setCapability(15);
        this._point_appearance = this.create_point_appearance();
        this._shp_points.setAppearance(this._point_appearance);
        this._tg_pts.addChild((Node)this._shp_points);
        this._mc_render_thread = null;
        this._point_render_thread = null;
        seg.addObserver(this, "SegRenderer3d()");
        MasterControl.get_is().addObserver(this, "SegRenderer3d()");
        if (Settings.get_bool_option(this, OPT_VISIBLE).booleanValue()) {
            this.set_visible(false);
            this.set_visible(true);
        }
    }

    public void free_all() {
        this._seg.deleteObserver(this, "SegRenderer3d()");
        MasterControl.get_is().deleteObserver(this, "SegRenderer3d()");
        Settings.unregister_owner(this);
    }

    private final Appearance create_mc_appearance() {
        Color seg_color = new Color(this._seg.get_color());
        Color3f seg_color3f = new Color3f(seg_color);
        Appearance ap = new Appearance();
        this._ca_mc.setCapability(1);
        this._ca_mc.setShadeModel(3);
        this._ca_mc.setColor(seg_color3f);
        ap.setColoringAttributes(this._ca_mc);
        this._pa_mc.setCapability(3);
        this._pa_mc.setCullFace(1);
        if (Settings.get_bool_option(this, OPT_MC_WIREFRAME).booleanValue()) {
            this._pa_mc.setPolygonMode(1);
        } else {
            this._pa_mc.setPolygonMode(2);
        }
        ap.setPolygonAttributes(this._pa_mc);
        this._mat_mc = new Material();
        this._mat_mc.setCapability(1);
        this._mat_mc.setShininess(50.0f);
        this._mat_mc.setDiffuseColor(seg_color3f);
        this._mat_mc.setSpecularColor(new Color3f(0.8f, 0.8f, 0.8f));
        ap.setMaterial(this._mat_mc);
        return ap;
    }

    private final Appearance create_mc_closing_appearance() {
        Color seg_color = new Color(this._seg.get_color());
        float r = seg_color.getRed() + 2 * (255 - seg_color.getRed()) / 3;
        float g = seg_color.getGreen() + 2 * (255 - seg_color.getGreen()) / 3;
        float b = seg_color.getBlue() + 2 * (255 - seg_color.getBlue()) / 3;
        Color3f closing_color = new Color3f(r / 255.0f, g / 255.0f, b / 255.0f);
        Appearance ap = new Appearance();
        ColoringAttributes ca = new ColoringAttributes();
        ca.setShadeModel(3);
        ca.setColor(closing_color);
        ap.setColoringAttributes(ca);
        ap.setPolygonAttributes(this._pa_mc);
        Material mat = new Material();
        mat.setShininess(50.0f);
        mat.setDiffuseColor(closing_color);
        mat.setSpecularColor(new Color3f(0.8f, 0.8f, 0.8f));
        ap.setMaterial(mat);
        return ap;
    }

    private final Appearance create_point_appearance() {
        Color seg_color = new Color(this._seg.get_color());
        Color3f seg_color3f = new Color3f(seg_color);
        Appearance ap = new Appearance();
        this._ca_points.setColor(seg_color3f);
        this._ca_points.setCapability(1);
        ap.setCapability(11);
        this._pa_points.setPointSize((float)Settings.get_int_option(this, OPT_POINT_SIZE).intValue());
        this._pa_points.setPointAntialiasingEnable(Settings.get_bool_option(this, OPT_POINT_CIRCLES).booleanValue());
        this._pa_points.setCapability(1);
        this._pa_points.setCapability(3);
        ap.setCapability(19);
        ap.setColoringAttributes(this._ca_points);
        ap.setPointAttributes(this._pa_points);
        if ((double)this._point_trans.getTransparency() > 0.0) {
            ap.setTransparencyAttributes(this._point_trans);
        }
        return ap;
    }

    private final void create_seg_marching() {
        if (this._mc_render_thread == null || this._mc_render_thread.getState() == Thread.State.TERMINATED) {
            this._mc_render_thread = new McRenderThread(this, this._seg, this._shp_mc_body, this._shp_mc_closing, this._tg_mc, this._mc_render_thread);
            this._mc_render_thread.start();
        } else {
            this._mc_render_thread.restart();
        }
    }

    private final void create_seg_pointcloud() {
        if (this._point_render_thread == null || this._point_render_thread.getState() == Thread.State.TERMINATED) {
            this._point_render_thread = new Points3dRenderThread(this, this._seg, this._shp_points, this._tg_pts);
            this._point_render_thread.start();
        } else {
            this._point_render_thread.restart();
        }
    }

    @Override
    public final void create_scene() {
        if (this._visible) {
            if (Settings.get_bool_option(this, OPT_SHOW_POINTS).booleanValue()) {
                this.create_seg_pointcloud();
            } else {
                this._shp_points.setGeometry(null);
            }
            if (Settings.get_bool_option(this, OPT_SHOW_MC).booleanValue()) {
                this.create_seg_marching();
            } else {
                this._shp_mc_body.setGeometry(null);
                this._shp_mc_closing.setGeometry(null);
            }
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._type == Segment.M_SEG_CHANGED) {
            SegChangeInfo sci = (SegChangeInfo)m._obj;
            if (sci._change_type == SegChangeInfo.TRANSLATION) {
                int[] trans = (int[])sci._data;
                Transform3D tf3d_newtrans = new Transform3D();
                tf3d_newtrans.setTranslation(new Vector3f((float)trans[0], (float)trans[1], (float)trans[2]));
                Transform3D tf3d_trans = new Transform3D();
                this._tg_mc.getTransform(tf3d_trans);
                tf3d_trans.mul(tf3d_newtrans);
                this._tg_mc.setTransform(tf3d_trans);
                this._tg_pts.getTransform(tf3d_trans);
                tf3d_trans.mul(tf3d_newtrans);
                this._tg_pts.setTransform(tf3d_trans);
                if (this._mc_render_thread != null && this._mc_render_thread.getState() != Thread.State.TERMINATED) {
                    this._mc_render_thread.restart();
                }
                if (this._point_render_thread != null && this._point_render_thread.getState() != Thread.State.TERMINATED) {
                    this._point_render_thread.restart();
                }
            } else {
                this.create_scene();
            }
        } else if (m._type == Segment.M_SEG_COL_CHANGED) {
            Color seg_color = new Color(this._seg.get_color());
            Color3f seg_color3f = new Color3f(seg_color);
            this._ca_mc.setColor(seg_color3f);
            this._ca_points.setColor(seg_color3f);
            this._mat_mc.setDiffuseColor(seg_color3f);
        } else if (m._type == ImageStack.M_DEL_SEGMENT && m._obj == this._seg) {
            this.free_all();
        }
    }

    public final Segment get_seg() {
        return this._seg;
    }

    public Shape3D get_shp_mc_body() {
        return this._shp_mc_body;
    }

    public Shape3D get_shp_mc_closing() {
        return this._shp_mc_closing;
    }

    public Shape3D get_shp_points() {
        return this._shp_points;
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_SHOW_POINTS || opt_name == OPT_POINT_DIST) {
            if (Settings.get_bool_option(this, OPT_SHOW_POINTS).booleanValue()) {
                this.create_seg_pointcloud();
            } else {
                this._shp_points.setGeometry(null);
            }
        } else if (opt_name == OPT_MC_OLD_LUT || opt_name == OPT_STRIPIFY || opt_name == OPT_MC_DIST || opt_name == OPT_MC_CLOSING || opt_name == OPT_MC_MAX_TRIAS || opt_name == OPT_MC_REFINE || opt_name == OPT_MC_SMOOTH || opt_name == OPT_MC_SMOOTH_SP) {
            if (Settings.get_bool_option(this, OPT_VISIBLE).booleanValue() && Settings.get_bool_option(this, OPT_SHOW_MC).booleanValue()) {
                this.create_seg_marching();
            }
        } else if (opt_name == OPT_SHOW_MC) {
            if (Settings.get_bool_option(this, OPT_SHOW_MC).booleanValue()) {
                this.create_seg_marching();
            } else {
                if (this._mc_render_thread != null) {
                    this._mc_render_thread.stop_soon();
                }
                this._shp_mc_body.setGeometry(null);
                this._shp_mc_closing.setGeometry(null);
            }
        } else if (opt_name == OPT_POINT_TRANS) {
            float trans = Settings.get_double_option(this, OPT_POINT_TRANS).floatValue();
            if ((double)trans != 0.0) {
                this._point_trans.setTransparency(trans);
                this._point_appearance.setTransparencyAttributes(this._point_trans);
            } else {
                this._point_appearance.setTransparencyAttributes(null);
            }
        } else if (opt_name == OPT_POINT_SIZE) {
            this._pa_points.setPointSize((float)Settings.get_int_option(this, OPT_POINT_SIZE).intValue());
        } else if (opt_name == OPT_POINT_CIRCLES) {
            this._pa_points.setPointAntialiasingEnable(Settings.get_bool_option(this, OPT_POINT_CIRCLES).booleanValue());
        } else if (opt_name == OPT_SHOW_TEX2D) {
            if (this._visible) {
                MasterControl.get_v3d().get_tex2_renderer().show_seg(this._seg, (Boolean)opt);
            }
        } else if (opt_name == OPT_SHOW_TEX3D) {
            if (this._visible) {
                MasterControl.get_v3d().get_tex3_renderer().show_seg(this._seg, (Boolean)opt);
            }
        } else if (opt_name == OPT_MC_WIREFRAME) {
            if (((Boolean)opt).booleanValue()) {
                this._pa_mc.setPolygonMode(1);
            } else {
                this._pa_mc.setPolygonMode(2);
            }
        } else if (opt_name == OPT_VISIBLE) {
            boolean visible = (Boolean)opt;
            if (this._visible && !visible) {
                if (Settings.get_bool_option(this, OPT_SHOW_TEX2D).booleanValue()) {
                    MasterControl.get_v3d().get_tex2_renderer().show_seg(this._seg, false);
                }
                if (Settings.get_bool_option(this, OPT_SHOW_TEX3D).booleanValue()) {
                    MasterControl.get_v3d().get_tex3_renderer().show_seg(this._seg, false);
                }
            }
            if (!this._visible && visible) {
                if (Settings.get_bool_option(this, OPT_SHOW_TEX2D).booleanValue()) {
                    MasterControl.get_v3d().get_tex2_renderer().show_seg(this._seg, true);
                }
                if (Settings.get_bool_option(this, OPT_SHOW_TEX3D).booleanValue()) {
                    MasterControl.get_v3d().get_tex3_renderer().show_seg(this._seg, true);
                }
            }
            this.set_visible(visible);
        }
    }

    @Override
    public final String get_name() {
        return "SR3D " + this._seg.get_name();
    }
}

