/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import main.Segment;
import misc.grid.BitCube;
import misc.grid.VoxelCube;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import raycaster.SegmentTfMerger;
import renderer.SegmentColorTableMap;

public class SegmentColorTableMapTest {
    private final int CUBE_SIZE = 2;
    private final int cube_color1 = new Color(1, 1, 1, 1).getRGB();
    private final int cube_color2 = new Color(2, 2, 2, 2).getRGB();
    private final int segment1_color1 = new Color(3, 3, 3, 3).getRGB();
    private final int segment1_color2 = new Color(4, 4, 4, 4).getRGB();
    private final int segment2_color1 = new Color(5, 5, 5, 5).getRGB();
    private final int segment2_color2 = new Color(6, 6, 6, 6).getRGB();
    private VoxelCube _voxel_cube = new VoxelCube(2, 2, 2);
    private int[] _voxel_cube_color_table = new int[]{this.cube_color1, this.cube_color2};
    private Segment _segment1 = new Segment("Segment1", 2, 2, 2);
    private int[] _segment1_color_table = new int[]{this.segment1_color1, this.segment1_color2};
    private Segment _segment2 = new Segment("Segment2", 2, 2, 2);
    private int[] _segment2_color_table = new int[]{this.segment2_color1, this.segment2_color2};
    private SegmentColorTableMap _color_table_map;

    @Before
    public void set_up() {
        this.initialize_voxel_cube();
        this.initialize_segment1();
        this.initialize_segment2();
        this._color_table_map = new SegmentColorTableMap(SegmentTfMerger.MAX_PRIORITY, this._voxel_cube, this._voxel_cube_color_table);
    }

    private void initialize_voxel_cube() {
        this._voxel_cube.set(0, 0, 0, 1);
        this._voxel_cube.set(0, 0, 1, 1);
        this._voxel_cube.set(1, 0, 0, 1);
        this._voxel_cube.set(1, 0, 1, 1);
    }

    private void initialize_segment1() {
        BitCube bit_cube = this._segment1.get_bc();
        bit_cube.set(0, 0, 0, 1);
        bit_cube.set(0, 0, 1, 1);
        bit_cube.set(0, 1, 0, 1);
        bit_cube.set(0, 1, 1, 1);
    }

    private void initialize_segment2() {
        BitCube bit_cube = this._segment2.get_bc();
        bit_cube.set(0, 0, 0, 1);
        bit_cube.set(0, 1, 0, 1);
        bit_cube.set(1, 0, 0, 1);
        bit_cube.set(1, 1, 0, 1);
    }

    @Test
    public void test_color_at_with_no_segments() {
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(0, 0, 0));
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(0, 0, 1));
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(1, 0, 0));
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(1, 0, 1));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(0, 1, 0));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(0, 1, 1));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(1, 1, 0));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(1, 1, 1));
    }

    @Test
    public void test_color_at_with_one_segment() {
        this._color_table_map.add_segment(this._segment1, this._segment1_color_table);
        Assert.assertEquals((long)this.segment1_color2, (long)this._color_table_map.color_at(0, 0, 0));
        Assert.assertEquals((long)this.segment1_color2, (long)this._color_table_map.color_at(0, 0, 1));
        Assert.assertEquals((long)this.segment1_color1, (long)this._color_table_map.color_at(0, 1, 0));
        Assert.assertEquals((long)this.segment1_color1, (long)this._color_table_map.color_at(0, 1, 1));
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(1, 0, 0));
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(1, 0, 1));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(1, 1, 0));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(1, 1, 1));
    }

    @Test
    public void test_color_at_with_two_segments_and_segment1_first() {
        this._color_table_map.add_segment(this._segment1, this._segment1_color_table);
        this._color_table_map.add_segment(this._segment2, this._segment2_color_table);
        Assert.assertEquals((long)this.segment1_color2, (long)this._color_table_map.color_at(0, 0, 0));
        Assert.assertEquals((long)this.segment1_color1, (long)this._color_table_map.color_at(0, 1, 0));
        Assert.assertEquals((long)this.segment1_color2, (long)this._color_table_map.color_at(0, 0, 1));
        Assert.assertEquals((long)this.segment1_color1, (long)this._color_table_map.color_at(0, 1, 1));
        Assert.assertEquals((long)this.segment2_color2, (long)this._color_table_map.color_at(1, 0, 0));
        Assert.assertEquals((long)this.segment2_color1, (long)this._color_table_map.color_at(1, 1, 0));
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(1, 0, 1));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(1, 1, 1));
    }

    @Test
    public void test_color_at_with_two_segments_and_segment2_first() {
        this._color_table_map.add_segment(this._segment2, this._segment2_color_table);
        this._color_table_map.add_segment(this._segment1, this._segment1_color_table);
        Assert.assertEquals((long)this.segment2_color2, (long)this._color_table_map.color_at(0, 0, 0));
        Assert.assertEquals((long)this.segment2_color1, (long)this._color_table_map.color_at(0, 1, 0));
        Assert.assertEquals((long)this.segment2_color2, (long)this._color_table_map.color_at(1, 0, 0));
        Assert.assertEquals((long)this.segment2_color1, (long)this._color_table_map.color_at(1, 1, 0));
        Assert.assertEquals((long)this.segment1_color2, (long)this._color_table_map.color_at(0, 0, 1));
        Assert.assertEquals((long)this.segment1_color1, (long)this._color_table_map.color_at(0, 1, 1));
        Assert.assertEquals((long)this.cube_color2, (long)this._color_table_map.color_at(1, 0, 1));
        Assert.assertEquals((long)this.cube_color1, (long)this._color_table_map.color_at(1, 1, 1));
    }
}

