/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.io.File;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import loader.DICOMLoader;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import misc.messages.YObservable;
import misc.messages.YObserver;
import renderer.Tex3Cube;
import renderer.Tex3Renderer3d;
import settings.Settings;

public class ShaderTestApp
extends Applet {
    private static final String DICOM_DATA_PATH = "/home/jwahle/medic_data/ct_head_im/CTHd000";
    private Canvas3D _canvas3d;

    public static void main(String[] args) {
        new MainFrame((Applet)new ShaderTestApp(), 500, 500);
    }

    @Override
    public void init() {
        GraphicsConfiguration g_config = SimpleUniverse.getPreferredConfiguration();
        this._canvas3d = new Canvas3D(g_config);
        this.setLayout(new BorderLayout());
        this.add((Component)this._canvas3d, "Center");
        final SimpleUniverse universe = new SimpleUniverse(this._canvas3d);
        universe.getViewingPlatform().setNominalViewingTransform();
        ImageStack image_stack = MasterControl.get_is();
        image_stack.addObserver(new YObserver(){

            @Override
            public void update(YObservable sender, Message arg) {
                if (arg._type == ImageStack.M_LOADING_END) {
                    universe.addBranchGraph(ShaderTestApp.this.create_scene());
                }
            }
        }, "ShaderAppTest");
        DICOMLoader dl = new DICOMLoader(image_stack, new File(DICOM_DATA_PATH));
        image_stack.load(dl);
    }

    private BranchGroup create_scene() {
        BranchGroup root = new BranchGroup();
        TransformGroup spin = new TransformGroup();
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        this.add_mouse_rotator(spin, bounds);
        this.add_mouse_zoom(spin, bounds);
        root.addChild((Node)this.create_back_ground(bounds));
        root.addChild((Node)new DirectionalLight(new Color3f(Color.WHITE), new Vector3f(0.0f, 0.0f, -1.0f)));
        Tex3Cube tex3cube = this.create_tex3cube(spin);
        BranchGroup content = new BranchGroup();
        tex3cube.attach(content);
        spin.addChild((Node)content);
        spin.setCapability(18);
        content.addChild(this.create_text());
        root.addChild((Node)spin);
        return root;
    }

    private void add_mouse_rotator(TransformGroup spin, BoundingSphere bounds) {
        MouseRotate rotator = new MouseRotate();
        rotator.setTransformGroup(spin);
        spin.addChild((Node)rotator);
        rotator.setSchedulingBounds((Bounds)bounds);
    }

    private void add_mouse_zoom(TransformGroup spin, BoundingSphere bounds) {
        MouseWheelZoom zoom = new MouseWheelZoom();
        zoom.setTransformGroup(spin);
        spin.addChild((Node)zoom);
        zoom.setSchedulingBounds((Bounds)bounds);
    }

    private Background create_back_ground(BoundingSphere bounds) {
        Background background = new Background(0.3f, 0.3f, 0.8f);
        background.setApplicationBounds((Bounds)bounds);
        return background;
    }

    private Tex3Cube create_tex3cube(TransformGroup spin) {
        TransparencyAttributes trans_att = new TransparencyAttributes(2, 0.5f);
        trans_att.setCapability(3);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setColor(new Color3f(Color.BLUE));
        col_att.setCapability(1);
        Tex3Cube tex3cube = new Tex3Cube(trans_att, col_att, spin, this._canvas3d);
        this.initialize_tex3cube(tex3cube);
        return tex3cube;
    }

    private void initialize_tex3cube(Tex3Cube tex3cube) {
        int[] _w = new int[3];
        int[] _h = new int[3];
        ImageStack is = MasterControl.get_is();
        _w[0] = is.get_dim_x();
        _w[1] = is.get_dim_y();
        _w[2] = is.get_dim_x();
        _h[0] = is.get_dim_y();
        _h[1] = is.get_dim_z();
        _h[2] = is.get_dim_z();
        Settings.set_class_bool_option(Tex3Renderer3d.class, Tex3Renderer3d.OPT_RENDER_BG, true);
        Settings.set_class_bool_option(Tex3Renderer3d.class, Tex3Renderer3d.OPT_RENDER_SHADED, false);
        Settings.set_class_bool_option(Tex3Renderer3d.class, Tex3Renderer3d.OPT_DEBUG_VISUALIZE_NORMALS, true);
        tex3cube.set_size(2, _w, _h);
    }

    private Node create_text() {
        Appearance ap = new Appearance();
        ap.setMaterial(new Material());
        Font3D font = new Font3D(new Font("Helvetica", 0, 1), new FontExtrusion());
        Text3D text = new Text3D(font, "J");
        Shape3D shape = new Shape3D((Geometry)text, ap);
        return shape;
    }
}

