/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Image;
import main.Message;
import main.seggen.levelset.DistanceFunction;
import renderer.Renderer2d;
import settings.Settings;
import settings.SettingsOwner;

public class SnakeDistanceRenderer2d
extends Renderer2d
implements SettingsOwner {
    public static final String OPT_GLOBAL_SCALE = Settings.register_bool_opt(SnakeDistanceRenderer2d.class, "global scale", "If disabled, the theoretical minimum and maximum of the distance function is used. This usually means that the real distance values can not be seperated optically. If in doubt, set to false.", false);
    public static final String OPT_GLOBAL_SCALE_MIN = Settings.register_double_opt(SnakeDistanceRenderer2d.class, "global scale min", "Minimum for the scale function if 'global scale' is true.", -256.0);
    public static final String OPT_GLOBAL_SCALE_MAX = Settings.register_double_opt(SnakeDistanceRenderer2d.class, "global scale max", "Maximum for the scale function if 'global scale' is true.", 720.0);
    public static final String OPT_ALPHA = Settings.register_int_opt(SnakeDistanceRenderer2d.class, "alpha", "Transparency value.", 80);
    private DistanceFunction _phi;
    private static int OUT_DIST_COL = 16;
    private static int IN_DIST_COL = 8;
    private static int ZERO_DIST_COL = 0;

    public SnakeDistanceRenderer2d() {
        Settings.register_owner(this);
    }

    public SnakeDistanceRenderer2d(DistanceFunction phi) {
        this._phi = phi;
        Settings.register_owner(this);
    }

    private int calc_color(int x, int y, int z, double[] min_max_dist, double delta, int alpha) {
        int color;
        double dist = this._phi.get_dist(x, y, z);
        if (dist < min_max_dist[0]) {
            color = 255 << IN_DIST_COL;
        } else if (dist > min_max_dist[1]) {
            color = 255 << OUT_DIST_COL;
        } else if (dist > 0.0) {
            double gamma = dist / delta;
            if (gamma > 1.0) {
                gamma = 1.0;
            } else if (delta < 0.0) {
                gamma = 0.0;
            }
            color = (int)((1.0 - gamma) * 255.0) << ZERO_DIST_COL | (int)(gamma * 255.0) << OUT_DIST_COL;
        } else {
            double gamma = -dist / delta;
            if (gamma > 1.0) {
                gamma = 1.0;
            } else if (delta < 0.0) {
                gamma = 0.0;
            }
            color = (int)((1.0 - gamma) * 255.0) << ZERO_DIST_COL | (int)(gamma * 255.0) << IN_DIST_COL;
        }
        return color | alpha;
    }

    @Override
    public Image render_image(int mode, int idx) {
        block14: {
            double delta;
            int[] bb_max;
            int[] bb_min;
            double[] min_max_dist;
            int alpha;
            block17: {
                block16: {
                    block12: {
                        block15: {
                            block13: {
                                alpha = Settings.get_int_option(this, OPT_ALPHA) << 24;
                                min_max_dist = Settings.get_bool_option(this, OPT_GLOBAL_SCALE) != false ? new double[]{Settings.get_double_option(this, OPT_GLOBAL_SCALE_MIN).floatValue(), Settings.get_double_option(this, OPT_GLOBAL_SCALE_MAX).floatValue()} : this._phi.compute_min_max_dist();
                                int i = 0;
                                while (i < this._pixels[mode].length) {
                                    this._pixels[mode][i] = 0;
                                    ++i;
                                }
                                bb_min = this._phi.get_min();
                                bb_max = this._phi.get_max();
                                delta = Math.max(Math.abs(min_max_dist[0]), Math.abs(min_max_dist[1]));
                                if (!this._phi.is_3d()) break block12;
                                if (mode != 0) break block13;
                                if (idx < bb_min[2] || idx > bb_max[2]) break block14;
                                int y = bb_min[1];
                                while (y <= bb_max[1]) {
                                    int pixel_counter = y * _w[mode] + bb_min[0];
                                    int x = bb_min[0];
                                    while (x <= bb_max[0]) {
                                        this._pixels[mode][pixel_counter++] = this.calc_color(x, y, idx, min_max_dist, delta, alpha);
                                        ++x;
                                    }
                                    ++y;
                                }
                                break block14;
                            }
                            if (mode != 1) break block15;
                            if (idx < bb_min[0] || idx > bb_max[0]) break block14;
                            int z = bb_min[2];
                            while (z < bb_max[2]) {
                                int pixel_counter = z * _w[mode] + bb_min[1];
                                int y = bb_min[1];
                                while (y <= bb_max[1]) {
                                    this._pixels[mode][pixel_counter++] = this.calc_color(idx, y, z, min_max_dist, delta, alpha);
                                    ++y;
                                }
                                ++z;
                            }
                            break block14;
                        }
                        if (mode != 2 || idx < bb_min[1] || idx > bb_max[1]) break block14;
                        int z = bb_min[2];
                        while (z < bb_max[2]) {
                            int pixel_counter = z * _w[mode] + bb_min[0];
                            int x = bb_min[0];
                            while (x <= bb_max[0]) {
                                this._pixels[mode][pixel_counter++] = this.calc_color(x, idx, z, min_max_dist, delta, alpha);
                                ++x;
                            }
                            ++z;
                        }
                        break block14;
                    }
                    if (mode != 0) break block16;
                    if (idx != this._phi.get_2d_index()) break block14;
                    int y = bb_min[1];
                    while (y <= bb_max[1]) {
                        int pixel_counter = y * _w[mode] + bb_min[0];
                        int x = bb_min[0];
                        while (x <= bb_max[0]) {
                            this._pixels[mode][pixel_counter++] = this.calc_color(x, y, 0, min_max_dist, delta, alpha);
                            ++x;
                        }
                        ++y;
                    }
                    break block14;
                }
                if (mode != 1) break block17;
                if (idx < bb_min[0] || idx > bb_max[0]) break block14;
                int pixel_counter = this._phi.get_2d_index() * _w[mode] + bb_min[1];
                int y = bb_min[1];
                while (y <= bb_max[1]) {
                    this._pixels[mode][pixel_counter++] = this.calc_color(idx, y, 0, min_max_dist, delta, alpha);
                    ++y;
                }
                break block14;
            }
            if (mode == 2 && idx >= bb_min[1] && idx <= bb_max[1]) {
                int pixel_counter = this._phi.get_2d_index() * _w[mode] + bb_min[0];
                int x = bb_min[0];
                while (x <= bb_max[0]) {
                    this._pixels[mode][pixel_counter++] = this.calc_color(x, idx, 0, min_max_dist, delta, alpha);
                    ++x;
                }
            }
        }
        return this._bimg[mode];
    }

    public void new_distance_data() {
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    @Override
    public String get_name() {
        return "Snake Distance Renderer";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_GLOBAL_SCALE || opt_name == OPT_GLOBAL_SCALE_MIN || opt_name == OPT_GLOBAL_SCALE_MAX || opt_name == OPT_ALPHA) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }
}

