/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.EventQueue;
import java.awt.Image;
import java.util.ArrayList;
import main.Message;
import main.seggen.levelset.DistanceFunction;
import misc.Voxel;
import renderer.Renderer2d;
import settings.Settings;
import settings.SettingsOwner;

public class SnakeSpeedRenderer2d
extends Renderer2d
implements SettingsOwner {
    public static final String OPT_GLOBAL_SCALE = Settings.register_bool_opt(SnakeSpeedRenderer2d.class, "global scale", "If disabled, the theoretical minimum and maximum of the speed function is used. This usually means that the real speed values can not be seperated optically. If in doubt, set to false.", false);
    public static final String OPT_GLOBAL_SCALE_MIN = Settings.register_double_opt(SnakeSpeedRenderer2d.class, "global scale min", "Minimum for the scale function if 'global scale' is true.", 0.0);
    public static final String OPT_GLOBAL_SCALE_MAX = Settings.register_double_opt(SnakeSpeedRenderer2d.class, "global scale max", "Maximum for the scale function if 'global scale' is true.", 1.0);
    public static final String OPT_ALPHA = Settings.register_int_opt(SnakeSpeedRenderer2d.class, "alpha", "Transparency value.", 80);
    private final DistanceFunction _phi;
    private boolean _use_narrow_band;
    private final ArrayList<Voxel> _narrow_band;
    private boolean _rendering_in_progress;
    private boolean _update_delayed;

    public SnakeSpeedRenderer2d(DistanceFunction phi, boolean narrow_band, ArrayList<Voxel> narrowBand) {
        this._phi = phi;
        this._use_narrow_band = narrow_band;
        this._narrow_band = new ArrayList<Voxel>(narrowBand);
        Settings.register_owner(this);
        this._rendering_in_progress = false;
        this._update_delayed = false;
    }

    private int calc_color(int x, int y, int z, double[] min_max_speed, double delta, int alpha) {
        int color;
        double speed = this._phi.get_speed(x, y, z);
        if (speed < min_max_speed[0]) {
            color = 255;
        } else if (speed > min_max_speed[1]) {
            color = 0xFF0000;
        } else {
            double gamma = (speed - min_max_speed[0]) / delta;
            if (gamma > 1.0) {
                gamma = 1.0;
            } else if (delta < 0.0) {
                gamma = 0.0;
            }
            color = (int)((1.0 - gamma) * 255.0) << 16 | (int)(gamma * 255.0);
        }
        return color | alpha;
    }

    @Override
    public Image render_image(int mode, int idx) {
        if (this._rendering_in_progress) {
            return this._bimg[mode];
        }
        this._rendering_in_progress = true;
        int alpha = Settings.get_int_option(this, OPT_ALPHA) << 24;
        double[] min_max_speed = Settings.get_bool_option(this, OPT_GLOBAL_SCALE) != false ? new double[]{Settings.get_double_option(this, OPT_GLOBAL_SCALE_MIN).floatValue(), Settings.get_double_option(this, OPT_GLOBAL_SCALE_MAX).floatValue()} : (this._use_narrow_band ? this._phi.compute_min_max_speed(this._narrow_band) : this._phi.compute_min_max_speed());
        int i = 0;
        while (i < this._pixels[mode].length) {
            this._pixels[mode][i] = 0;
            ++i;
        }
        double delta = min_max_speed[1] - min_max_speed[0];
        if (this._phi.is_3d()) {
            if (this._use_narrow_band) {
                if (mode == 0) {
                    int nb = 0;
                    while (nb < this._narrow_band.size()) {
                        Voxel v = this._narrow_band.get(nb);
                        if (v._z == idx) {
                            this._pixels[mode][v._y * SnakeSpeedRenderer2d._w[mode] + v._x] = this.calc_color(v._x, v._y, idx, min_max_speed, delta, alpha);
                        }
                        ++nb;
                    }
                }
            } else if (mode == 0) {
                int y = 0;
                while (y < _h[mode]) {
                    int pixel_counter = y * _w[mode];
                    int x = 0;
                    while (x < _w[mode]) {
                        this._pixels[mode][pixel_counter++] = this.calc_color(x, y, idx, min_max_speed, delta, alpha);
                        ++x;
                    }
                    ++y;
                }
            }
        } else if (this._use_narrow_band) {
            if (mode == 0) {
                int nb = 0;
                while (nb < this._narrow_band.size()) {
                    Voxel v = this._narrow_band.get(nb);
                    if (idx == this._phi.get_2d_index()) {
                        this._pixels[mode][v._y * SnakeSpeedRenderer2d._w[mode] + v._x] = this.calc_color(v._x, v._y, 0, min_max_speed, delta, alpha);
                    }
                    ++nb;
                }
            }
        } else if (mode == 0 && idx == this._phi.get_2d_index()) {
            int y = 0;
            while (y < _h[mode]) {
                int pixel_counter = y * _w[mode];
                int x = 0;
                while (x < _w[mode]) {
                    this._pixels[mode][pixel_counter++] = this.calc_color(x, y, 0, min_max_speed, delta, alpha);
                    ++x;
                }
                ++y;
            }
        }
        this._rendering_in_progress = false;
        return this._bimg[mode];
    }

    public void new_speed_data(final ArrayList<Voxel> narrow_band, final boolean use_narrow_band) {
        if (this._rendering_in_progress && !this._update_delayed) {
            this._update_delayed = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SnakeSpeedRenderer2d.this.new_speed_data(narrow_band, use_narrow_band);
                }
            });
            return;
        }
        this._update_delayed = false;
        this._narrow_band.clear();
        this._narrow_band.addAll(narrow_band);
        this._use_narrow_band = use_narrow_band;
        this.setChanged();
        this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
    }

    @Override
    public String get_name() {
        return "Snake Speed Renderer";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_GLOBAL_SCALE || opt_name == OPT_GLOBAL_SCALE_MIN || opt_name == OPT_GLOBAL_SCALE_MAX || opt_name == OPT_ALPHA) {
            this.setChanged();
            this.notifyObservers(new Message(Renderer2d.M_REQUEST_REDRAW, null));
        }
    }
}

