/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import main.MasterControl;
import misc.grid.RegularGrid3i;
import renderer.Tex2Renderer3d;
import settings.Settings;

public final class Tex2Cube {
    public Shape3D[][] _bg_shps;
    public BufferedImage[][] _bg_imgs;
    public Texture2D[][] _bg_texs;
    public TransparencyAttributes _bg_trans_att;
    public ColoringAttributes _bg_col_att;
    public BranchGroup _plane_group;
    public boolean _show_border;
    public boolean _init_in_progress;

    public Tex2Cube(TransparencyAttributes trans_att, ColoringAttributes bg_col_att) {
        this._bg_trans_att = trans_att;
        this._bg_col_att = bg_col_att;
        this._init_in_progress = false;
    }

    public final void attach(BranchGroup bg) {
        bg.addChild((Node)this._plane_group);
    }

    public final void detach(BranchGroup bg) {
        if (this._plane_group != null) {
            bg.removeChild((Node)this._plane_group);
        }
        this._bg_shps = null;
        this._bg_imgs = null;
        this._bg_texs = null;
        this._plane_group = null;
    }

    public final void set_size(int tex_steps, int[] tex_w, int[] tex_h) {
        Appearance border_ap;
        this._init_in_progress = true;
        this._bg_shps = new Shape3D[3][];
        this._bg_imgs = new BufferedImage[3][];
        this._bg_texs = new Texture2D[3][];
        RegularGrid3i vc = MasterControl.get_is().get_voxel_cube();
        int xmax = vc.get_dim_x();
        int ymax = vc.get_dim_y();
        int zmax = vc.get_dim_z();
        int[] dim = new int[]{zmax / tex_steps, xmax / tex_steps, ymax / tex_steps};
        int i = 0;
        while (i < 3) {
            this._bg_shps[i] = new Shape3D[dim[i]];
            this._bg_imgs[i] = new BufferedImage[dim[i]];
            this._bg_texs[i] = new Texture2D[dim[i]];
            ++i;
        }
        PolygonAttributes pol_att = new PolygonAttributes();
        pol_att.setPolygonMode(2);
        pol_att.setCullFace(0);
        TextureAttributes tex_att = new TextureAttributes();
        tex_att.setTextureMode(2);
        this._plane_group = new BranchGroup();
        this._plane_group.setCapability(17);
        if (this._show_border) {
            border_ap = new Appearance();
            PolygonAttributes boder_poly_att = new PolygonAttributes();
            boder_poly_att.setPolygonMode(1);
            boder_poly_att.setCullFace(0);
            border_ap.setPolygonAttributes(boder_poly_att);
        } else {
            border_ap = null;
        }
        int m = 0;
        while (m < 3) {
            int i2 = 0;
            while (i2 < this._bg_shps[m].length) {
                Point3f d;
                Point3f c;
                Point3f b;
                Point3f a;
                this._bg_imgs[m][i2] = new BufferedImage(tex_w[m], tex_h[m], 2);
                ImageComponent2D i2d = new ImageComponent2D(2, this._bg_imgs[m][i2], true, true);
                i2d.setCapability(2);
                i2d.setCapability(3);
                this._bg_texs[m][i2] = new Texture2D(1, 6, tex_w[m], tex_h[m]);
                this._bg_texs[m][i2].setBoundaryColor(0.0f, 0.0f, 0.0f, 0.0f);
                this._bg_texs[m][i2].setCapability(7);
                this._bg_texs[m][i2].setImage(0, (ImageComponent)i2d);
                Appearance ap = new Appearance();
                ap.setTexture((Texture)this._bg_texs[m][i2]);
                ap.setTextureAttributes(tex_att);
                ap.setPolygonAttributes(pol_att);
                ap.setTransparencyAttributes(this._bg_trans_att);
                ap.setColoringAttributes(this._bg_col_att);
                if (m == 0) {
                    a = new Point3f(0.0f, 0.0f, (float)(i2 * tex_steps));
                    b = new Point3f(0.0f, (float)ymax, (float)(i2 * tex_steps));
                    c = new Point3f((float)xmax, (float)ymax, (float)(i2 * tex_steps));
                    d = new Point3f((float)xmax, 0.0f, (float)(i2 * tex_steps));
                } else if (m == 1) {
                    a = new Point3f((float)(i2 * tex_steps), 0.0f, 0.0f);
                    b = new Point3f((float)(i2 * tex_steps), 0.0f, (float)zmax);
                    c = new Point3f((float)(i2 * tex_steps), (float)ymax, (float)zmax);
                    d = new Point3f((float)(i2 * tex_steps), (float)ymax, 0.0f);
                } else {
                    a = new Point3f(0.0f, (float)(i2 * tex_steps), 0.0f);
                    b = new Point3f(0.0f, (float)(i2 * tex_steps), (float)zmax);
                    c = new Point3f((float)xmax, (float)(i2 * tex_steps), (float)zmax);
                    d = new Point3f((float)xmax, (float)(i2 * tex_steps), 0.0f);
                }
                QuadArray qa_plane = new QuadArray(4, 33);
                qa_plane.setCoordinate(0, a);
                qa_plane.setCoordinate(1, b);
                qa_plane.setCoordinate(2, c);
                qa_plane.setCoordinate(3, d);
                qa_plane.setTextureCoordinate(0, 0, new TexCoord2f(0.0f, 0.0f));
                qa_plane.setTextureCoordinate(0, 1, new TexCoord2f(0.0f, 1.0f));
                qa_plane.setTextureCoordinate(0, 2, new TexCoord2f(1.0f, 1.0f));
                qa_plane.setTextureCoordinate(0, 3, new TexCoord2f(1.0f, 0.0f));
                this._bg_shps[m][i2] = new Shape3D((Geometry)qa_plane, ap);
                if (this._show_border && (m == 0 && Settings.get_bool_option(Tex2Renderer3d.class, Tex2Renderer3d.OPT_DEBUG_SHOW_T) != false || m == 1 && Settings.get_bool_option(Tex2Renderer3d.class, Tex2Renderer3d.OPT_DEBUG_SHOW_S) != false || m == 2 && Settings.get_bool_option(Tex2Renderer3d.class, Tex2Renderer3d.OPT_DEBUG_SHOW_F).booleanValue())) {
                    Shape3D border_shp = new Shape3D((Geometry)qa_plane, border_ap);
                    this._plane_group.addChild((Node)border_shp);
                }
                this._plane_group.addChild((Node)this._bg_shps[m][i2]);
                ++i2;
            }
            ++m;
        }
        this._init_in_progress = false;
    }
}

