/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.YaDiV;
import main.view2d.Viewport2dModel;
import main.view3d.Viewport3d;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import renderer.Tex2Cube;
import renderer.TexRenderer3d;
import settings.Settings;
import settings.SettingsOwner;
import threads.RenderThread;

public final class Tex2Renderer3d
extends TexRenderer3d
implements SettingsOwner {
    public static final String OPT_TEX_DIM = Settings.register_int_opt(Tex2Renderer3d.class, "texture dimension", "Texture image dimension. This value is only used if the GFX Hardware does not support textures of non-power of two.", 256);
    public static final String OPT_ALWAYS_USE_TEX_DIM = Settings.register_bool_opt(Tex2Renderer3d.class, "texture dimension always", "Uses the texture dimension even if non-power of two is supported (e.g. to reduce memory usage)", false);
    public static final String OPT_TEX_STEPS = Settings.register_int_opt(Tex2Renderer3d.class, "texture steps", "The maximum number of necessary texture planes in transversal, sagittal and frontal view is divided by this value.", 4);
    public static final String OPT_RENDER_PLANE = Settings.register_bool_opt(Tex2Renderer3d.class, "render plane", "True if the currently active slice from the viewport 2d shall be shown.", false);
    public static final String OPT_RENDER_ORTHO = Settings.register_bool_opt(Tex2Renderer3d.class, "render ortho", "Enables or disables the ortho slice rendering.", false);
    public static final String OPT_RENDER_BG = Settings.register_bool_opt(Tex2Renderer3d.class, "render background", "Render DICOM data as 2D Texture.", false);
    public static final String OPT_BG_COLOR = Settings.register_color_opt(Tex2Renderer3d.class, "bg color", "The color for background rendering if the child image renderer is not set to pseudo color.", new Color(255, 255, 255));
    public static final String OPT_BG_TRANS = Settings.register_double_opt(Tex2Renderer3d.class, "bg transparency", "The transparency of the planes used for the background rendering.", 0.5);
    public static final String OPT_PLANE_TRANS = Settings.register_double_opt(Tex2Renderer3d.class, "plane transparency", "The transparency of the plane that shows the currently active slice from the viewport 2d.", 0.2);
    public static final String OPT_PLANE_T_COLOR = Settings.register_color_opt(Tex2Renderer3d.class, "plane S color", "Color for the transversal plane when ortho slice mode is enabled.", new Color(200, 255, 200));
    public static final String OPT_PLANE_S_COLOR = Settings.register_color_opt(Tex2Renderer3d.class, "plane T color", "Color for the sagittal plane when ortho slice mode is enabled.", new Color(255, 200, 200));
    public static final String OPT_PLANE_F_COLOR = Settings.register_color_opt(Tex2Renderer3d.class, "plane F color", "Color for the frontal plane when ortho slice mode is enabled.", new Color(200, 200, 255));
    public static final String OPT_DEBUG_SHOW_BORDERS = Settings.register_bool_opt(Tex2Renderer3d.class, "debug: show borders", "Shows plane borders.", false);
    public static final String OPT_DEBUG_SHOW_T = Settings.register_bool_opt(Tex2Renderer3d.class, "debug: show transversal planes", "Shows transversal planes.", true);
    public static final String OPT_DEBUG_SHOW_S = Settings.register_bool_opt(Tex2Renderer3d.class, "debug: show sagittal planes", "Shows sagittal planes.", true);
    public static final String OPT_DEBUG_SHOW_F = Settings.register_bool_opt(Tex2Renderer3d.class, "debug: show frontal planes", "Shows frontal planes.", true);
    private final Tex2Cube _tex2_cube;
    private final Shape3D[][] _ortho_shps;
    private final Shape3D[] _ortho_border_shps;
    private final BufferedImage[] _ortho_imgs;
    private final Texture2D[] _ortho_texs;
    private final QuadArray[][] _ortho_quads;
    private final QuadArray[] _border_quads;
    private final ColoringAttributes[] _ortho_col_att;
    private final RenderingAttributes[] _ortho_ra;
    private final TransparencyAttributes _orthot_rans_att;
    private Tex2RenderThread _render_thread;

    public Tex2Renderer3d(Viewport3d v3d, int scene_id) {
        super(v3d, scene_id);
        Settings.register_owner(this);
        this._render_thread = null;
        this._ortho_shps = new Shape3D[3][4];
        this._ortho_imgs = new BufferedImage[3];
        this._ortho_texs = new Texture2D[3];
        this._ortho_ra = new RenderingAttributes[3];
        this._ortho_quads = new QuadArray[3][4];
        this._ortho_border_shps = new Shape3D[3];
        this._border_quads = new QuadArray[3];
        this._ortho_col_att = new ColoringAttributes[3];
        PolygonAttributes pol_att = new PolygonAttributes();
        pol_att.setPolygonMode(2);
        pol_att.setCullFace(0);
        TextureAttributes tex_att = new TextureAttributes();
        tex_att.setTextureMode(3);
        float trans = Settings.get_double_option(this, OPT_PLANE_TRANS).floatValue();
        this._orthot_rans_att = new TransparencyAttributes(2, trans);
        this._orthot_rans_att.setCapability(3);
        PolygonAttributes pol_border_att = new PolygonAttributes();
        pol_border_att.setPolygonMode(1);
        pol_border_att.setCullFace(0);
        int i = 0;
        while (i < 3) {
            this._ortho_imgs[i] = new BufferedImage(16, 16, 2);
            ImageComponent2D i2d = new ImageComponent2D(2, this._ortho_imgs[i], true, true);
            i2d.set(this._ortho_imgs[i]);
            i2d.setCapability(2);
            i2d.setCapability(3);
            this._ortho_texs[i] = new Texture2D(1, 6, 16, 16);
            this._ortho_texs[i].setBoundaryColor(0.0f, 0.0f, 0.0f, 0.0f);
            this._ortho_texs[i].setCapability(7);
            this._ortho_texs[i].setImage(0, (ImageComponent)i2d);
            this._ortho_ra[i] = new RenderingAttributes();
            this._ortho_ra[i].setCapability(5);
            this._ortho_ra[i].setCapability(6);
            this._ortho_ra[i].setVisible(false);
            this._ortho_col_att[i] = new ColoringAttributes();
            Color col = i == 0 ? Settings.get_color_option(this, OPT_PLANE_S_COLOR) : (i == 1 ? Settings.get_color_option(this, OPT_PLANE_T_COLOR) : Settings.get_color_option(this, OPT_PLANE_F_COLOR));
            this._ortho_col_att[i].setColor(new Color3f(col));
            this._ortho_col_att[i].setCapability(1);
            int j = 0;
            while (j < 4) {
                Appearance ortho_ap = new Appearance();
                ortho_ap.setCapability(3);
                ortho_ap.setTexture((Texture)this._ortho_texs[i]);
                ortho_ap.setTextureAttributes(tex_att);
                ortho_ap.setPolygonAttributes(pol_att);
                ortho_ap.setTransparencyAttributes(this._orthot_rans_att);
                ortho_ap.setRenderingAttributes(this._ortho_ra[i]);
                ortho_ap.setColoringAttributes(this._ortho_col_att[i]);
                this._ortho_quads[i][j] = new QuadArray(4, 33);
                this._ortho_quads[i][j].setCapability(1);
                this._ortho_quads[i][j].setCapability(7);
                this._ortho_quads[i][j].setTextureCoordinate(0, 0, new TexCoord2f(0.0f, 0.0f));
                this._ortho_quads[i][j].setTextureCoordinate(0, 1, new TexCoord2f(0.0f, 1.0f));
                this._ortho_quads[i][j].setTextureCoordinate(0, 2, new TexCoord2f(1.0f, 1.0f));
                this._ortho_quads[i][j].setTextureCoordinate(0, 3, new TexCoord2f(1.0f, 0.0f));
                this._ortho_shps[i][j] = new Shape3D((Geometry)this._ortho_quads[i][j], ortho_ap);
                this._bg.addChild((Node)this._ortho_shps[i][j]);
                ++j;
            }
            Appearance border_ap = new Appearance();
            border_ap.setRenderingAttributes(this._ortho_ra[i]);
            border_ap.setPolygonAttributes(pol_border_att);
            ColoringAttributes col_border_att = new ColoringAttributes();
            col_border_att.setCapability(1);
            border_ap.setColoringAttributes(col_border_att);
            this._border_quads[i] = new QuadArray(4, 33);
            this._border_quads[i].setCapability(1);
            this._border_quads[i].setCapability(7);
            this._ortho_border_shps[i] = new Shape3D((Geometry)this._border_quads[i], border_ap);
            this._bg.addChild((Node)this._ortho_border_shps[i]);
            ++i;
        }
        this.update_border_color();
        trans = Settings.get_double_option(this, OPT_BG_TRANS).floatValue();
        TransparencyAttributes bg_trans_att = new TransparencyAttributes(2, trans);
        bg_trans_att.setCapability(3);
        ColoringAttributes bg_col_att = new ColoringAttributes();
        bg_col_att.setColor(new Color3f(Settings.get_color_option(this, OPT_BG_COLOR)));
        bg_col_att.setCapability(1);
        this._tex2_cube = new Tex2Cube(bg_trans_att, bg_col_att);
        this._imr2d.addObserver(this, "Tex2Renderer3d()");
        Settings.register_class_listener(Viewport3d.class, this);
    }

    public final void enable_bg() {
        int tex_steps = Settings.get_int_option(this, OPT_TEX_STEPS);
        this._tex2_cube._show_border = Settings.get_bool_option(this, OPT_DEBUG_SHOW_BORDERS);
        this._tex2_cube.set_size(tex_steps, this._w, this._h);
        this._tex2_cube.attach(this._bg);
        this.create_scene();
    }

    public final void disable_bg() {
        if (this._render_thread != null && this._render_thread.getState() != Thread.State.TERMINATED) {
            this._render_thread.stop_soon();
        }
        this._tex2_cube.detach(this._bg);
    }

    public final void show_planes() {
        int[] pos = new int[3];
        Viewport2dModel v2d_model = MasterControl.get_v2d().get_model();
        pos[0] = v2d_model.get_active_image(1);
        pos[1] = v2d_model.get_active_image(2);
        pos[2] = v2d_model.get_active_image(0);
        if (!Settings.get_bool_option(this, OPT_RENDER_ORTHO).booleanValue()) {
            int mode = v2d_model.get_view_mode();
            int i = 0;
            while (i < 3) {
                this._ortho_ra[i].setVisible(mode == i);
                this._ortho_border_shps[i].getAppearance().getRenderingAttributes().setVisible(mode == i);
                ++i;
            }
        }
        RegularGrid3i vc = MasterControl.get_is().get_voxel_cube();
        int xmax = vc.get_dim_x();
        int ymax = vc.get_dim_y();
        int zmax = vc.get_dim_z();
        int i = 0;
        while (i < 3) {
            float fab;
            float fbc;
            Point3f d;
            Point3f c;
            Point3f b;
            Point3f a;
            if (i == 0) {
                a = new Point3f(0.0f, 0.0f, (float)pos[2]);
                b = new Point3f(0.0f, (float)ymax, (float)pos[2]);
                c = new Point3f((float)xmax, (float)ymax, (float)pos[2]);
                d = new Point3f((float)xmax, 0.0f, (float)pos[2]);
                fbc = (float)pos[0] / (float)xmax;
                fab = (float)pos[1] / (float)ymax;
            } else if (i == 1) {
                a = new Point3f((float)pos[0], 0.0f, 0.0f);
                b = new Point3f((float)pos[0], 0.0f, (float)zmax);
                c = new Point3f((float)pos[0], (float)ymax, (float)zmax);
                d = new Point3f((float)pos[0], (float)ymax, 0.0f);
                fab = (float)pos[2] / (float)zmax;
                fbc = (float)pos[1] / (float)ymax;
            } else {
                a = new Point3f(0.0f, (float)pos[1], 0.0f);
                b = new Point3f(0.0f, (float)pos[1], (float)zmax);
                c = new Point3f((float)xmax, (float)pos[1], (float)zmax);
                d = new Point3f((float)xmax, (float)pos[1], 0.0f);
                fab = (float)pos[2] / (float)zmax;
                fbc = (float)pos[0] / (float)xmax;
            }
            Vector3f vab = new Vector3f((Tuple3f)a);
            vab.interpolate((Tuple3f)b, fab);
            Vector3f vbc = new Vector3f((Tuple3f)b);
            vbc.interpolate((Tuple3f)c, fbc);
            Vector3f vcd = new Vector3f((Tuple3f)d);
            vcd.interpolate((Tuple3f)c, fab);
            Vector3f vda = new Vector3f((Tuple3f)a);
            vda.interpolate((Tuple3f)d, fbc);
            Vector3f vm = new Vector3f(vab);
            vm.interpolate((Tuple3f)vcd, fbc);
            Point3f ab = new Point3f((Tuple3f)vab);
            Point3f bc = new Point3f((Tuple3f)vbc);
            Point3f cd = new Point3f((Tuple3f)vcd);
            Point3f da = new Point3f((Tuple3f)vda);
            Point3f m = new Point3f((Tuple3f)vm);
            this._ortho_quads[i][0].setCoordinate(0, a);
            this._ortho_quads[i][0].setCoordinate(1, ab);
            this._ortho_quads[i][0].setCoordinate(2, m);
            this._ortho_quads[i][0].setCoordinate(3, da);
            this._ortho_quads[i][0].setTextureCoordinate(0, 0, new TexCoord2f(0.0f, 0.0f));
            this._ortho_quads[i][0].setTextureCoordinate(0, 1, new TexCoord2f(0.0f, fab));
            this._ortho_quads[i][0].setTextureCoordinate(0, 2, new TexCoord2f(fbc, fab));
            this._ortho_quads[i][0].setTextureCoordinate(0, 3, new TexCoord2f(fbc, 0.0f));
            this._ortho_quads[i][1].setCoordinate(0, ab);
            this._ortho_quads[i][1].setCoordinate(1, b);
            this._ortho_quads[i][1].setCoordinate(2, bc);
            this._ortho_quads[i][1].setCoordinate(3, m);
            this._ortho_quads[i][1].setTextureCoordinate(0, 0, new TexCoord2f(0.0f, fab));
            this._ortho_quads[i][1].setTextureCoordinate(0, 1, new TexCoord2f(0.0f, 1.0f));
            this._ortho_quads[i][1].setTextureCoordinate(0, 2, new TexCoord2f(fbc, 1.0f));
            this._ortho_quads[i][1].setTextureCoordinate(0, 3, new TexCoord2f(fbc, fab));
            this._ortho_quads[i][2].setCoordinate(0, da);
            this._ortho_quads[i][2].setCoordinate(1, m);
            this._ortho_quads[i][2].setCoordinate(2, cd);
            this._ortho_quads[i][2].setCoordinate(3, d);
            this._ortho_quads[i][2].setTextureCoordinate(0, 0, new TexCoord2f(fbc, 0.0f));
            this._ortho_quads[i][2].setTextureCoordinate(0, 1, new TexCoord2f(fbc, fab));
            this._ortho_quads[i][2].setTextureCoordinate(0, 2, new TexCoord2f(1.0f, fab));
            this._ortho_quads[i][2].setTextureCoordinate(0, 3, new TexCoord2f(1.0f, 0.0f));
            this._ortho_quads[i][3].setCoordinate(0, m);
            this._ortho_quads[i][3].setCoordinate(1, bc);
            this._ortho_quads[i][3].setCoordinate(2, c);
            this._ortho_quads[i][3].setCoordinate(3, cd);
            this._ortho_quads[i][3].setTextureCoordinate(0, 0, new TexCoord2f(fbc, fab));
            this._ortho_quads[i][3].setTextureCoordinate(0, 1, new TexCoord2f(fbc, 1.0f));
            this._ortho_quads[i][3].setTextureCoordinate(0, 2, new TexCoord2f(1.0f, 1.0f));
            this._ortho_quads[i][3].setTextureCoordinate(0, 3, new TexCoord2f(1.0f, fab));
            if (!this._resizing) {
                if (_textureNonPowerOfTwoAvailable && !Settings.get_bool_option(this, OPT_ALWAYS_USE_TEX_DIM).booleanValue()) {
                    this._imr2d.render_alpha_bg_image(this._ortho_imgs[i], i, v2d_model.get_active_image(i), null, null);
                } else {
                    this._imr2d.render_scaled_alpha_bg_image(this._ortho_imgs[i], i, v2d_model.get_active_image(i), null, null);
                }
            }
            ImageComponent2D i2d = (ImageComponent2D)this._ortho_texs[i].getImage(0);
            i2d.set(this._ortho_imgs[i]);
            this._border_quads[i].setCoordinate(0, a);
            this._border_quads[i].setCoordinate(1, b);
            this._border_quads[i].setCoordinate(2, c);
            this._border_quads[i].setCoordinate(3, d);
            ++i;
        }
    }

    public final void resize() {
        this._resizing = false;
        if (Settings.get_bool_option(this, OPT_RENDER_BG).booleanValue()) {
            this.disable_bg();
            this.enable_bg();
        }
        if (Settings.get_bool_option(this, OPT_RENDER_PLANE).booleanValue()) {
            this.show_planes();
        }
        if (Settings.get_bool_option(this, OPT_RENDER_ORTHO).booleanValue()) {
            int i = 0;
            while (i < 3) {
                this._ortho_ra[i].setVisible(true);
                this._ortho_border_shps[i].getAppearance().getRenderingAttributes().setVisible(true);
                this.show_planes();
                ++i;
            }
        }
    }

    @Override
    public final void create_scene() {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 2 && !this._resizing && (Settings.get_bool_option(this, OPT_RENDER_PLANE).booleanValue() || Settings.get_bool_option(this, OPT_RENDER_ORTHO).booleanValue() || Settings.get_bool_option(this, OPT_RENDER_BG).booleanValue())) {
            if (this._render_thread == null || this._render_thread.getState() == Thread.State.TERMINATED) {
                this._render_thread = new Tex2RenderThread(this);
                this._render_thread.start();
            } else {
                this._render_thread.restart();
            }
        }
    }

    private final void update_border_color() {
        double mean_rgb;
        int min_rgb;
        Color bg_col = Settings.get_color_option(Viewport3d.class, Viewport3d.OPT_BG_COLOR);
        int r = bg_col.getRed();
        int g = bg_col.getGreen();
        int b = bg_col.getBlue();
        int max_rgb = Math.max(Math.max(r, g), b);
        Color border_col = max_rgb - (min_rgb = Math.min(Math.min(r, g), b)) < 20 && max_rgb > 100 && max_rgb < 156 && min_rgb > 100 && min_rgb < 156 ? ((mean_rgb = (double)(r + b + g / 3)) > 127.0 ? new Color(0, 0, 0) : new Color(255, 255, 255)) : new Color(bg_col.getRGB() ^ 0xFFFFFF);
        int i = 0;
        while (i < 3) {
            this._ortho_border_shps[i].getAppearance().getColoringAttributes().setColor(new Color3f(border_col));
            ++i;
        }
    }

    private final void allocate_plane_textures() {
        this.calc_dimensions(Settings.get_int_option(this, OPT_TEX_DIM), Settings.get_bool_option(this, OPT_ALWAYS_USE_TEX_DIM));
        int m = 0;
        while (m < 3) {
            if (this._ortho_imgs[m].getWidth() == this._w[m] || this._ortho_imgs[m].getHeight() != this._h[m]) {
                this._ortho_imgs[m] = new BufferedImage(this._w[m], this._h[m], 2);
                ImageComponent2D i2d = new ImageComponent2D(2, this._ortho_imgs[m], true, true);
                i2d.set(this._ortho_imgs[m]);
                i2d.setCapability(2);
                i2d.setCapability(3);
                this._ortho_texs[m] = new Texture2D(1, 6, this._w[m], this._h[m]);
                this._ortho_texs[m].setBoundaryColor(0.0f, 0.0f, 0.0f, 0.0f);
                this._ortho_texs[m].setCapability(7);
                this._ortho_texs[m].setImage(0, (ImageComponent)i2d);
                int j = 0;
                while (j < 4) {
                    this._ortho_shps[m][j].getAppearance().setTexture((Texture)this._ortho_texs[m]);
                    ++j;
                }
            }
            ++m;
        }
    }

    @Override
    public final void update(YObservable yo, Message m) {
        if (m._type == ImageStack.M_RESIZE_START) {
            this._resizing = true;
            if (this._render_thread != null && this._render_thread.getState() != Thread.State.TERMINATED) {
                this._render_thread.stop_soon();
            }
        } else if (m._type == ImageStack.M_CLEAR) {
            Settings.set_class_bool_option(Tex2Renderer3d.class, OPT_RENDER_BG, false);
        } else if (m._type == ImageStack.M_VC_SET) {
            this.allocate_plane_textures();
        }
        super.update(yo, m);
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        boolean render_plane = Settings.get_bool_option(this, OPT_RENDER_PLANE);
        boolean render_ortho = Settings.get_bool_option(this, OPT_RENDER_ORTHO);
        boolean render_bg = Settings.get_bool_option(this, OPT_RENDER_BG);
        int mode = MasterControl.get_v2d().get_model().get_view_mode();
        if (opt_name == OPT_ALWAYS_USE_TEX_DIM) {
            if (this._visible) {
                this.disable_bg();
                this.allocate_plane_textures();
                this.enable_bg();
            } else {
                this.allocate_plane_textures();
            }
        } else if (opt_name == OPT_DEBUG_SHOW_T || opt_name == OPT_DEBUG_SHOW_S || opt_name == OPT_DEBUG_SHOW_F) {
            this.disable_bg();
            this.enable_bg();
        } else if (opt_name == Viewport3d.OPT_BG_COLOR) {
            this.update_border_color();
        } else if (opt_name == OPT_BG_COLOR) {
            Color col = Settings.get_color_option(this, OPT_BG_COLOR);
            this._tex2_cube._bg_col_att.setColor(new Color3f(col));
        } else if (opt_name == OPT_BG_TRANS) {
            Double trans = Settings.get_double_option(this, OPT_BG_TRANS);
            this._tex2_cube._bg_trans_att.setTransparency(trans.floatValue());
        } else if (opt_name == OPT_RENDER_PLANE) {
            if (render_plane) {
                this.show_planes();
            } else if (!render_ortho) {
                this._ortho_ra[mode].setVisible(true);
                this._ortho_border_shps[mode].getAppearance().getRenderingAttributes().setVisible(false);
            }
        } else if (opt_name == OPT_RENDER_ORTHO) {
            if (render_ortho) {
                int i = 0;
                while (i < 3) {
                    this._ortho_ra[i].setVisible(true);
                    this._ortho_border_shps[i].getAppearance().getRenderingAttributes().setVisible(true);
                    this.show_planes();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < 3) {
                    if (!render_plane || render_plane && mode != i) {
                        this._ortho_ra[i].setVisible(false);
                        this._ortho_border_shps[i].getAppearance().getRenderingAttributes().setVisible(false);
                    }
                    ++i;
                }
            }
        } else if (opt_name == OPT_RENDER_BG) {
            if (render_bg) {
                this.enable_bg();
            } else {
                this.disable_bg();
            }
        } else if (opt_name == OPT_TEX_STEPS) {
            if (render_bg) {
                this.disable_bg();
                this.enable_bg();
            }
        } else if (opt_name == OPT_TEX_DIM && (Settings.get_bool_option(this, OPT_ALWAYS_USE_TEX_DIM).booleanValue() || !_textureNonPowerOfTwoAvailable)) {
            if (render_bg) {
                this.disable_bg();
                this.allocate_plane_textures();
                this.enable_bg();
            } else {
                this.allocate_plane_textures();
            }
        } else if (opt_name == OPT_PLANE_S_COLOR) {
            Color col = Settings.get_color_option(this, OPT_PLANE_S_COLOR);
            this._ortho_col_att[0].setColor(new Color3f(col));
        } else if (opt_name.equals(OPT_PLANE_T_COLOR)) {
            Color col = Settings.get_color_option(this, OPT_PLANE_T_COLOR);
            this._ortho_col_att[1].setColor(new Color3f(col));
        } else if (opt_name.equals(OPT_PLANE_F_COLOR)) {
            Color col = Settings.get_color_option(this, OPT_PLANE_F_COLOR);
            this._ortho_col_att[2].setColor(new Color3f(col));
        } else if (opt_name == OPT_PLANE_TRANS) {
            Double trans = Settings.get_double_option(this, OPT_PLANE_TRANS);
            this._orthot_rans_att.setTransparency(trans.floatValue());
        } else if (opt_name == OPT_DEBUG_SHOW_BORDERS && render_bg) {
            this.disable_bg();
            this.enable_bg();
        }
    }

    @Override
    public final String get_name() {
        return this.toString();
    }

    private final class Tex2RenderThread
    extends RenderThread {
        public Tex2RenderThread(SettingsOwner parent) {
            super(parent, false);
            this._label = "Tex2RenderThread";
        }

        @Override
        public void my_run() {
            do {
                this._restart = false;
                if (Settings.get_bool_option(this._parent, OPT_RENDER_PLANE).booleanValue()) {
                    Tex2Renderer3d.this.show_planes();
                }
                if (this._restart) continue;
                if (this._stop_soon) {
                    return;
                }
                if (Settings.get_bool_option(this._parent, OPT_RENDER_ORTHO).booleanValue()) {
                    int i = 0;
                    while (i < 3) {
                        Tex2Renderer3d.this._ortho_ra[i].setVisible(true);
                        Tex2Renderer3d.this._ortho_border_shps[i].getAppearance().getRenderingAttributes().setVisible(true);
                        Tex2Renderer3d.this.show_planes();
                        ++i;
                    }
                }
                if (this._restart) continue;
                if (this._stop_soon) {
                    return;
                }
                if (!Settings.get_bool_option(this._parent, OPT_RENDER_BG).booleanValue()) continue;
                int tex_steps = Settings.get_int_option(this._parent, OPT_TEX_STEPS);
                if (Settings.get_bool_option(this._parent, OPT_DEBUG_SHOW_T).booleanValue()) {
                    this.update_images(0, tex_steps);
                }
                if (Settings.get_bool_option(this._parent, OPT_DEBUG_SHOW_S).booleanValue()) {
                    this.update_images(1, tex_steps);
                }
                if (!Settings.get_bool_option(this._parent, OPT_DEBUG_SHOW_F).booleanValue()) continue;
                this.update_images(2, tex_steps);
            } while (this._restart && !this._stop_soon);
        }

        private void update_images(int m, int tex_steps) {
            if (MasterControl.get_is().get_state() == 2 && !Tex2Renderer3d.this._resizing) {
                while (((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._init_in_progress) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "update_images::Unhandled Exception: " + ex);
                    }
                }
                int i = 0;
                while (i < ((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._bg_imgs[m].length && !this._restart && !this._stop_soon) {
                    if (_textureNonPowerOfTwoAvailable && !Settings.get_bool_option(this._parent, OPT_ALWAYS_USE_TEX_DIM).booleanValue()) {
                        if (Tex2Renderer3d.this._imr2d._use_tf_hack) {
                            Tex2Renderer3d.this._imr2d.render_alpha_bg_image_from_tf_set(((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._bg_imgs[m][i], m, i * tex_steps);
                        } else {
                            Tex2Renderer3d.this._imr2d.render_alpha_bg_image(((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._bg_imgs[m][i], m, i * tex_steps, Tex2Renderer3d.this._seg_render_list, null);
                        }
                    } else if (Tex2Renderer3d.this._imr2d._use_tf_hack) {
                        Tex2Renderer3d.this._imr2d.render_scaled_alpha_bg_image_from_tf_set(((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._bg_imgs[m][i], m, i * tex_steps);
                    } else {
                        Tex2Renderer3d.this._imr2d.render_scaled_alpha_bg_image(((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._bg_imgs[m][i], m, i * tex_steps, Tex2Renderer3d.this._seg_render_list, null);
                    }
                    ImageComponent2D i2d = (ImageComponent2D)((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._bg_texs[m][i].getImage(0);
                    i2d.set(((Tex2Renderer3d)Tex2Renderer3d.this)._tex2_cube._bg_imgs[m][i]);
                    ++i;
                }
            }
        }
    }
}

