/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderAttributeValue;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.ImageStack;
import main.MasterControl;
import main.YaDiV;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunction;
import misc.grid.gradients.GradientFunctionFactory;
import misc.grid.gradients.GradientFunctionType;
import renderer.FragmentShader;
import renderer.Tex3Renderer3d;
import settings.Settings;

public final class Tex3Cube {
    public BufferedImage[] _bg_imgs;
    public Texture3D _bg_tex;
    public ImageComponent3D _ic3d;
    public BufferedImage[] _normal_imgs = null;
    public Texture3D _normal_tex;
    public ColoringAttributes _bg_col_att;
    public TransparencyAttributes _bg_trans_att;
    public boolean _show_debug_border;
    private Shape3D[] _bg_shps;
    public BranchGroup _plane_group;
    private final TransformGroup _root_spin;
    public Matrix3f _transform_matrix = new Matrix3f();
    public ShaderAttributeValue _matrix_attrib;
    private final Canvas3D _canvas3d;
    private final Transform3D _tf3f_tc_trans = new Transform3D();
    private final Transform3D _tf3d_spin = new Transform3D();
    private Transform3D _tf3d_scale_and_trans;

    public Tex3Cube(TransparencyAttributes trans_att, ColoringAttributes bg_col_att, TransformGroup spin, Canvas3D canvas3d) {
        this._bg_trans_att = trans_att;
        this._bg_col_att = bg_col_att;
        this._root_spin = spin;
        this._show_debug_border = false;
        this._canvas3d = canvas3d;
        this._matrix_attrib = new ShaderAttributeValue("normal_transform", (Object)this._transform_matrix);
        this._matrix_attrib.setCapability(1);
    }

    protected final void update_tex_coords() {
        this._root_spin.getTransform(this._tf3d_spin);
        this._tf3d_spin.invert();
        this._tf3f_tc_trans.set(this._tf3d_scale_and_trans);
        this._tf3f_tc_trans.mul(this._tf3d_spin);
        if (this._bg_shps.length > 0) {
            TextureUnitState[] textureUnitStateArray = this._bg_shps[0].getAppearance().getTextureUnitState();
            int n = textureUnitStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextureUnitState tus = textureUnitStateArray[n2];
                if (tus != null) {
                    tus.getTextureAttributes().setTextureTransform(this._tf3f_tc_trans);
                }
                ++n2;
            }
        }
        Transform3D tmp_transform = new Transform3D();
        if (MasterControl.get_v3d() != null) {
            MasterControl.get_v3d().get_data_to_light_transform(tmp_transform);
        } else {
            tmp_transform.setIdentity();
        }
        tmp_transform.invert();
        tmp_transform.transpose();
        tmp_transform.getRotationScale(this._transform_matrix);
        this._matrix_attrib.setValue((Object)this._transform_matrix);
    }

    public final void attach(BranchGroup bg) {
        BranchGroup parent = (BranchGroup)bg.getParent();
        if (parent != null) {
            bg.detach();
        }
        bg.addChild((Node)this._plane_group);
        this.update_tex_coords();
        if (parent != null) {
            parent.addChild((Node)bg);
        }
    }

    public final void free_ressources(BranchGroup bg) {
        bg.removeChild((Node)this._plane_group);
        this._bg_shps = null;
        this._bg_imgs = null;
        this._bg_tex = null;
        this._ic3d = null;
        this._plane_group = null;
        this._normal_tex = null;
        this._normal_imgs = null;
    }

    public final void set_size(int tex_step_size, int[] tex_w, int[] tex_h) {
        TextureUnitState[] state;
        Appearance ap;
        boolean shading_enabled = this.is_shading_enabled();
        boolean color_from_normals = Settings.get_bool_option(Tex3Renderer3d.class, Tex3Renderer3d.OPT_DEBUG_VISUALIZE_NORMALS);
        boolean use_nicest_filtering = Settings.get_bool_option(Tex3Renderer3d.class, Tex3Renderer3d.OPT_NICEST_FILTERING);
        RegularGrid3i vc = MasterControl.get_is().get_voxel_cube();
        int dim_x = vc.get_dim_x();
        int dim_y = vc.get_dim_y();
        int dim_z = vc.get_dim_z();
        this._bg_shps = this.create_background_shapes(dim_x, dim_y, dim_z, tex_step_size);
        this._bg_imgs = this.create_background_images(dim_z, tex_w, tex_h);
        this._ic3d = this.create_image_component3D(this._bg_imgs);
        this._bg_tex = this.create_background_texture(dim_z, tex_w, tex_h, this._ic3d, use_nicest_filtering);
        if (shading_enabled) {
            this._normal_tex = this.create_normal_texture(dim_z, tex_w, tex_h, this._bg_imgs, use_nicest_filtering);
            FragmentShader fragment_shader = color_from_normals ? FragmentShader.NORMAL_COLOR : FragmentShader.PHONG_SHADING;
            ShaderProgram sp = fragment_shader.get_shader_program();
            ShaderAppearance shader_ap = new ShaderAppearance();
            shader_ap.setShaderProgram(sp);
            ShaderAttributeSet sas = new ShaderAttributeSet();
            sas.put((ShaderAttribute)new ShaderAttributeValue("volume_texture", (Object)new Integer(0)));
            sas.put((ShaderAttribute)new ShaderAttributeValue("normal_texture", (Object)new Integer(1)));
            if (!color_from_normals) {
                sas.put((ShaderAttribute)this._matrix_attrib);
            }
            shader_ap.setShaderAttributeSet(sas);
            ap = shader_ap;
            TextureAttributes bg_tex_att = new TextureAttributes();
            bg_tex_att.setCapability(5);
            TextureAttributes normal_tex_att = new TextureAttributes();
            normal_tex_att.setCapability(5);
            state = new TextureUnitState[2];
            state[0] = new TextureUnitState((Texture)this._bg_tex, bg_tex_att, null);
            state[0].setCapability(1);
            state[1] = new TextureUnitState((Texture)this._normal_tex, normal_tex_att, null);
            state[1].setCapability(1);
        } else {
            ap = new Appearance();
            TextureAttributes bg_tex_att = new TextureAttributes();
            bg_tex_att.setCapability(5);
            bg_tex_att.setTextureMode(2);
            state = new TextureUnitState[]{new TextureUnitState((Texture)this._bg_tex, bg_tex_att, null)};
            state[0].setCapability(1);
        }
        PolygonAttributes pol_att = new PolygonAttributes();
        pol_att.setPolygonMode(2);
        pol_att.setCullFace(0);
        ap.setTransparencyAttributes(this._bg_trans_att);
        ap.setColoringAttributes(this._bg_col_att);
        ap.setTextureUnitState(state);
        ap.setPolygonAttributes(pol_att);
        this._plane_group = new BranchGroup();
        this._plane_group.setCapability(17);
        ImageStack is = MasterControl.get_is();
        double x_spacing = is.get_x_spacing();
        double y_spacing = is.get_y_spacing();
        double z_spacing = is.get_z_spacing();
        double xmax_scaled = (double)dim_x * x_spacing;
        double ymax_scaled = (double)dim_y * y_spacing;
        double zmax_scaled = (double)dim_z * z_spacing;
        double dl = Math.sqrt(xmax_scaled * xmax_scaled + ymax_scaled * ymax_scaled + zmax_scaled * zmax_scaled);
        double wc_delta_z = dl / (double)(this._bg_shps.length - 1);
        double tc_delta_z = 1.0 / (double)(this._bg_shps.length - 1);
        this._tf3d_scale_and_trans = new Transform3D();
        this._tf3d_scale_and_trans.setScale(new Vector3d(dl / xmax_scaled, dl / ymax_scaled, dl / zmax_scaled));
        this._tf3d_scale_and_trans.setTranslation(new Vector3d(0.5, 0.5, 0.5));
        int i = 0;
        while (i < this._bg_shps.length) {
            QuadArray qa_plane = new QuadArray(4, 65, 1, new int[2]);
            Point3f a = new Point3f(0.0f, 0.0f, (float)(wc_delta_z * (double)i));
            Point3f b = new Point3f(0.0f, (float)dl, (float)(wc_delta_z * (double)i));
            Point3f c = new Point3f((float)dl, (float)dl, (float)(wc_delta_z * (double)i));
            Point3f d = new Point3f((float)dl, 0.0f, (float)(wc_delta_z * (double)i));
            qa_plane.setCoordinate(0, a);
            qa_plane.setCoordinate(1, b);
            qa_plane.setCoordinate(2, c);
            qa_plane.setCoordinate(3, d);
            float tc_z = -0.5f + (float)((double)i * tc_delta_z);
            qa_plane.setTextureCoordinate(0, 0, new TexCoord3f(-0.5f, -0.5f, tc_z));
            qa_plane.setTextureCoordinate(0, 1, new TexCoord3f(-0.5f, 0.5f, tc_z));
            qa_plane.setTextureCoordinate(0, 2, new TexCoord3f(0.5f, 0.5f, tc_z));
            qa_plane.setTextureCoordinate(0, 3, new TexCoord3f(0.5f, -0.5f, tc_z));
            this._bg_shps[i] = new Shape3D((Geometry)qa_plane, ap);
            this._plane_group.addChild((Node)this._bg_shps[i]);
            this.showDebugBordersIfNecessary(a, b, c, d);
            ++i;
        }
    }

    private void showDebugBordersIfNecessary(Point3f a, Point3f b, Point3f c, Point3f d) {
        if (this._show_debug_border) {
            Appearance border_ap = new Appearance();
            ColoringAttributes ca = new ColoringAttributes();
            ca.setColor(new Color3f(1.0f, 1.0f, 1.0f));
            border_ap.setColoringAttributes(ca);
            LineArray lines = new LineArray(8, 1);
            lines.setCoordinate(0, a);
            lines.setCoordinate(1, b);
            lines.setCoordinate(2, b);
            lines.setCoordinate(3, c);
            lines.setCoordinate(4, c);
            lines.setCoordinate(5, d);
            lines.setCoordinate(6, d);
            lines.setCoordinate(7, a);
            Shape3D border_shp = new Shape3D((Geometry)lines, border_ap);
            this._plane_group.addChild((Node)border_shp);
        }
    }

    private boolean is_shading_enabled() {
        boolean shading_enabled = Settings.get_bool_option(Tex3Renderer3d.class, Tex3Renderer3d.OPT_RENDER_SHADED);
        int max_texture_units = (Integer)this._canvas3d.queryProperties().get("textureUnitStateMax");
        if (max_texture_units < 2) {
            shading_enabled = false;
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Tex3Cube::set_size: disabled shading in texture rendere. Not enough texture units supported.");
        }
        return shading_enabled;
    }

    private Shape3D[] create_background_shapes(int xmax, int ymax, int zmax, int tex_step_size) {
        return new Shape3D[(int)Math.round(Math.sqrt(xmax * xmax + ymax * ymax + zmax * zmax) / (double)tex_step_size)];
    }

    private BufferedImage[] create_background_images(int zmax, int[] tex_w, int[] tex_h) {
        BufferedImage[] images = new BufferedImage[zmax];
        int i = 0;
        while (i < images.length) {
            images[i] = new BufferedImage(tex_w[0], tex_h[0], 2);
            ++i;
        }
        return images;
    }

    private ImageComponent3D create_image_component3D(BufferedImage[] bg_imgs) {
        ImageComponent3D ic = new ImageComponent3D(2, bg_imgs, true, true);
        ic.setCapability(2);
        ic.setCapability(3);
        return ic;
    }

    private Texture3D create_background_texture(int zmax, int[] tex_w, int[] tex_h, ImageComponent3D ic3d, boolean use_nicest_filtering) {
        Texture3D bg_texture = new Texture3D(1, 6, tex_w[0], tex_h[0], zmax);
        bg_texture.setCapability(7);
        if (use_nicest_filtering) {
            bg_texture.setMagFilter(1);
            bg_texture.setMinFilter(1);
        }
        bg_texture.setImage(0, (ImageComponent)ic3d);
        bg_texture.setBoundaryModeR(5);
        bg_texture.setBoundaryModeS(5);
        bg_texture.setBoundaryModeT(5);
        bg_texture.setBoundaryColor(0.0f, 0.0f, 0.0f, 0.0f);
        return bg_texture;
    }

    private Texture3D create_normal_texture(int zmax, int[] tex_w, int[] tex_h, BufferedImage[] bg_images, boolean use_nicest_filtering) {
        Texture3D normal_texture = new Texture3D(1, 5, tex_w[0], tex_h[0], bg_images.length);
        normal_texture.setCapability(7);
        if (use_nicest_filtering) {
            normal_texture.setMagFilter(1);
            normal_texture.setMinFilter(1);
        }
        if (this._normal_imgs == null) {
            this._normal_imgs = this.create_normal_images(zmax, tex_w, tex_h);
        }
        ImageComponent3D i3d_normals = new ImageComponent3D(1, this._normal_imgs, true, true);
        normal_texture.setImage(0, (ImageComponent)i3d_normals);
        normal_texture.setBoundaryModeR(5);
        normal_texture.setBoundaryModeS(5);
        normal_texture.setBoundaryModeT(5);
        normal_texture.setBoundaryColor(0.0f, 0.0f, 0.0f, 0.0f);
        return normal_texture;
    }

    private BufferedImage[] create_normal_images(int zmax, int[] tex_w, int[] tex_h) {
        BufferedImage[] normal_images = new BufferedImage[zmax];
        int i = 0;
        while (i < normal_images.length) {
            normal_images[i] = new BufferedImage(tex_w[0], tex_h[0], 1);
            ++i;
        }
        Tex3Cube.fill_normal_texture(normal_images);
        return normal_images;
    }

    private static final void fill_normal_texture(BufferedImage[] fill_texture) {
        int x;
        int y;
        ImageStack is = MasterControl.get_is();
        RegularGrid3i volume = is.get_voxel_cube();
        GradientFunction gradient_function = GradientFunctionFactory.get_gradient_function(volume, GradientFunctionType.CENTRAL_DIFFERENCES, GradientCachingMethod.ON_THE_FLY);
        Vector3f gradient = new Vector3f();
        int dim_x = volume.get_dim_x();
        int dim_y = volume.get_dim_y();
        int dim_z = volume.get_dim_z();
        int offset_for_y_plus_1 = volume.get_index_offset_for_y_plus_1();
        int z = 1;
        while (z < dim_z - 1) {
            int[] slice = ((DataBufferInt)fill_texture[z].getRaster().getDataBuffer()).getData();
            y = 1;
            while (y < dim_y - 1) {
                x = 1;
                while (x < dim_x - 1) {
                    gradient_function.gradient_at(x, y, z, gradient);
                    gradient.normalize();
                    int nx = (int)((gradient.x + 1.0f) * 0.5f * 255.0f);
                    int ny = (int)((gradient.y + 1.0f) * 0.5f * 255.0f);
                    int nz = (int)((gradient.z + 1.0f) * 0.5f * 255.0f);
                    slice[y * offset_for_y_plus_1 + x] = nx << 16 | ny << 8 | nz;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        int zn = 0x808000;
        int zp = 0x8080FF;
        y = 0;
        while (y < dim_y) {
            x = 0;
            while (x < dim_x - 1) {
                fill_texture[0].setRGB(x, y, 0x8080FF);
                fill_texture[dim_z - 1].setRGB(x, y, 0x808000);
                ++x;
            }
            ++y;
        }
        int xn = 32896;
        int xp = 0xFF8080;
        int z2 = 0;
        while (z2 < dim_z) {
            int y2 = 0;
            while (y2 < dim_y) {
                fill_texture[z2].setRGB(0, y2, 0xFF8080);
                fill_texture[z2].setRGB(dim_x - 1, y2, 32896);
                ++y2;
            }
            ++z2;
        }
        int yn = 0x800080;
        int yp = 0x80FF80;
        int z3 = 0;
        while (z3 < dim_z) {
            int x2 = 0;
            while (x2 < dim_x) {
                fill_texture[z3].setRGB(x2, 0, 0x80FF80);
                fill_texture[z3].setRGB(x2, dim_y - 1, 0x800080);
                ++x2;
            }
            ++z3;
        }
    }
}

