/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.view3d.Viewport3d;
import misc.VoxelColorTable;
import misc.messages.YObservable;
import renderer.Tex3Cube;
import renderer.TexRenderer3d;
import settings.Settings;
import settings.SettingsOwner;
import threads.RenderThread;

public final class Tex3Renderer3d
extends TexRenderer3d
implements SettingsOwner {
    public static final String OPT_TEX_DIM = Settings.register_int_opt(Tex3Renderer3d.class, "texture dimension", "Texture image dimensions: A 3D texture can be seen as a stack of 2d images.", 256);
    public static final String OPT_ALWAYS_USE_TEX_DIM = Settings.register_bool_opt(Tex3Renderer3d.class, "texture dimension always", "Uses the texture dimension even if non-power of two is supported (e.g. to reduce memory usage)", false);
    public static final String OPT_TEX_STEPS = Settings.register_int_opt(Tex3Renderer3d.class, "texture steps", "The maximum number of planes that would be usefull is divided by this number. Larger values for thissettings result in less memory usage and worse rendering quality.", 2);
    public static final String OPT_BG_TRANS = Settings.register_double_opt(Tex3Renderer3d.class, "bg transparency", "Transparency valuef for the background rendering.", 0.5);
    public static final String OPT_BG_COLOR = Settings.register_color_opt(Tex3Renderer3d.class, "bg color", "Color of the planes if the child image renderer is not set to pseudo color.", new Color(255, 255, 255));
    public static final String OPT_RENDER_BG = Settings.register_bool_opt(Tex3Renderer3d.class, "render background", "Render DICOM data as 3D Texture.", false);
    public static final String OPT_NICEST_FILTERING = Settings.register_bool_opt(Tex3Renderer3d.class, "nices filtering", "use nicest texture filtering available", false);
    public static final String OPT_RENDER_SHADED = Settings.register_bool_opt(Tex3Renderer3d.class, "shaded rendering", "use shading in the 3d texture renderin", false);
    public static final String OPT_DEBUG_VISUALIZE_NORMALS = Settings.register_bool_opt(Tex3Renderer3d.class, "debug: colored normals", "use normal direction as color", false);
    public static final String OPT_DEBUG_SHOW_BORDERS = Settings.register_bool_opt(Tex3Renderer3d.class, "debug: show borders", "Shows Plane Borders", false);
    private final Tex3Cube _tex3_cube;
    private Tex3RenderThread _render_thread;
    private VoxelColorTable _vct;
    private final Shape3D _dummy_triangle;

    public Tex3Renderer3d(Viewport3d v3d, int scene_id, TransformGroup spin, Canvas3D canvas3d) {
        super(v3d, scene_id);
        Settings.register_owner(this);
        this._visible = Settings.get_bool_option(this, OPT_RENDER_BG);
        float trans = Settings.get_double_option(this, OPT_BG_TRANS).floatValue();
        TransparencyAttributes bg_trans_att = new TransparencyAttributes(2, trans);
        bg_trans_att.setCapability(3);
        ColoringAttributes bg_col_att = new ColoringAttributes();
        bg_col_att.setColor(new Color3f(Settings.get_color_option(this, OPT_BG_COLOR)));
        bg_col_att.setCapability(1);
        this._tex3_cube = new Tex3Cube(bg_trans_att, bg_col_att, spin, canvas3d);
        this._render_thread = null;
        Appearance dummy_ap = new Appearance();
        ColoringAttributes dummy_ca = new ColoringAttributes();
        dummy_ca.setCapability(1);
        dummy_ca.setShadeModel(3);
        Material dummy_mat = new Material();
        dummy_mat.setCapability(1);
        dummy_mat.setShininess(50.0f);
        dummy_mat.setDiffuseColor(new Color3f(0.8f, 0.8f, 0.8f));
        dummy_mat.setSpecularColor(new Color3f(0.8f, 0.8f, 0.8f));
        dummy_ap.setColoringAttributes(dummy_ca);
        dummy_ap.setMaterial(dummy_mat);
        TriangleArray ta = new TriangleArray(3, 1);
        this._dummy_triangle = new Shape3D((Geometry)ta, dummy_ap);
        this._bg.addChild((Node)this._dummy_triangle);
        this._imr2d.addObserver(this, "Tex3Renderer3d()");
        v3d._transform_notifier.addObserver(this, "Tex3Renderer3d()");
    }

    @Override
    public final void set_visible(boolean visible) {
        if (!this._visible && visible) {
            int tex_steps = Settings.get_int_option(this, OPT_TEX_STEPS);
            this.calc_dimensions(Settings.get_int_option(this, OPT_TEX_DIM), Settings.get_bool_option(this, OPT_ALWAYS_USE_TEX_DIM));
            this._tex3_cube._show_debug_border = Settings.get_bool_option(this, OPT_DEBUG_SHOW_BORDERS);
            this._tex3_cube.set_size(tex_steps, this._w, this._h);
            this._tex3_cube.attach(this._bg);
        }
        super.set_visible(visible);
    }

    @Override
    public final void free_ressources() {
        this._tex3_cube.free_ressources(this._bg);
        System.gc();
        System.gc();
    }

    @Override
    public final void create_scene() {
        ImageStack is;
        if (this._visible && (is = MasterControl.get_is()).get_state() == 2 && !this._resizing) {
            if (this._render_thread == null || this._render_thread.getState() == Thread.State.TERMINATED) {
                this._render_thread = new Tex3RenderThread(this);
                this._render_thread.start();
            } else {
                this._render_thread.restart();
            }
        }
    }

    private VoxelColorTable alpha_adjusted_color_table(VoxelColorTable source_table) {
        int steps = Settings.get_int_option(this, OPT_TEX_STEPS);
        double sample_dist = (double)steps / Math.sqrt(3.0);
        int size = source_table._colors.length;
        VoxelColorTable vct = new VoxelColorTable(size);
        int i = 0;
        while (i < size) {
            int argb = source_table._colors[i];
            int rgb = 0xFFFFFF & argb;
            int a_old = (0xFF000000 & argb) >> 24 & 0xFF;
            int a_new = (int)(0.5 + 255.0 * (1.0 - Math.pow(1.0 - (double)a_old / 255.0, sample_dist)));
            a_new = Math.max(0, Math.min(255, a_new));
            vct._colors[i] = a_new << 24 | rgb;
            ++i;
        }
        return vct;
    }

    public final void resize() {
        this._resizing = false;
        if (this._visible) {
            this.set_visible(false);
            this.set_visible(true);
        }
    }

    @Override
    public final void update(YObservable yo, Message m) {
        if (yo.getClass() == ImageStack.class) {
            if (m._type == ImageStack.M_CLEAR) {
                Settings.set_class_bool_option(Tex3Renderer3d.class, OPT_RENDER_BG, false);
            } else if (m._type == ImageStack.M_RESIZE_START) {
                this._resizing = true;
                if (this._render_thread != null && this._render_thread.getState() != Thread.State.TERMINATED) {
                    this._render_thread.stop_soon();
                }
            }
        } else if (yo.getClass() == Viewport3d.ObservableV3D.class && m._type == Viewport3d.M_ROTATION_CHANGED && this._visible) {
            this._tex3_cube.update_tex_coords();
        }
        super.update(yo, m);
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_TEX_STEPS || opt_name == OPT_TEX_DIM || opt_name == OPT_NICEST_FILTERING || opt_name == OPT_DEBUG_SHOW_BORDERS || opt_name == OPT_RENDER_SHADED || opt_name == OPT_DEBUG_VISUALIZE_NORMALS || opt_name == OPT_ALWAYS_USE_TEX_DIM) {
            if (this._visible) {
                this.set_visible(false);
                this.set_visible(true);
            }
        } else if (opt_name == OPT_BG_TRANS) {
            Double trans = Settings.get_double_option(this, OPT_BG_TRANS);
            this._tex3_cube._bg_trans_att.setTransparency(trans.floatValue());
        } else if (opt_name == OPT_BG_COLOR) {
            Color col = Settings.get_color_option(this, OPT_BG_COLOR);
            this._tex3_cube._bg_col_att.setColor(new Color3f(col));
        } else if (opt_name == OPT_RENDER_BG) {
            this.set_visible((Boolean)opt);
        }
    }

    @Override
    public String get_name() {
        return this.toString();
    }

    private final class Tex3RenderThread
    extends RenderThread
    implements ImageComponent3D.Updater {
        public Tex3RenderThread(SettingsOwner parent) {
            super(parent, false);
            this._label = "Tex3RenderThread";
        }

        @Override
        public final void my_run() {
            Tex3Renderer3d.this._vct = Tex3Renderer3d.this.alpha_adjusted_color_table(Tex3Renderer3d.this._imr2d.get_voxel_color_table());
            BranchGroup bg_parent = (BranchGroup)((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._plane_group.getParent();
            if (Settings.get_bool_option(this._parent, OPT_NICEST_FILTERING).booleanValue()) {
                ((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._plane_group.detach();
            }
            ImageStack is = MasterControl.get_is();
            do {
                this._restart = false;
                int i = 0;
                while (!this._restart && i < ((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.getDepth()) {
                    if (is.get_state() != 2 || this._stop_soon || Tex3Renderer3d.this._resizing) {
                        return;
                    }
                    ((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.updateData((ImageComponent3D.Updater)this, i, 0, 0, ((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.getWidth(), ((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.getHeight());
                    ++i;
                }
            } while (this._restart && !this._stop_soon);
            if (Settings.get_bool_option(this._parent, OPT_NICEST_FILTERING).booleanValue()) {
                bg_parent.addChild((Node)((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._plane_group);
            }
        }

        public void updateData(ImageComponent3D ic, int i, int x, int y, int w, int h) {
            if (_textureNonPowerOfTwoAvailable && !Settings.get_bool_option(this._parent, OPT_ALWAYS_USE_TEX_DIM).booleanValue()) {
                if (Tex3Renderer3d.this._imr2d._use_tf_hack) {
                    Tex3Renderer3d.this._imr2d.render_alpha_bg_image_from_tf_set(((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.getImage(i), 0, i);
                } else {
                    Tex3Renderer3d.this._imr2d.render_alpha_bg_image(((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.getImage(i), 0, i, Tex3Renderer3d.this._seg_render_list, Tex3Renderer3d.this._vct);
                }
            } else if (Tex3Renderer3d.this._imr2d._use_tf_hack) {
                Tex3Renderer3d.this._imr2d.render_scaled_alpha_bg_image_from_tf_set(((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.getImage(i), 0, i);
            } else {
                Tex3Renderer3d.this._imr2d.render_scaled_alpha_bg_image(((Tex3Renderer3d)Tex3Renderer3d.this)._tex3_cube._ic3d.getImage(i), 0, i, Tex3Renderer3d.this._seg_render_list, null);
            }
        }
    }
}

