/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.GraphicsConfiguration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.YaDiV;
import main.view3d.Viewport3d;
import misc.messages.YObservable;
import renderer.BGImageRenderer2d;
import renderer.Renderer2d;
import renderer.Renderer3d;
import renderer.SegRenderer2d;

public abstract class TexRenderer3d
extends Renderer3d {
    protected BGImageRenderer2d _imr2d;
    protected LinkedList<SegRenderer2d> _seg_render_list;
    protected HashMap<Segment, SegRenderer2d> _seg_renderer_map;
    protected final int[] _w = new int[3];
    protected final int[] _h = new int[3];
    protected static boolean _textureNonPowerOfTwoAvailable;
    protected boolean _resizing = false;

    static {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3d = new Canvas3D(config);
        Map prop_map = canvas3d.queryProperties();
        _textureNonPowerOfTwoAvailable = (Boolean)prop_map.get("textureNonPowerOfTwoAvailable");
        if (!_textureNonPowerOfTwoAvailable) {
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "The GFX Hardware does not support textures with non power of two.");
        }
    }

    public TexRenderer3d(Viewport3d v3d, int scene_id) {
        super(v3d, scene_id);
        this._imr2d = new BGImageRenderer2d("BGIR " + this.getClass().getSimpleName());
        this._seg_render_list = new LinkedList();
        this._seg_renderer_map = new HashMap();
        MasterControl.get_is().addObserver(this, "TexRenderer3d()");
    }

    public final void show_seg(Segment seg, boolean show) {
        SegRenderer2d sr2d = this._seg_renderer_map.get(seg);
        if (show) {
            if (!this._seg_render_list.contains(sr2d)) {
                this._seg_render_list.add(sr2d);
                sr2d.addObserver(this, "TexRenderer3d::show_seg");
                this.create_scene();
            }
        } else if (this._seg_render_list.contains(sr2d)) {
            this._seg_render_list.remove(sr2d);
            sr2d.deleteObserver(this);
            this.create_scene();
        }
    }

    public final BGImageRenderer2d get_image_renderer() {
        return this._imr2d;
    }

    protected final void calc_dimensions(int tex_dim, boolean use_always) {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 0) {
            this._w[0] = 5;
            this._w[1] = 5;
            this._w[2] = 5;
            this._h[0] = 5;
            this._h[1] = 5;
            this._h[2] = 5;
        } else if (use_always || !_textureNonPowerOfTwoAvailable) {
            this._w[0] = tex_dim;
            this._w[1] = tex_dim;
            this._w[2] = tex_dim;
            this._h[0] = tex_dim;
            this._h[1] = tex_dim;
            this._h[2] = tex_dim;
        } else {
            this._w[0] = is.get_dim_x();
            this._w[1] = is.get_dim_y();
            this._w[2] = is.get_dim_x();
            this._h[0] = is.get_dim_y();
            this._h[1] = is.get_dim_z();
            this._h[2] = is.get_dim_z();
        }
    }

    @Override
    public void update(YObservable yo, Message m) {
        if (m._type == Renderer2d.M_REQUEST_REDRAW) {
            this.create_scene();
        } else if (m._type == ImageStack.M_NEW_SEGMENT) {
            Segment seg = (Segment)m._obj;
            SegRenderer2d sr2d = new SegRenderer2d(seg, "SR2D " + this.getClass().getSimpleName());
            sr2d.allocate();
            this._seg_renderer_map.put(seg, sr2d);
        } else if (m._type == ImageStack.M_DEL_SEGMENT) {
            Segment seg = (Segment)m._obj;
            this.show_seg(seg, false);
            this._seg_renderer_map.remove(seg);
        } else if (m._type == ImageStack.M_LOADING_END) {
            this._imr2d.init_roi_func();
        }
    }
}

