/*
 * Decompiled with CFR 0.152.
 */
package renderer.benchmark;

import java.awt.Color;
import java.util.Random;
import main.Segment;
import misc.StopWatch;
import misc.grid.VoxelCube;
import org.junit.Ignore;
import org.junit.Test;
import raycaster.SegmentTfMerger;
import renderer.SegmentColorTableMap;
import renderer.benchmark.SegmentColorTableMapOptimized;

public class SegmentColorTableMapBenchmark {
    private final int cube_size = 200;
    private final int color1 = new Color(1, 1, 1, 1).getRGB();
    private final int color2 = new Color(2, 2, 2, 2).getRGB();
    private final int color3 = new Color(3, 3, 3, 3).getRGB();
    private final int color4 = new Color(4, 4, 4, 4).getRGB();
    private final int color5 = new Color(5, 5, 5, 5).getRGB();
    private int[] color_table = new int[]{this.color1, this.color2, this.color3, this.color4, this.color5};
    private VoxelCube vc = new VoxelCube(200, 200, 200);
    private Segment segment = new Segment("Segment", 200, 200, 200);
    private final SegmentColorTableMap seg_map = new SegmentColorTableMap(SegmentTfMerger.MAX_PRIORITY, this.vc, this.color_table);
    private final SegmentColorTableMapOptimized seg_map_optimized = new SegmentColorTableMapOptimized(SegmentTfMerger.MAX_PRIORITY, this.vc, this.color_table);

    @Test
    @Ignore
    public void benchmark() throws InterruptedException {
        this.init_voxel_cube();
        this.init_segment_bit_cube();
        this.seg_map.add_segment(this.segment, this.color_table);
        this.seg_map_optimized.add_segment(this.segment, this.color_table);
        Thread.sleep(1000L);
        long s2time = this.bench_s2();
        Thread.sleep(1000L);
        long s1time = this.bench_s1();
        System.out.println("s1: " + s1time);
        System.out.println("s2: " + s2time);
        System.out.println("Difference: " + (s1time - s2time) * 100L / s2time + "%");
    }

    private long bench_s1() {
        StopWatch sw = new StopWatch(true);
        int i = 0;
        while (i < 200) {
            int j = 0;
            while (j < 200) {
                int k = 0;
                while (k < 200) {
                    this.seg_map.color_at(i, j, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return sw.get_ms();
    }

    private long bench_s2() {
        StopWatch sw = new StopWatch(true);
        int i = 0;
        while (i < 200) {
            int j = 0;
            while (j < 200) {
                int k = 0;
                while (k < 200) {
                    this.seg_map_optimized.color_at(i, j, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return sw.get_ms();
    }

    private void init_voxel_cube() {
        Random random = new Random(0L);
        int i = 0;
        while (i < this.vc.get_number_of_voxels()) {
            this.vc.set(i, Math.abs(random.nextInt()) % 2);
            ++i;
        }
    }

    private void init_segment_bit_cube() {
        Random random = new Random(0L);
        int[] bc_data = this.segment.get_bc().get_data();
        int i = 0;
        while (i < bc_data.length) {
            bc_data[i] = random.nextInt();
            ++i;
        }
    }
}

