/*
 * Decompiled with CFR 0.152.
 */
package renderer.benchmark;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Color4f;
import main.Segment;
import misc.MutableColor;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import raycaster.SegmentTfMerger;
import raycaster.gui.SegmentService;

public final class SegmentColorTableMapOptimized {
    private final SegmentTfMerger _tf_merger;
    private final List<BitCube> _bit_cube_list = new ArrayList<BitCube>();
    private final List<int[]> _color_table_list = new ArrayList<int[]>();
    private final RegularGrid3i _voxel_cube;
    private final int[] _global_color_table;
    private final MutableColor _temp_color = new MutableColor();
    private final Color4f _result_color = new Color4f();
    private Color4f[] result_colors;

    public SegmentColorTableMapOptimized(SegmentTfMerger tf_merger, RegularGrid3i voxel_cube, int[] global_color_table) {
        this._tf_merger = tf_merger;
        this._voxel_cube = voxel_cube;
        this._global_color_table = global_color_table;
        this.init_result_colors();
    }

    public void add_segment(Segment segment, int[] segment_color_table) {
        if (segment == null || segment_color_table == null) {
            String error_message = "May not be null: " + segment == null ? "segment" : ("" + segment_color_table == null ? "segment_color_table" : "");
            throw new IllegalArgumentException(error_message);
        }
        if (this._bit_cube_list.contains(segment.get_bc())) {
            throw new IllegalArgumentException("Color table map already contains " + segment);
        }
        if (segment != SegmentService.ALL_VOXELS_SEGMENT) {
            this._bit_cube_list.add(segment.get_bc());
            this._color_table_list.add(segment_color_table);
        }
        this.init_result_colors();
    }

    private void init_result_colors() {
        int number_of_color_tables = this._bit_cube_list.size() + 1;
        this.result_colors = new Color4f[number_of_color_tables];
        int i = 0;
        while (i < this.result_colors.length) {
            this.result_colors[i] = new Color4f();
            ++i;
        }
    }

    public int color_at(int x, int y, int z) {
        Color4f result_color_temp;
        this._result_color.set(0.0f, 0.0f, 0.0f, 0.0f);
        int intensity = this._voxel_cube.get(x, y, z);
        int i = 0;
        while (i < this._bit_cube_list.size()) {
            if (this._bit_cube_list.get(i).getXYZ(x, y, z)) {
                this._temp_color.setRGB(this._color_table_list.get(i)[intensity]);
                result_color_temp = this.result_colors[i + 1];
                if (this._temp_color.getAlpha() > 0) {
                    this._temp_color.get(result_color_temp);
                } else {
                    result_color_temp.w = -1.0f;
                }
            } else {
                this.result_colors[i + 1].w = -1.0f;
            }
            ++i;
        }
        int global_color_value = this._global_color_table[intensity];
        this._temp_color.setRGB(global_color_value);
        result_color_temp = this.result_colors[0];
        if (this._temp_color.getAlpha() > 0) {
            this._temp_color.get(result_color_temp);
        } else {
            result_color_temp.w = -1.0f;
        }
        this._tf_merger.calculate(this._result_color, this.result_colors);
        if (this._result_color.w <= 0.0f) {
            return 0;
        }
        this._temp_color.set(this._result_color);
        return this._temp_color.getRGB();
    }
}

