/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import settings.Settings;
import settings.SettingsListener;
import settings.SettingsOwner;

public final class JEnumOptionComboBox
extends JComboBox
implements SettingsListener,
ActionListener {
    private SettingsOwner _opt_owner;
    private String _opt_name;
    private Class<?> _opt_class;
    Enum<?>[] _enum_objs;
    String[] _enum_strs;

    public JEnumOptionComboBox(SettingsOwner opt_owner, String opt_name) {
        if (opt_owner != null) {
            this.set_owner_option(opt_owner, opt_name);
        }
        this.addActionListener(this);
    }

    public JEnumOptionComboBox(Class<?> opt_class, String opt_name) {
        this.set_class_option(opt_class, opt_name);
        this.addActionListener(this);
    }

    private void select_option(Enum<?> enum_value) {
        int select = 0;
        this._enum_objs = (Enum[])enum_value.getDeclaringClass().getEnumConstants();
        this._enum_strs = new String[this._enum_objs.length];
        int i = 0;
        while (i < this._enum_objs.length) {
            if (this._enum_objs[i] == enum_value) {
                select = i;
            }
            this._enum_strs[i] = this._enum_objs[i].toString();
            this.addItem(this._enum_strs[i]);
            ++i;
        }
        this.setSelectedIndex(select);
    }

    public void set_owner_option(SettingsOwner opt_owner, String opt_name) {
        this.remove_listeners();
        this._opt_owner = opt_owner;
        this._opt_class = null;
        this._opt_name = opt_name;
        Settings.register_obj_listener(this._opt_owner, this);
        this.setToolTipText(Settings.get_descr(this._opt_owner.getClass(), this._opt_name));
        this.select_option(Settings.get_enum_option(this._opt_owner, this._opt_name));
    }

    public void set_class_option(Class<?> opt_class, String opt_name) {
        this.remove_listeners();
        this._opt_owner = null;
        this._opt_class = opt_class;
        this._opt_name = opt_name;
        Settings.register_class_listener(this._opt_class, this);
        this.setToolTipText(Settings.get_descr(this._opt_class, this._opt_name));
        this.select_option(Settings.get_enum_option(this._opt_class, this._opt_name));
    }

    private void remove_listeners() {
        if (this._opt_owner != null) {
            Settings.remove_obj_listener(this._opt_owner, this);
        }
        if (this._opt_class != null) {
            Settings.remove_class_listener(this._opt_class, this);
        }
    }

    protected void finalize() throws Throwable {
        this.remove_listeners();
        super.finalize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String jcb_str = (String)this.getSelectedItem();
        int i = 0;
        while (i < this._enum_strs.length) {
            if (jcb_str.equals(this._enum_strs[i])) break;
            ++i;
        }
        if (this._opt_owner != null) {
            Settings.set_enum_option(this._opt_owner, this._opt_name, this._enum_objs[i]);
        } else {
            Settings.set_class_enum_option(this._opt_class, this._opt_name, this._enum_objs[i]);
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name.equals(this._opt_name)) {
            Enum<?> enum_value = this._opt_owner != null ? Settings.get_enum_option(this._opt_owner, this._opt_name) : Settings.get_enum_option(this._opt_class, this._opt_name);
            int i = 0;
            while (i < this._enum_objs.length) {
                if (enum_value.equals(this._enum_objs[i])) break;
                ++i;
            }
            this.setSelectedIndex(i);
        }
    }
}

