/*
 * Decompiled with CFR 0.152.
 */
package settings;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import settings.Settings;
import settings.SettingsListener;
import settings.SettingsOwner;

public final class JIntegerOptionSpinner
extends JSpinner
implements SettingsListener,
ChangeListener {
    private SettingsOwner _opt_owner;
    private String _opt_name;
    private Class<?> _opt_class;

    public JIntegerOptionSpinner(SettingsOwner opt_owner, String opt_name, int min, int max, int step) {
        super(new SpinnerNumberModel(min, min, max, step));
        if (opt_owner != null) {
            this.set_owner_option(opt_owner, opt_name);
        }
        this.addChangeListener(this);
    }

    public JIntegerOptionSpinner(Class<?> opt_class, String opt_name, int min, int max, int step) {
        super(new SpinnerNumberModel(Settings.get_int_option(opt_class, opt_name), min, max, step));
        this.set_class_option(opt_class, opt_name);
        this.addChangeListener(this);
    }

    public void set_owner_option(SettingsOwner opt_owner, String opt_name) {
        this.remove_listeners();
        this._opt_owner = opt_owner;
        this._opt_class = null;
        this._opt_name = opt_name;
        this.setValue(Settings.get_int_option(this._opt_owner, this._opt_name));
        this.setToolTipText(Settings.get_descr(this._opt_owner.getClass(), this._opt_name));
        Settings.register_obj_listener(this._opt_owner, this);
    }

    public void set_class_option(Class<?> opt_class, String opt_name) {
        this.remove_listeners();
        this._opt_owner = null;
        this._opt_class = opt_class;
        this._opt_name = opt_name;
        this.setValue(Settings.get_int_option(this._opt_class, this._opt_name));
        this.setToolTipText(Settings.get_descr(this._opt_class, this._opt_name));
        Settings.register_class_listener(this._opt_class, this);
    }

    private void remove_listeners() {
        if (this._opt_owner != null) {
            Settings.remove_obj_listener(this._opt_owner, this);
        }
        if (this._opt_class != null) {
            Settings.remove_class_listener(this._opt_class, this);
        }
    }

    protected void finalize() throws Throwable {
        this.remove_listeners();
        super.finalize();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this._opt_owner != null) {
            Settings.set_int_option(this._opt_owner, this._opt_name, (Integer)this.getValue());
        } else {
            Settings.set_class_int_option(this._opt_class, this._opt_name, (Integer)this.getValue());
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name.equals(this._opt_name)) {
            if (this._opt_owner != null) {
                this.setValue(Settings.get_int_option(this._opt_owner, this._opt_name));
            } else {
                this.setValue(Settings.get_int_option(this._opt_class, this._opt_name));
            }
        }
    }
}

