/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;
import settings.Settings;
import settings.SettingsListener;
import settings.SettingsOwner;

public final class JIntegerOptionTextfield
extends JFormattedTextField
implements SettingsListener,
ActionListener {
    private SettingsOwner _opt_owner;
    private String _opt_name;
    private Class<?> _opt_class;

    public JIntegerOptionTextfield(SettingsOwner opt_owner, String opt_name, int cols) {
        super(NumberFormat.getIntegerInstance());
        if (opt_owner != null) {
            this.set_owner_option(opt_owner, opt_name);
        }
        this.init(cols);
    }

    public JIntegerOptionTextfield(Class<?> opt_class, String opt_name, int cols) {
        super(NumberFormat.getIntegerInstance());
        this.set_class_option(opt_class, opt_name);
        this.init(cols);
    }

    private void init(int cols) {
        NumberFormatter nf = new NumberFormatter(NumberFormat.getIntegerInstance());
        this.setFormatter(nf);
        this.setColumns(cols);
        this.setFocusLostBehavior(2);
        this.addActionListener(this);
    }

    public void set_owner_option(SettingsOwner opt_owner, String opt_name) {
        this.remove_listeners();
        this._opt_owner = opt_owner;
        this._opt_class = null;
        this._opt_name = opt_name;
        this.setValue(Settings.get_int_option(this._opt_owner, this._opt_name));
        Settings.register_obj_listener(this._opt_owner, this);
        this.setToolTipText(Settings.get_descr(this._opt_owner.getClass(), this._opt_name));
    }

    public void set_class_option(Class<?> opt_class, String opt_name) {
        this.remove_listeners();
        this._opt_owner = null;
        this._opt_class = opt_class;
        this._opt_name = opt_name;
        this.setValue(Settings.get_int_option(this._opt_class, this._opt_name));
        this.setToolTipText(Settings.get_descr(this._opt_class, this._opt_name));
        Settings.register_class_listener(this._opt_class, this);
    }

    private void remove_listeners() {
        if (this._opt_owner != null) {
            Settings.remove_obj_listener(this._opt_owner, this);
        }
        if (this._opt_class != null) {
            Settings.remove_class_listener(this._opt_class, this);
        }
    }

    protected void finalize() throws Throwable {
        this.remove_listeners();
        super.finalize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int new_value = ((Number)this.getValue()).intValue();
        if (this._opt_owner != null) {
            Settings.set_int_option(this._opt_owner, this._opt_name, new_value);
        } else {
            Settings.set_class_int_option(this._opt_class, this._opt_name, new_value);
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name.equals(this._opt_name)) {
            if (this._opt_owner != null) {
                this.setValue(Settings.get_int_option(this._opt_owner, this._opt_name));
            } else {
                this.setValue(Settings.get_int_option(this._opt_class, this._opt_name));
            }
        }
    }
}

