/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import settings.Settings;
import settings.SettingsListener;
import settings.SettingsOwner;

public final class JStringOptionTextfield
extends JTextField
implements SettingsListener,
ActionListener {
    private SettingsOwner _opt_owner;
    private String _opt_name;
    private Class<?> _opt_class;

    public JStringOptionTextfield(SettingsOwner opt_owner, String opt_name) {
        super(25);
        if (opt_owner != null) {
            this.set_owner_option(opt_owner, opt_name);
        }
        this.addActionListener(this);
    }

    public JStringOptionTextfield(Class<?> opt_class, String opt_name) {
        super(25);
        this.set_class_option(opt_class, opt_name);
        this.addActionListener(this);
    }

    public void set_owner_option(SettingsOwner opt_owner, String opt_name) {
        this.remove_listeners();
        this.set_owner_option(opt_owner, opt_name);
        this.addActionListener(this);
    }

    public void set_class_option(Class<?> opt_class, String opt_name) {
        this.remove_listeners();
        this._opt_owner = null;
        this._opt_class = opt_class;
        this._opt_name = opt_name;
        this.setText(Settings.get_str_option(this._opt_class, this._opt_name));
        this.setToolTipText(Settings.get_descr(this._opt_class, this._opt_name));
        Settings.register_class_listener(this._opt_class, this);
    }

    private void remove_listeners() {
        if (this._opt_owner != null) {
            Settings.remove_obj_listener(this._opt_owner, this);
        }
        if (this._opt_class != null) {
            Settings.remove_class_listener(this._opt_class, this);
        }
    }

    protected void finalize() throws Throwable {
        this.remove_listeners();
        super.finalize();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this._opt_owner != null) {
            Settings.set_str_option(this._opt_owner, this._opt_name, this.getText());
        } else {
            Settings.set_class_str_option(this._opt_class, this._opt_name, this.getText());
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name.equals(this._opt_name)) {
            if (this._opt_owner != null) {
                this.setText(Settings.get_str_option(this._opt_owner, this._opt_name));
            } else {
                this.setText(Settings.get_str_option(this._opt_class, this._opt_name));
            }
        }
    }
}

