/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jgridmaker.JGridMaker;
import settings.JBoolOptionCheckbox;
import settings.OptionWrapper;
import settings.Settings;
import settings.SettingsComponentFactory;
import settings.SettingsListener;
import settings.SettingsOwner;

public final class SettingsBrowser
extends JPanel
implements SettingsListener {
    private final JTree _tree;
    private final DefaultTreeModel _model;
    private final HashMap<String, Class<?>> _known_classes;
    private final HashMap<Class<?>, DefaultMutableTreeNode> _class_nodes;
    private final HashMap<String, SettingsOwner> _known_objects;
    private final HashMap<SettingsOwner, DefaultMutableTreeNode> _obj_nodes;
    private final DefaultMutableTreeNode _top;
    private final JPanel _jp_right;
    private final JPanel _jp_left;
    private String _sel_class_str = null;
    private String _sel_owner_str = null;
    private String _unique_id = null;
    private final HashMap<Class<?>, HashMap<String, JComponent>> _class_components;
    private final HashMap<SettingsOwner, HashMap<String, JComponent>> _owner_components;

    private void insert_obj_node(SettingsOwner opt_owner) {
        Class<?> owner_class = opt_owner.getClass();
        String owner_name = opt_owner.get_name();
        if (!this._class_nodes.containsKey(owner_class)) {
            this.insert_class_node(owner_class);
        }
        this._owner_components.put(opt_owner, new HashMap());
        DefaultMutableTreeNode class_node = this._class_nodes.get(owner_class);
        DefaultMutableTreeNode obj_node = new DefaultMutableTreeNode(owner_name);
        int i = 0;
        while (i < class_node.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)class_node.getChildAt(i);
            if (((String)node.getUserObject()).compareTo(owner_name) > 0) break;
            ++i;
        }
        this._model.insertNodeInto(obj_node, class_node, i);
        this._known_objects.put(owner_name, opt_owner);
        this._obj_nodes.put(opt_owner, obj_node);
    }

    private void delete_obj_node(SettingsOwner opt_owner) {
        DefaultMutableTreeNode obj_node = this._obj_nodes.get(opt_owner);
        this._model.removeNodeFromParent(obj_node);
        this._obj_nodes.remove(opt_owner);
        this._owner_components.remove(opt_owner);
        this._known_objects.remove(opt_owner);
    }

    private void insert_class_node(Class<?> opt_class) {
        this._class_components.put(opt_class, new HashMap());
        String opt_class_name = opt_class.getSimpleName();
        DefaultMutableTreeNode class_node = null;
        class_node = new DefaultMutableTreeNode(opt_class_name);
        this._known_classes.put(opt_class_name, opt_class);
        this._class_nodes.put(opt_class, class_node);
        int i = 0;
        while (i < this._top.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._top.getChildAt(i);
            if (((String)node.getUserObject()).compareTo(opt_class_name) > 0) break;
            ++i;
        }
        this._model.insertNodeInto(class_node, this._top, i);
    }

    private void build_nodes() {
        Set<Class<?>> class_keys = Settings._class_map.keySet();
        for (Class<?> next_class : class_keys) {
            this.insert_class_node(next_class);
            Set<SettingsOwner> obj_keys = Settings._obj_map.keySet();
            for (SettingsOwner next_obj : obj_keys) {
                if (next_obj.getClass() != next_class) continue;
                this.insert_obj_node(next_obj);
            }
        }
    }

    private void update_class_panel() {
        Class<?> opt_class = this._known_classes.get(this._sel_class_str);
        HashMap<String, OptionWrapper> class_options = Settings._class_map.get(opt_class);
        TreeSet<String> sorted_opt_keys = new TreeSet<String>();
        HashMap<String, JComponent> opt_map = this._class_components.get(opt_class);
        this._jp_right.removeAll();
        JPanel inner_panel = new JPanel();
        String str = new String("<table border='0' width='100%' anchor='north' margin='0' padding='0'><tr bgcolor='#eeeeee'><td anchor='west'>Name</td><td anchor='west'>Class Value</td></tr>");
        sorted_opt_keys.addAll(class_options.keySet());
        for (String opt_name : sorted_opt_keys) {
            String opt_layout_str;
            JComponent comp;
            if (!opt_map.containsKey(opt_name)) {
                opt_map.put(opt_name, SettingsComponentFactory.create_component(opt_class, opt_name));
            }
            if ((comp = opt_map.get(opt_name)) != null) {
                opt_layout_str = "::" + opt_name + "::";
                opt_map.put(opt_name, comp);
                if (comp instanceof JBoolOptionCheckbox) {
                    ((JBoolOptionCheckbox)comp).setText("");
                }
            } else {
                opt_layout_str = opt_name;
            }
            JLabel jl_opt_name = new JLabel(opt_name);
            jl_opt_name.setToolTipText(Settings.get_descr(opt_class, opt_name));
            opt_map.put("jl_" + opt_name, jl_opt_name);
            str = String.valueOf(str) + "<tr><td anchor='west'>::jl_" + opt_name + "::</td>" + "<td anchor='west'>" + opt_layout_str + "</td>" + "</tr>";
        }
        str = String.valueOf(str) + "</table>";
        JGridMaker.make_grid((Container)inner_panel, (String)str, opt_map);
        JPanel gna = new JPanel();
        gna.setLayout(new BorderLayout());
        gna.add((Component)inner_panel, "North");
        JScrollPane opt_scroller = new JScrollPane(gna);
        opt_scroller.setVerticalScrollBarPolicy(20);
        opt_scroller.setHorizontalScrollBarPolicy(31);
        this._jp_right.add((Component)opt_scroller, "Center");
        this._jp_right.updateUI();
    }

    private void update_obj_panel() {
        SettingsOwner owner = this._known_objects.get(this._sel_owner_str);
        HashMap<String, OptionWrapper> class_options = Settings._class_map.get(owner.getClass());
        HashMap<String, JComponent> opt_map = this._owner_components.get(owner);
        TreeSet<String> sorted_opt_keys = new TreeSet<String>();
        this._jp_right.removeAll();
        JPanel inner_panel = new JPanel();
        String str = new String("<table border='0' width='100%' anchor='north'><tr bgcolor='#eeeeee'><td anchor='west'>Name</td><td anchor='west'>Class Value</td><td anchor='west'>Use Class</td></tr>");
        sorted_opt_keys.addAll(class_options.keySet());
        for (String class_opt_name : sorted_opt_keys) {
            String opt_layout_str;
            JComponent comp;
            String class_opt_def_map_name = String.valueOf(class_opt_name) + "def";
            boolean is_default_opt = Settings.uses_class_option(owner, class_opt_name);
            if (!opt_map.containsKey(class_opt_name)) {
                opt_map.put(class_opt_name, SettingsComponentFactory.create_component(owner, class_opt_name));
            }
            if ((comp = opt_map.get(class_opt_name)) != null) {
                opt_layout_str = "::" + class_opt_name + "::";
                opt_map.put(class_opt_name, comp);
                comp.setEnabled(!is_default_opt);
                if (comp instanceof JBoolOptionCheckbox) {
                    ((JBoolOptionCheckbox)comp).setText("");
                }
            } else {
                opt_layout_str = class_opt_name;
            }
            JCheckBox jcb_default = SettingsComponentFactory.create_default_checkbox(owner, class_opt_name, comp);
            opt_map.put(class_opt_def_map_name, jcb_default);
            JLabel jl_opt_name = new JLabel(class_opt_name);
            jl_opt_name.setToolTipText(Settings.get_descr(owner.getClass(), class_opt_name));
            opt_map.put("jl_" + class_opt_name, jl_opt_name);
            str = String.valueOf(str) + "<tr><td anchor='west'>::jl_" + class_opt_name + "::</td>" + "<td anchor='west'>" + opt_layout_str + "</td>" + "<td anchor='west'>::" + class_opt_def_map_name + "::</td>" + "</tr>";
        }
        str = String.valueOf(str) + "</table>";
        JGridMaker.make_grid((Container)inner_panel, (String)str, opt_map);
        JPanel gna = new JPanel();
        gna.setLayout(new BorderLayout());
        gna.add((Component)inner_panel, "North");
        JScrollPane opt_scroller = new JScrollPane(gna);
        opt_scroller.setVerticalScrollBarPolicy(20);
        opt_scroller.setHorizontalScrollBarPolicy(31);
        this._jp_right.add((Component)opt_scroller, "Center");
        this._jp_right.validate();
    }

    public SettingsBrowser(String unique_id) {
        this._unique_id = unique_id;
        this._class_components = new HashMap();
        this._owner_components = new HashMap();
        this._known_classes = new HashMap();
        this._class_nodes = new HashMap();
        this._known_objects = new HashMap();
        this._obj_nodes = new HashMap();
        this._top = new DefaultMutableTreeNode("Classes");
        this._model = new DefaultTreeModel(this._top);
        this.build_nodes();
        this._tree = new JTree(this._model);
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)SettingsBrowser.this._tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node != SettingsBrowser.this._top) {
                    if (node.getParent() == SettingsBrowser.this._top) {
                        SettingsBrowser.this._sel_class_str = (String)node.getUserObject();
                        SettingsBrowser.this._sel_owner_str = null;
                        SettingsBrowser.this.update_class_panel();
                    } else {
                        SettingsBrowser.this._sel_class_str = null;
                        SettingsBrowser.this._sel_owner_str = (String)node.getUserObject();
                        SettingsBrowser.this.update_obj_panel();
                    }
                }
            }
        });
        JPanel button_row = new JPanel();
        JButton jb_load = new JButton("Load");
        jb_load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.load(SettingsBrowser.this._unique_id);
            }
        });
        JButton jb_save = new JButton("Save");
        jb_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.save(SettingsBrowser.this._unique_id);
            }
        });
        JButton jb_reset = new JButton("Reset");
        jb_reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        button_row.add(jb_load);
        button_row.add(jb_save);
        button_row.add(jb_reset);
        JScrollPane class_scroller = new JScrollPane(this._tree);
        class_scroller.setVerticalScrollBarPolicy(20);
        class_scroller.setHorizontalScrollBarPolicy(31);
        this._jp_left = new JPanel();
        this._jp_left.setLayout(new BorderLayout());
        this._jp_left.add((Component)class_scroller, "Center");
        this._jp_left.add((Component)button_row, "South");
        this._jp_right = new JPanel();
        this._jp_right.setLayout(new BorderLayout());
        this._jp_right.setPreferredSize(new Dimension(500, 400));
        JSplitPane splitter = new JSplitPane(1, this._jp_left, this._jp_right);
        splitter.setResizeWeight(0.0);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        Settings.register_class_listener(Settings.class, this);
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj.getClass() == Class.class && obj == Settings.class) {
            if (opt_name == Settings.NEW_OBJ) {
                this.insert_obj_node((SettingsOwner)opt);
            } else if (opt_name == Settings.DEL_OBJ) {
                this.delete_obj_node((SettingsOwner)opt);
            }
        }
    }
}

