/*
 * Decompiled with CFR 0.152.
 */
package threads;

import java.awt.EventQueue;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import main.Message;
import main.StatusBar;
import main.YaDiV;
import misc.StopWatch;
import misc.messages.YObservable;
import misc.messages.YObserver;
import settings.Settings;
import settings.SettingsOwner;

public abstract class RSThread
extends Thread
implements YObserver {
    protected boolean _restart;
    protected boolean _stop_soon;
    protected SettingsOwner _parent;
    protected boolean _monitor;
    protected boolean _stoppable;
    protected String _label;
    protected StopWatch _sw;
    private static final StatusBar _SB = StatusBar.get_instance();
    private static final JProgressBar _PROGRESS_BAR = _SB.get_progress_bar();
    private static final JLabel _PROGRESS_LABEL = _SB.get_progress_label();
    private int _progress_val;

    public RSThread(SettingsOwner parent, boolean monitor, boolean stoppable) {
        this._parent = parent;
        this._monitor = monitor;
        this._stoppable = stoppable;
        this._restart = false;
        this._stop_soon = false;
        this._label = null;
        this._sw = new StopWatch();
    }

    @Override
    public void start() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RSThread.this.start();
                }
            });
            return;
        }
        super.start();
        this._sw.reset();
        this._sw.start();
    }

    public void set_label(String label) {
        if (this._monitor) {
            _PROGRESS_LABEL.setText(label);
        }
    }

    public void restart() {
        this._restart = true;
    }

    public void stop_soon() {
        this._stop_soon = true;
    }

    public boolean will_stop() {
        return this._stop_soon;
    }

    public boolean will_restart() {
        return this._restart;
    }

    public abstract void my_run();

    @Override
    public void run() {
        this.my_run();
        this.end_thread();
    }

    public void end_thread() {
        this._sw.stop();
        if (Settings.get_bool_option(YaDiV.class, YaDiV.OPT_MEASURE_TIMES).booleanValue() && this._label != null) {
            YaDiV.report(YaDiV.ReportType.REPORT_TIME, String.valueOf(this._label) + " = " + this._sw);
        }
        if (this._monitor) {
            _PROGRESS_LABEL.setText("---");
        }
        if (this._stoppable) {
            _SB.set_stopable(null);
        }
    }

    public int get_progress_min() {
        return _PROGRESS_BAR.getMinimum();
    }

    public void set_progress_min(int min) {
        if (this._monitor) {
            _PROGRESS_BAR.setMinimum(min);
        }
    }

    public int get_progress_max() {
        return _PROGRESS_BAR.getMaximum();
    }

    public void set_progress_max(int max) {
        if (this._monitor) {
            _PROGRESS_BAR.setMaximum(max);
        }
    }

    public int get_progress_value() {
        return this._progress_val;
    }

    public void inc_progress_value(int inc) {
        this._progress_val += inc;
        if (this._monitor) {
            _PROGRESS_BAR.setValue(this._progress_val);
        }
    }

    public void init_progress_measure(String label, int min, int max, int value) {
        this._progress_val = value;
        if (this._monitor) {
            _PROGRESS_LABEL.setText(label);
            _PROGRESS_BAR.setMinimum(min);
            _PROGRESS_BAR.setMaximum(max);
            _PROGRESS_BAR.setValue(value);
        }
    }

    public void set_progress_val(int value) {
        this._progress_val = value;
        if (this._monitor) {
            _PROGRESS_BAR.setValue(value);
        }
    }

    @Override
    public void update(YObservable sender, Message arg) {
    }
}

