/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import settings.Settings;
import settings.SettingsListener;
import settings.SettingsOwner;

public final class JBoolOptionToggleButton
extends JToggleButton
implements SettingsListener,
ItemListener {
    private SettingsOwner _opt_owner;
    private String _opt_name;
    private Class<?> _opt_class;

    public JBoolOptionToggleButton(SettingsOwner opt_owner, String opt_name, Icon icon) {
        super(icon);
        if (opt_owner != null) {
            this.set_owner_option(opt_owner, opt_name);
        }
        this.addItemListener(this);
    }

    public JBoolOptionToggleButton(Class<?> opt_class, String opt_name, Icon icon) {
        super(icon);
        this.set_class_option(opt_class, opt_name);
        this.addItemListener(this);
    }

    public void set_owner_option(SettingsOwner opt_owner, String opt_name) {
        this.remove_listeners();
        this._opt_owner = opt_owner;
        this._opt_class = null;
        this._opt_name = opt_name;
        this.setSelected(Settings.get_bool_option(this._opt_owner, this._opt_name));
        this.setToolTipText(Settings.get_descr(this._opt_owner.getClass(), this._opt_name));
        Settings.register_obj_listener(this._opt_owner, this);
    }

    public void set_class_option(Class<?> opt_class, String opt_name) {
        this.remove_listeners();
        this._opt_owner = null;
        this._opt_class = opt_class;
        this._opt_name = opt_name;
        this.setSelected(Settings.get_bool_option(this._opt_class, this._opt_name));
        this.setToolTipText(Settings.get_descr(this._opt_class, this._opt_name));
        Settings.register_class_listener(this._opt_class, this);
    }

    private void remove_listeners() {
        if (this._opt_owner != null) {
            Settings.remove_obj_listener(this._opt_owner, this);
        }
        if (this._opt_class != null) {
            Settings.remove_class_listener(this._opt_class, this);
        }
    }

    protected void finalize() throws Throwable {
        this.remove_listeners();
        super.finalize();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean show;
        boolean bl = show = e.getStateChange() == 1;
        if (this._opt_owner != null) {
            Settings.set_bool_option(this._opt_owner, this._opt_name, show);
        } else {
            Settings.set_class_bool_option(this._opt_class, this._opt_name, show);
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name.equals(this._opt_name)) {
            if (this._opt_owner != null) {
                this.setSelected(Settings.get_bool_option(this._opt_owner, this._opt_name));
            } else {
                this.setSelected(Settings.get_bool_option(this._opt_class, this._opt_name));
            }
        }
    }
}

